include /usr/share/dpkg/pkg-info.mk

export USE_CMAKE=no

DUNE_DEBIAN_DUNECONTROL ?= /usr/bin/dunecontrol
DUNE_DEBIAN_CONFIGURE_FLAGS ?= \
	--enable-parallel \
	--enable-shared \
	--with-alberta=/usr \
	--with-gmp \
	--without-grape \
	--without-metis \
	--without-parmetis \
	--with-superlu \
	--with-ug=/usr \
	--with-umfpack-includedir=/usr/include/suitesparse --with-umfpack-libdir=/usr/lib \
	--without-x

DUNE_DEBIAN_SHLIB = $(subst ~,.,lib$(DEB_SOURCE)-$(DEB_VERSION_UPSTREAM)-deb8)

override_dh_auto_configure:
	$(DUNE_DEBIAN_DUNECONTROL) autogen
	dh_auto_configure -Sautoconf -- $(DUNE_DEBIAN_CONFIGURE_FLAGS)

override_dh_auto_test:
	# OpenMPI expects rsh/ssh to be in PATH even when it only starts local processes:
	mkdir debian/tmp-test
	ln -s /bin/false debian/tmp-test/ssh
	ln -s /bin/false debian/tmp-test/rsh
	PATH=$(CURDIR)/debian/tmp-test:$$PATH dh_auto_test
	rm -rf debian/tmp-test

override_dh_clean:
	dh_clean
	find . -name Makefile.in -delete
	rm -f aclocal.m4 compile config.guess config.h.in config.sub configure dependencies.m4 depcomp install-sh ltmain.sh missing test-driver
	rm -rf doc/doxygen/Doxyfile.in doc/doxygen/doxyerr.log doc/doxygen/doxygen-tag doc/doxygen/doxygen.log doc/doxygen/html
	rm -rf debian/tmp-test

override_dh_gencontrol:
	dh_gencontrol -- -Vdune:shared-library='$(DUNE_DEBIAN_SHLIB)'

override_dh_makeshlibs:
	dh_makeshlibs --version-info='$(DUNE_DEBIAN_SHLIB)'
