#ifndef INCLUDED_QEINPUT_H
#define INCLUDED_QEINPUT_H

#include <qwidget.h>

/**
 * A base class for libqtecasound input dialogs
 */
class QEInput : public QWidget {
  Q_OBJECT
public:

  /**
   * Class constructor
   */
  QEInput (QWidget *parent = 0, const char *name = 0) : QWidget(parent, name) { }

  ~QEInput(void) { }

public slots:


  /**
   * Enables/activates the inputs
   */
  virtual void enable(void) { setEnabled(true); }
 
  /**
   * Disables the inputs
   */
  virtual void disable(void) { setEnabled(false); }

  /** 
   * Fetch result data from widgets
   */
  virtual void update_results(void) = 0;

signals:

  /**
    * Emitted when input values are changed
    */
  void changed(void);
};

#endif
