/* Emcast - Endhost multicast library
 * Copyright (C) 2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef _EMCAST_PROTOCOL_H
#define _EMCAST_PROTOCOL_H


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define EMCAST_VERSION		0x0001

#define EMCAST_INIT		0x0000
#define EMCAST_JOIN		0x0002
#define EMCAST_LEAVE		0x0003
#define EMCAST_SEND		0x0004
#define EMCAST_RECV		0x0005
#define EMCAST_GETOPT		0x0006
#define EMCAST_SETOPT		0x0007


typedef int (*eminit_func) (unsigned short version, unsigned short* our_version);
typedef int (*emjoin_func) (char* url);
typedef int (*emleave_func) (void);
typedef int (*emsend_func) (char* buf, unsigned short len);
typedef int (*emgetopt_func) (char* optname, void* optval, unsigned short* optlen);
typedef int (*emsetopt_func) (char* optname, void* optval, unsigned short optlen);

typedef struct _Emfuncs
{
  eminit_func		init;
  emjoin_func		join;
  emleave_func		leave;
  emsend_func		send;
  emgetopt_func		getopt;
  emsetopt_func		setopt;

  int			handle_loopback; /* Handle loopback internally?   */
  int			loopback;	 /* 0 = no loopback, 1 = loopback */

} Emfuncs;

void emcast_loop (Emfuncs* emfuncs, int fd_in, int fd_out, int* fd_fifo);
int  emcast_loop_once (Emfuncs* emfuncs, int fd_in, int fd_out, int* fd_fifo);

int emcast_handler_recv (int fd_fifo, 
			 const void* buf, unsigned short len, 
			 const void* from, unsigned short fromlen);


int emcast_parse_url (const char* url, char** protocolp, char** hostnamep, 
		      int* portp, char** filenamep);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _EMCAST_PROTOCOL_H */

