/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-subapp-thread.h,v 1.12 2004/12/12 12:38:57 hoa Exp $
 */

#ifndef ETPAN_SUBAPP_THREAD_H

#define ETPAN_SUBAPP_THREAD_H

#include <libetpan/libetpan.h>
#include "etpan-subapp-types.h"
#include "etpan-thread-manager-types.h"
#include "etpan-subapp-thread-types.h"

/*
  these 3 headers MUST be included before <sys/select.h>
  to insure compatibility with Mac OS X (this is true for 10.2)
*/
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/select.h>

int etpan_subapp_thread_op_add(struct etpan_subapp * app,
    int app_op_type,
    int cmd,
    struct mailstorage * storage,
    struct mailfolder * folder,
    mailmessage * msg,
    struct mailmime * mime,
    void * arg,
    void (* callback)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *),
    void * data,
    void (* handle_cancel)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *));

void etpan_subapp_thread_cancel_all(struct etpan_subapp * app);

void etpan_subapp_thread_set_fd(struct etpan_subapp * app,
    fd_set * fds, int * maxfd);

void etpan_subapp_thread_handle_fd(struct etpan_subapp * app,
    fd_set * fds);

int etpan_subapp_thread_has_match_op(struct etpan_subapp * app,
    int app_op_type,
    struct mailstorage * storage, struct mailfolder * folder,
    mailmessage * msg, struct mailmime * mime);

#if 0
int etpan_queue_ref_msg_mime(struct etpan_subapp * app,
    struct mailfolder * folder,
    mailmessage * msg);

int etpan_queue_unref_msg_mime(struct etpan_subapp * app,
    struct mailfolder * folder,
    mailmessage * msg);

int etpan_queue_ref_msg(struct etpan_subapp * app,
    struct mailfolder * folder,
    mailmessage * msg);

int etpan_queue_unref_msg(struct etpan_subapp * app,
    struct mailfolder * folder,
    mailmessage * msg);
#endif

int etpan_queue_ref_msg_mime(struct etpan_subapp * app,
    mailmessage * msg);

int etpan_queue_unref_msg_mime(struct etpan_subapp * app,
    mailmessage * msg);

int etpan_queue_ref_msg(struct etpan_subapp * app,
    mailmessage * msg);

int etpan_queue_unref_msg(struct etpan_subapp * app,
    mailmessage * msg);

int etpan_subapp_thread_msg_op_add(struct etpan_subapp * app,
    int app_op_type,
    int cmd,
    mailmessage * msg,
    struct mailmime * mime,
    void * arg,
    void (* callback)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *),
    void * data,
    void (* handle_cancel)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *));

int etpan_subapp_thread_folder_op_add(struct etpan_subapp * app,
    int app_op_type,
    int cmd,
    struct mailfolder * folder,
    mailmessage * msg,
    struct mailmime * mime,
    void * arg,
    void (* callback)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *),
    void * data,
    void (* handle_cancel)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *));

void etpan_free_msg_list(struct etpan_subapp * app,
    struct mailmessage_tree * env_tree,
    struct etpan_node_msg_params * node_params);

int etpan_subapp_thread_abook_op_add(struct etpan_subapp * app,
    int app_op_type,
    int cmd,
    struct etpan_abook * abook,
    void * arg,
    void (* callback)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *),
    void * data,
    void (* handle_cancel)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *));

int etpan_subapp_thread_sender_op_add(struct etpan_subapp * app,
    int app_op_type,
    int cmd,
    struct etpan_sender_item * sender,
    void * arg,
    void (* callback)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *),
    void * data,
    void (* handle_cancel)(struct etpan_subapp *,
        struct etpan_thread_op *, int, void *));

#endif
