/*
 * Copyright  CNRS, INRIA, Universit Bordeaux 1
 * See COPYING in top-level directory.
 */

# include <stdlib.h>
# include <stdio.h>
# include <time.h>
# include <omp.h>

#define SIZE (1024*1024*8)

int main(void)
{
	int i;
	int *A = malloc(sizeof(int)*SIZE);
	int *B = malloc(sizeof(int)*SIZE);
	int *C = malloc(sizeof(int)*SIZE);

	for(i=0;i<SIZE; i++)
	{
		A[i]=i*17%7;
		B[i]=i*19%7;
		C[i]=0;
	}


//compute for real!
	int j;
	for(j=0;j<10; j++) {
		printf("loop %d\n", j);
		printf("\trunning parallel for schedule(static)\n");
#pragma omp parallel for schedule(static)
 		for(i=0;i<SIZE; i++)
 		{
 			C[i]=A[i]+B[i];
 		}

		printf("\trunning parallel for schedule(runtime)\n");
#pragma omp parallel for schedule(runtime)
 		for(i=0;i<SIZE; i++)
 		{
 			C[i]=A[i]+B[i];
 		}

		printf("\trunning parallel for schedule(dynamic)\n");
#pragma omp parallel for schedule(dynamic)
		for(i=0;i<SIZE; i++)
		{
			C[i]=A[i]+B[i];
		}

		printf("\trunning parallel for schedule(guided)\n");
#pragma omp parallel for schedule(guided)
 		for(i=0;i<SIZE; i++)
 		{
 			C[i]=A[i]+B[i];
 		}
	}
	return 0;
}
