#
# gaim_major_ver and gaim_minor_ver should be defined to match the minimum
# Gaim API version _required_ to build gaim-xmms-remote
# Due to the way Gaim checks plugin versions, we need to also ensure that
# the correct minimum version of Gaim is Require:'d based on what version of
# the Gaim headers we actually build with.
#

%define gaim_major_ver 2
%define gaim_minor_ver 0
%define gaim_next_major_ver %(echo $((%{gaim_major_ver}+1)))
%define gaim_build_minor_ver %(pkg-config --modversion gaim | awk -F. '{ print $2 }')

Summary:    XMMS Remote Plugin for Gaim
Name:       gaim-xmms-remote
Version:    1.9beta3
Release:    0%{?gaimdist:.%{gaimdist}}
License:    GPL
Group:      Applications/Internet
Url:        http://guifications.sourceforge.net/
Source:     gaim-xmms-remote-%{version}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-%{version}-root

Requires:   gaim >= 1:%{gaim_major_ver}.%{gaim_build_minor_ver}, gaim < 1:%{gaim_next_major_ver}

BuildRequires: pkgconfig, libtool, xmms-devel
BuildRequires: gaim-devel >= 1:%{gaim_major_ver}.%{gaim_minor_ver}, gaim-devel < 1:%{gaim_next_major_ver}

%if "%{_vendor}" == "MandrakeSoft" || "%{_vendor}" == "Mandrakesoft"
BuildRequires: libgtk+2.0_0-devel
%else
BuildRequires: gtk2-devel
%endif

%description
Gaim XMMS Remote is a remote control plugin for Gaim to control XMMS

To rebuild for a specific Gaim version or dist tag:
rpmbuild --rebuild gaim-xmms-remote-1.9beta3-%{release}.src.rpm --define 'gaimdist %{!?gaimdist:fc1}%{?gaimdist:%{gaimdist}}'

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix}

make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

strip $RPM_BUILD_ROOT%{_libdir}/gaim/*.so || :
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/gxr.la $RPM_BUILD_ROOT%{_libdir}/gaim/gxr.a

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc README ChangeLog
%{_libdir}/gaim/gxr.so
%dir %{_datadir}/pixmaps/gaim/gxr
%{_datadir}/pixmaps/gaim/gxr/*

%changelog
* Thu Nov 03 2005 Stu Tomlinson <stu@nosnilmot.com>
- Remove Mandrake workaround that hopefully is no longer required.
- Really update the version checking to match the other specfiles, instead
  of just pretending to.
- gtk+ 1.x build dep should be pulled in by xmms-devel

* Thu Nov 03 2005 Peter Lawler <bleeter@users.sf.net>
- 'Fixed up' the mandrake entries.

* Thu Nov 03 2005 Peter Lawler <bleeter@users.sf.net>
- Changed Gaim version check to match other guifications project specfiles

* Tue Oct 12 2004 Stu Tomlinson <stu@nosnilmot.com>
- Add Gaim version checks to match new Gaim versioning

* Fri Jun 25 2004 Stu Tomlinson <stu@nosnilmot.com>
- Update for Gaim 0.79

* Thu May 27 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweak to allow both .src.rpm and .nosrc.rpm to be generated
  from a dist tarball.

* Wed Mar 24 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweak!

* Tue Mar 02 2004 Stu Tomlinson <stu@nosnilmot.com>
- Initial spec file
