namespace GalagoGtk.Tests
{
	using Gtk;
	using GtkSharp;
	using System;
	using Galago;
	using Galago.Gtk;

	public class TestChooser
	{
		private Window mWindow;

		public TestChooser()
		{
			Application.Init();

			DBus.Bus.GetSessionBus();

			if (!Galago.Global.Init("test-chooser"))
			{
				Application.Quit();
				return;
			}

			mWindow = new Window("Galago Chooser Test");
			mWindow.Show();
			mWindow.BorderWidth = 12;
			mWindow.DeleteEvent += new DeleteEventHandler(Window_Delete);

			VBox mainVBox = new VBox(false, 6);
			mainVBox.Show();
			mWindow.Add(mainVBox);

			Button button = new Button("Contacts Chooser");
			button.Show();
			mainVBox.PackStart(button, false, true, 0);
			button.Clicked += new EventHandler(Contacts_Clicked);

			Application.Run();
		}

		private void Window_Delete(object obj, DeleteEventArgs args)
		{
			Application.Quit();
		}

		private void Contacts_Clicked(object obj, EventArgs args)
		{
			ContactChooserDialog dialog = new ContactChooserDialog(
				"Select a Contact", mWindow, ContactChooserFlags.Contacts);
			dialog.Show();
			dialog.AddButton(Gtk.Stock.Add, ResponseType.None);
		}

		public static void Main(string[] args)
		{
			new TestChooser();
		}
	}
}
