/* Copyright (C) 2000 Damir Zucic */

/*=============================================================================

				translate.c

Purpose:
	Translate all caught  macromolecular complexes.  TranslateComplex_
	function takes care for stereo data and for position_changedF.

Input:
	(1) Pointer to MolComplexS structure, with macromol. complexes.
	(2) Number of macromolecular complexes.
	(3) Pointer to ConfigS structure.
	(4) Translation shift.
	(5) Translation direction (axis) identifier (1 = x, 2 = y, 3 = z).

Output:
	(1) Atoms translated in all caught macromolecular complexes.

Return value:
	No return value.

========includes:============================================================*/

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "typedefs.h"

/*======function prototypes:=================================================*/

void		TranslatePlane_ (MolComplexS *, VectorS *);
void		TranslateComplex_ (MolComplexS *, VectorS *, ConfigS *);

/*======translate all caught macromol. complexes:============================*/

void Translate_ (MolComplexS *mol_complexSP, int mol_complexesN,
		 ConfigS *configSP,
		 double shift, int axisID)
{
VectorS			shift_vectorS;
int			mol_complexI;
MolComplexS		*curr_mol_complexSP;

/* Prepare the shift vector: */
switch (axisID)
	{
	case 1:
		shift_vectorS.x = shift;
		shift_vectorS.y = 0.0;
		shift_vectorS.z = 0.0;
		break;

	case 2:
		shift_vectorS.x = 0.0;
		shift_vectorS.y = shift;
		shift_vectorS.z = 0.0;
		break;

	case 3:
		shift_vectorS.x = 0.0;
		shift_vectorS.y = 0.0;
		shift_vectorS.z = shift;
		break;

	default:
		;
		break;
	}

for (mol_complexI = 0; mol_complexI < mol_complexesN; mol_complexI++)
	{
	/* Pointer to the current macromolecular complex: */
	curr_mol_complexSP = mol_complexSP + mol_complexI;

	/* Check is the current macromolecular complex caught: */
	if (curr_mol_complexSP->catchF == 0) continue;

	/* Check is it necessary to translate the plane: */
	if (curr_mol_complexSP->move_bits & PLANE_MASK)
		{
		TranslatePlane_ (curr_mol_complexSP, &shift_vectorS);
		}

	/* Check is it necessary to translate the structure at all: */
	if (!(curr_mol_complexSP->move_bits & STRUCTURE_MASK)) continue;

	/* Translate the complex (stereo data updated too): */
	TranslateComplex_ (curr_mol_complexSP, &shift_vectorS, configSP);
	}
}

/*===========================================================================*/


