/* Copyright (C) 2000 Damir Zucic */

/*=============================================================================

				write_hints.c

Purpose:
	Write some hints to the hidden pixmap.

Input:
	(1) Pointer to GUIS structure, with GUI data.

Output:
	(1) Some hints (textual information) written to hidden pixmap.
	(2) Return value.

Return value:
	(1) Positive always (trivial).

========includes:============================================================*/

#include <stdio.h>

#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "typedefs.h"

/*======write some hints to the hidden pixmap:===============================*/

int WriteHints_ (GUIS *guiSP)
{
int		screen_x, screen_y, delta_y;
char		stringA[STRINGSIZE];

/* Prepare the text color: */
XSetForeground (guiSP->displaySP, guiSP->theGCA[0],
		guiSP->main_winS.fg_colorID);


/* Draw hints: */
delta_y = guiSP->input_winS.text_line_height;
screen_x = 10;

screen_y = 60 + delta_y;
strcpy (stringA, "Home page: http://pref.etfos.hr/garlic");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "HTML documentation:");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 40;

screen_y += delta_y;
strcpy (stringA,
	"http://pref.etfos.hr/controls (rotations, translations etc.)");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "http://pref.etfos.hr/commands (garlic command language)");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "http://pref.etfos.hr/refcard (reference card -> print it!)");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 10;

screen_y += delta_y;
strcpy (stringA, "Documentation (packed -> download via ftp):");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 40;

screen_y += delta_y;
strcpy (stringA, "ftp://pref.etfos.hr/pub/garlic/source/garlic-doc.tar.gz");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 10;

screen_y += delta_y;
strcpy (stringA, "License (GPL): http://pref.etfos.hr/garlic/license");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "Author: http://pref.etfos.hr/zucic");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += 2 * delta_y;
strcpy (stringA, "Encourage garlic development - type reg to register!");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

/* Return positive value (trivial): */
return 1;
}

/*===========================================================================*/


