/* Copyright (C) 2000 Damir Zucic */

/*=============================================================================

				select_to_stdout.c

Purpose:
	Print the content of selectS structure to stdout. This function may
	be used for debugging purpose.

Input:
	(1) Pointer to SelectS structure.

Output:
	(1) The content of SelectS structure printed to stdout.

Return value:
	No return value.

========includes:============================================================*/

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "typedefs.h"

/*======print the content of SelectS to stdout:==============================*/

void SelectToStdout_ (SelectS *selectSP)
{
int		i;

printf ("===================================\n");
printf ("all_chainsF: %d\n", selectSP->all_chainsF);
printf ("chainsN: %d\n", selectSP->chainsN);
for (i = 0; i < selectSP->chainsN; i++)
	printf (" <%c>", selectSP->chainIDA[i]);
printf ("\n");

printf ("all_residue_serialF: %d\n", selectSP->all_residue_serialF);
printf ("residue_serial_rangesN = %d\n",
	selectSP->residue_serial_rangesN);
for (i = 0; i < selectSP->residue_serial_rangesN; i++)
        printf (" %d %d\n",
		selectSP->residue_serial_start[i],
		selectSP->residue_serial_end[i]);
printf ("\n");

printf ("all_residue_namesF: %d\n", selectSP->all_residue_namesF);
printf ("residue_namesN = %d\n", selectSP->residue_namesN); 
for (i = 0; i < selectSP->residue_namesN; i++)
        printf (" <%s>", selectSP->residue_nameAA[i]);
printf ("\n"); 

printf ("all_atom_namesF: %d\n", selectSP->all_atom_namesF);
printf ("atom_namesN = %d\n", selectSP->atom_namesN);
for (i = 0; i < selectSP->atom_namesN; i++)
        printf (" <%s>", selectSP->atom_nameAA[i]);
printf ("\n");

}

/*===========================================================================*/


