{
RTS initialization

Copyright (C) 1999 Free Software Foundation, Inc.

Authors: Frank Heckenbach <frank@pascal.gnu.de>

This file is part of the GNU Pascal Library. The GNU Pascal
Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

The GNU Pascal Library is distributed in the hope that it will
be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit Init;

interface

uses Internal, String, Error, String2, GetOpt;

var
  RTSWarnFlag : asmname '_p_warn' Boolean;
  RTSWarnFlag : Boolean = False;

{ Simple options for the run time system from command line
  Since the normal use of the command line is pass args to
  the user program, passing args to the runtime system
  is made somewhat complicated:

  First arg has to be `-Grts'.
  Other flags that the RTS recognizes (if the first
  arg is `-Grts') are output with `-h' option (see below).
  `--' indicates end of rts parameters. }
procedure GPC_Init_Arguments; asmname '_p_init_arguments';

procedure GPC_Initialize (ArgumentCount : Integer; Arguments, StartEnvironment : GPC_PCStrings); asmname '_p_initialize';

implementation

{$I-,B-}

{ Declare a variable whose presence can be checked at link time
  to ensure that the correct RTS version is linked. }
{$ifndef RTS_RELEASE_STRING}
{$error RTS_RELEASE_STRING not set! Please compile this file properly from
the Makefile, or define that symbol manually if you know what you are doing.}
{$endif}
var
  RTSReleaseCheck : asmname RTS_RELEASE_STRING Integer;
  RTSReleaseCheck : Integer = $47525453;

procedure GPC_Init_Arguments;
var
  ArgsDone : static Boolean = False;
  HelpFlag, NoSkip : Boolean;
  SkipArgs, i, p : Integer;
  c : Char;
  Name : TString;
  ap : PFileAssociation;
  StdFile : ^Text = nil; { `-i' option strings written here, and given
                           as standard input to user program }
begin
  if ArgsDone or (CParameters = nil) then Exit;
  ArgsDone := True;
  GPC_Init_Heap;
  HelpFlag := False;
  NoSkip := False;
  SkipArgs := 0;
  if (CParamCount > 1) and (CStringComp (CParameters^[1], '-Grts') = 0) then
    repeat
      c := GetOpt ('edwfsNhi:a:G:');
      if c = EndOfOptions then Break;
      Inc (SkipArgs);
      case c of
        'G' : if (SkipArgs <> 1) or (OptionArgument <> 'rts') then
                begin
                  { Arg is not for us, so get out }
                  Dec (FirstNonOption);
                  Break
                end;
        'e' : EOLnResetHack := not EOLnResetHack;
        'f' : ForceDirectFiles := not ForceDirectFiles;
        's' : NoSkip := True;
        'h' : HelpFlag := True;
        'w' : RTSWarnFlag := True;
        {$ifdef DEBUG}
        'd' : Inc (RTSDebugFlag);
        {$endif}
        'i' : begin
                if StdFile = nil then
                  begin
                    New (StdFile);
                    Rewrite (Stdfile^)
                  end;
                Writeln (StdFile^, OptionArgument)
              end;
        'a' : begin
                p := Pos (':', OptionArgument);
                if p = 0 then
                  begin
                    Writeln (StdErr, ParamStr (0), ': invalid `-a'' option');
                    HelpFlag := True
                  end
                else
                  begin
                    New (ap);
                    ap^.Next := FileAssociation;
                    ap^.IntName := NewCString (Copy (OptionArgument, 1, p - 1));
                    ap^.ExtName := NewCString (Copy (OptionArgument, p + 1));
                    FileAssociation := ap
                  end
              end;
        else
          Dec (FirstNonOption);
          Break
      end
    until False;
  if HelpFlag then
    begin
      Write (StdErr, 'Allowed GNU Pascal program command line options for run time system:' + NewLine +
                     '  -h : give this help text and exit with status 1' + NewLine +
                     {$ifdef DEBUG}
                     '  -d : debug flag (one or more) Internal RTS reports' + NewLine +
                     {$endif}
                     '  -w : give runtime warning messages' + NewLine +
                     '  -e : toggle EOLn handling right after reset for TTY' + NewLine +
                     '  -f : toggle forcing direct access files' + NewLine +
                     '  -s : let the program see RTS command line arguments' + NewLine +
                     '  -i : each option makes one line to standard input' + NewLine +
                     '  -a : associate file names. -a Pascal_File:External_Name' + NewLine +
                     '  -- : rest of the args are not for the run time system' + NewLine);
      Halt (1)
    end;
  { Make RTS arguments invisible to the program unless the `-s' parameter was given. }
  if (SkipArgs <> 0) and not NoSkip then
    begin
      for i := 1 to CParamCount - FirstNonOption do { Leave argument #0 as it is. }
        CParameters^[i] := CParameters^[i + FirstNonOption - 1];
      Dec (CParamCount, FirstNonOption - 1)
    end;
  if StdFile <> nil then
    begin
      Reset (StdFile^);
      CurrentStdIn := StdFile
    end
end;

procedure GPC_Initialize (ArgumentCount : Integer; Arguments, StartEnvironment : GPC_PCStrings);
begin
  CParamCount := ArgumentCount;
  CParameters := Arguments;
  GPC_Init_Heap;
  GPC_Init_Signals;
  GPC_Initialize_StdErr;
  (*@@iocritical*)CheckInOutRes;
  GPC_Init_Environment (StartEnvironment);
  GPC_Init_Arguments;
  GPC_Initialize_Std_Files;
  (*@@iocritical*)CheckInOutRes;
  GPC_Init_Misc;
  GPC_Init_Time;
  GPC_Run_Constructors
end;

end.
