/*
Global run time system definitions.

Copyright (C) 1991-99 Free Software Foundation, Inc.

Authors: Jukka Virtanen <jtv@hut.fi>
         J.J. van der Heijden <j.j.vanderheijden@student.utwente.nl>
         Frank Heckenbach <frank@pascal.gnu.de>

This file is part of the GNU Pascal Library. The GNU Pascal
Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

The GNU Pascal Library is distributed in the hope that it will
be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* Edit history:

   15 6 85: First version for Pax compiler at HUT.FI.

   Later (89?) I converted this for GNU Pascal compiler (GPC).

   The run time system is rewritten for GPC and it should support
   all features of the Extended Pascal Standard.

   July '96 : adapted for GNU autoconf <j.j.vanderheijde@student.utwente.nl>
*/

/* Created by autoconf */
#include "rts-config.h"

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <dirent.h>
#include <signal.h>

#ifndef errno
extern int errno;
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif

/* Placeholders for signals not present in all systems */
#ifndef SIGHUP
#define SIGHUP 0
#endif
#ifndef SIGINT
#define SIGINT 0
#endif
#ifndef SIGQUIT
#define SIGQUIT 0
#endif
#ifndef SIGILL
#define SIGILL 0
#endif
#ifndef SIGABRT
#ifdef SIGIOT
#define SIGABRT SIGIOT
#else
#define SIGABRT 0
#endif
#endif
#ifndef SIGFPE
#define SIGFPE 0
#endif
#ifndef SIGKILL
#define SIGKILL 0
#endif
#ifndef SIGSEGV
#define SIGSEGV 0
#endif
#ifndef SIGPIPE
#define SIGPIPE 0
#endif
#ifndef SIGALRM
#define SIGALRM 0
#endif
#ifndef SIGTERM
#define SIGTERM 0
#endif
#ifndef SIGUSR1
#define SIGUSR1 0
#endif
#ifndef SIGUSR2
#define SIGUSR2 0
#endif
#ifndef SIGCHLD
#ifdef SIGCLD
#define SIGCHLD SIGCLD
#else
#define SIGCHLD 0
#endif
#endif
#ifndef SIGCONT
#define SIGCONT 0
#endif
#ifndef SIGSTOP
#define SIGSTOP 0
#endif
#ifndef SIGTSTP
#define SIGTSTP 0
#endif
#ifndef SIGTTIN
#define SIGTTIN 0
#endif
#ifndef SIGTTOU
#define SIGTTOU 0
#endif
#ifndef SIGTRAP
#define SIGTRAP 0
#endif
#ifndef SIGEMT
#define SIGEMT 0
#endif
#ifndef SIGBUS
#define SIGBUS 0
#endif
#ifndef SIGSYS
#define SIGSYS 0
#endif
#ifndef SIGSTKFLT
#define SIGSTKFLT 0
#endif
#ifndef SIGURG
#define SIGURG 0
#endif
#ifndef SIGIO
#ifdef SIGPOLL
#define SIGIO SIGPOLL
#else
#define SIGIO 0
#endif
#endif
#ifndef SIGXCPU
#define SIGXCPU 0
#endif
#ifndef SIGXFSZ
#define SIGXFSZ 0
#endif
#ifndef SIGVTALRM
#define SIGVTALRM 0
#endif
#ifndef SIGPROF
#define SIGPROF 0
#endif
#ifndef SIGPWR
#ifdef SIGINFO
#define SIGPWR SIGINFO
#else
#define SIGPWR 0
#endif
#endif
#ifndef SIGLOST
#define SIGLOST 0
#endif
#ifndef SIGWINCH
#define SIGWINCH 0
#endif

#ifdef DEBUG
#define D(level, x) do if (_p_debug >= level) x; while (0)
#else
#define D(level, x)
#endif

#ifndef PROTO
#if defined (USE_PROTOTYPES) ? USE_PROTOTYPES : defined (__STDC__)
#define PROTO(ARGS) ARGS
#else
#define PROTO(ARGS) ()
#endif
#endif

#ifdef MACH
extern void *malloc PROTO ((size_t));
#endif

#include "types.h"

#define NEWPAGE '\f' /* Page writes this */
#define NEWLINE '\n' /* Writeln writes this */
#define TRUE  1
#define FALSE 0

#ifndef FALSE_str
#define FALSE_str "False" /* For Write (Boolean) */
#endif

#ifndef TRUE_str
#define TRUE_str "True"
#endif

#define EOT '\004' /* File name queries abort if first char is EOT */

/* Signal handling types */
#define NONE   (0)
#define UND    (-1)
#define FAST   (-2)

/* error message handling codes */
#define ABORT  (-1)
#define REPORT (-2)
#define IGNORE (-3)

/* General purpose macros */
#define isdigit(ch) ((ch) >= '0' && (ch) <= '9')
#define isspace(ch) ((ch) == ' ' || (ch) == '\t')
#define isspace_nl(ch) (isspace(ch) || (ch) == '\n')

typedef long long int longestint;

typedef enum { NoRangeCheck, SignedRangeCheck, UnsignedRangeCheck } TRangeCheck;

/* association list for internal and external file names set with
   the `-a int_name:ext_name' option (int_name is the file name in
   your program, case is irrelevant) */
typedef struct FileAssociation
{
  struct FileAssociation *Next;
  const char *int_name, *ext_name;
} FileAssociation;

typedef struct
{
  longestint f_block_size, f_blocks_total, f_blocks_free;
  int        f_files_total, f_files_free;
} statfsbuf;

typedef struct
{
  int    count;
  char **result;
  void  *buf;
} globbuffer;

typedef struct
{
  FDR File;
  Boolean WantedReadOrEOF,
          WantedRead,
          WantedEOF,
          WantedWrite,
          WantedException,
          WantedAlways,
          OccurredReadOrEOF,
          OccurredRead,
          OccurredEOF,
          OccurredWrite,
          OccurredException;
} InternalIOSelectType;

typedef struct {
  char *UserName, *RealName, *Password, *HomeDirectory, *Shell;
  int UID, GID;
} TCPasswordEntry;

/* read.c */
extern void   _p_read_buffer PROTO ((FDR));
extern int    _p_internal_getc PROTO ((FDR));
extern signed long long _p_readi_check PROTO ((FDR, TRangeCheck, signed long long, signed long long));
extern signed long long _p_readi PROTO ((FDR));
extern long double _p_read_longreal PROTO ((FDR));
extern float  _p_read_shortreal PROTO ((FDR));
extern double _p_read_real PROTO ((FDR));
extern char   _p_read_char PROTO ((FDR));
extern int    _p_read_string PROTO((FDR, char *, int));
extern void   _p_readln PROTO ((FDR));
extern void   _p_read_init PROTO ((FDR, int));
extern void   _p_readstr_init PROTO ((FDR, char *, int, int));
extern void   _p_val_init PROTO ((FDR, char *, int, int));
extern int    _p_get_val_return_value PROTO ((FDR));

/* write.c */
extern void    _p_internal_fwrite PROTO ((const void *,size_t,size_t *,FDR));
extern void    _p_write_flush PROTO ((FDR));
extern void    _p_write_integer  PROTO ((FDR, signed int, int));
extern void    _p_write_longint  PROTO ((FDR, signed long long, int));
extern void    _p_write_cardinal PROTO ((FDR, unsigned int, int));
extern void    _p_write_longcard PROTO ((FDR, unsigned long long, int));
extern void    _p_write_real PROTO ((FDR, long double, int, int));
extern void    _p_write_char PROTO ((FDR, char, int));
extern void    _p_write_boolean PROTO ((FDR, int, int));
extern void    _p_write_string PROTO ((FDR, char *, int, int));
extern void    _p_writeln PROTO ((FDR));
extern void    _p_write_init PROTO ((FDR, int));
extern void    _p_writestr_init PROTO ((FDR, char *, int, int));
extern int     _p_writestr_getlength PROTO ((FDR));

/* numtodec.pas */
extern int     _p_pid;
extern int     _p_low_integer;
extern char   *_p_card_to_decimal     PROTO((unsigned int, char *));
extern char   *_p_longcard_to_decimal PROTO((unsigned long long, char *));
extern char   *_p_longreal_to_decimal PROTO((long double, int, int, int, int, int, int *));

/* file.c */
extern void   _p_inittfdd PROTO((FDR));
extern void   _p_initfdr PROTO((FDR, const char *, int, int));
extern void   _p_fdrchain PROTO((FDR, int));
extern int    _p_checkfiletype PROTO((FDR, TOpenMode, int));
extern void   _p_open PROTO ((FDR, TOpenMode));
extern int    _p_seek PROTO ((FDR, int, int, int));
extern void   _p_clearbuffer PROTO((FDR));
extern void   _p_f_flush PROTO((void *));
extern void   _p_flush PROTO((FDR));
extern FILE  *_p_getfile PROTO((FDR));
extern int    _p_filehandle PROTO((FDR));
extern void   _p_rewrite PROTO((FDR,char *,int));
extern void   _p_extend  PROTO((FDR,char *,int));
extern void   _p_reset   PROTO((FDR,char *,int));
extern int    _p_ok_READ PROTO((FDR));
extern int    _p_ok_EOF PROTO((FDR));
extern int    _p_ok_WRITE PROTO((FDR));
extern size_t _p_f_read     PROTO((void *,char *,size_t));
extern size_t _p_f_read_tty PROTO((void *,char *,size_t));
extern size_t _p_f_write PROTO((void *,const char *,size_t));
extern void   _p_getbyte PROTO((FDR));
extern void   _p_get PROTO((FDR));
extern void   _p_got PROTO((FDR));
extern void   _p_lazytryget PROTO((FDR));
extern void   _p_lazyget PROTO((FDR));
extern void   _p_lazyunget PROTO((FDR));
extern Boolean _p_canread PROTO((FDR));
extern int    _p_eof PROTO((FDR));
extern int    _p_eoln PROTO((FDR));
extern void   _p_page PROTO((FDR));
extern void   _p_put PROTO((FDR));
extern const char *_p_filename PROTO((const FDR));
extern const char *_p_get_file_name PROTO((const FDR));
extern void   _p_erase   PROTO((FDR));
extern void   _p_rename  PROTO((FDR,char *));
extern void   _p_chdir   PROTO((char *));
extern void   _p_mkdir   PROTO((char *));
extern void   _p_rmdir   PROTO((char *));
extern char  *_p_readdir_c PROTO((DIR *));
extern void   _p_closedir PROTO((DIR *));
extern void   _p_chmod   PROTO((FDR, int));
extern void   _p_set_file_time PROTO((FDR, UnixTimeType));
extern void   _p_statfs  PROTO((char *,statfsbuf *));
extern int    _p_fnmatch PROTO ((const char *, const char *));
extern void   _p_globon PROTO ((globbuffer *gbuf, char *pattern));
extern void   _p_globfree PROTO ((globbuffer *gbuf));
extern void   _p_extend PROTO((FDR,char *,int));
extern void   _p_close PROTO((FDR));
extern void   _p_donefdr PROTO((FDR));
extern int    _p_select PROTO ((InternalIOSelectType *, int, int, MicroSecondTimeType));

/* bind.c */
extern void   _p_bind    PROTO((FDR, const GPC_BINDING *));
extern void   _p_clearbinding PROTO ((GPC_BINDING *));
extern void   _p_binding PROTO((const FDR, GPC_BINDING *));
extern void   _p_unbind  PROTO((FDR));
extern void   _p_assign_tfdd PROTO ((FDR, TOpenProc, TSelectFunc, TSelectProc, TReadFunc, TWriteFunc, TFlushProc, TCloseProc, TDoneProc, void *));
extern void   _p_set_tfdd PROTO ((FDR, TOpenProc, TSelectFunc, TSelectProc, TReadFunc, TWriteFunc, TFlushProc, TCloseProc, TDoneProc, void *));
extern void   _p_get_tfdd PROTO ((FDR, TOpenProc *, TSelectFunc *, TSelectProc *, TReadFunc *, TWriteFunc *, TFlushProc *, TCloseProc *, TDoneProc *, void **));

/* files.pas */
extern void   _p_internal_assign PROTO ((FDR,const char *,int));

/* randfile.c */
extern void   _p_seekall PROTO((FDR,int));
extern void   _p_seekwrite PROTO((FDR,int));
extern void   _p_seekread PROTO((FDR,int));
extern void   _p_seekupdate PROTO((FDR,int));
extern int    _p_empty PROTO((const FDR));
extern void   _p_update PROTO((FDR));
extern int    _p_position PROTO((FDR));
extern int    _p_lastposition PROTO((FDR));
extern void   _p_definesize PROTO((FDR,int));
extern int    _p_getsize PROTO((FDR));
extern void   _p_truncate PROTO((FDR));
extern void   _p_blockread  PROTO ((FDR,       char *, unsigned int, unsigned int *));
extern void   _p_blockwrite PROTO ((FDR, const char *, unsigned int, unsigned int *));

/* heap.pas */
extern void   _p_dispose PROTO ((const void *));
extern void  *_p_malloc PROTO ((size_t));
extern void   _p_free PROTO ((void *));
extern void   _p_gpc_realloc PROTO ((void **, size_t));
extern void   _p_heap_init PROTO ((void));

/* rt0.c */
extern int    _p_signal, _p_sigcause, _p_debug, _p_argc, _p_pid;
extern const char **_p_argv;
extern Boolean _p_eoln_reset_hack;
extern Boolean _p_force_direct_files;
extern struct Fdr _p_stdin;
extern struct Fdr _p_stdout;
extern struct Fdr _p_stderr;
extern FDR    _p_current_stdin;
extern FileAssociation *_p_FileAssociation;
extern void   _p_init_heap PROTO((void));
extern void   _p_update_pid PROTO((void));
extern void   _p_init_misc PROTO((void));
extern void   _p_init_signals PROTO((void));
extern void   _p_initialize_std_files PROTO ((void));
extern void   _p_initialize_stderr PROTO ((void));
extern void   _p_run_constructors PROTO((void));
extern void   _p_exit PROTO((int));
extern void   _p_done_files PROTO((void));
extern void   _p_fflush PROTO((Boolean));
extern int    _p_restore_stdin PROTO((FDR));

/* filename.pas */
extern char    _p_dirseparatorvar;
extern Boolean _p_isdirseparator PROTO((char));
extern char   *_p_get_temp_file_name_cstring PROTO((void));
extern char   *_p_osdirseparator2slash_cstring PROTO ((char *));

/* string.pas */
extern size_t  _p_strlen PROTO((const char *));
extern char   *_p_strdup PROTO((const char *));
extern int     _p_strcasecmp PROTO ((const char *,const char *));
extern int     _p_strcmp     PROTO ((const char *, const char *));
extern char   *_p_strlcpy    PROTO ((char *, const char *, size_t));
extern char   *_p_strscan    PROTO ((const char *, char));
extern char   *_p_strrscan   PROTO ((const char *, char));
extern char   *_p_strlower PROTO ((char *));
extern Boolean _p_str_eq PROTO((char *, int, char *, int));
extern Boolean _p_str_lt PROTO((char *, int, char *, int));
extern Boolean _p_eq     PROTO((char *, int, char *, int));
extern Boolean _p_lt     PROTO((char *, int, char *, int));
extern int     _p_index  PROTO((char *, int, char *, int));
extern int     _p_trim   PROTO((char *, int, char *));
extern int     _p_substr PROTO((char *, int, int, int, char *, Boolean));

/* move.pas */
extern void    _p_move PROTO ((const void *, void *, size_t));

/* error.pas */
extern int    _p_inoutres;
extern char  *_p_inoutres_str;
extern void   _p_heap_warning PROTO((const char *));
extern char  *_p_errmsg PROTO((int));
extern char  *_p_check_errmsg PROTO((int,const char *));
extern void   _p_prmessage PROTO((const char *,int,Boolean));
extern void   _p_error PROTO((int));
extern void   _p_error_integer PROTO((int,long int));
extern void   _p_error_string PROTO((int,const char *));
extern void   _p_internal_error PROTO((int));
extern void   _p_internal_error_integer PROTO((int,long int));
extern void   _p_io_error PROTO((int));
extern void   _p_io_error_string PROTO((int,const char *));
extern void   _p_check_inoutres PROTO((void));
extern void   _p_warning PROTO((const char *));
extern void   _p_warning_integer PROTO((const char *,long int));
extern void   _p_warning_string PROTO((const char *,const char *));
extern void   _p_start_temp_io_error PROTO((void));
extern int    _p_end_temp_io_error PROTO((void));

#define IOERROR(err,retval) do {_p_io_error(err); return retval;} while (0)
#define IOERROR_STRING(err,str,retval) do {_p_io_error_string(err,str); return retval;} while (0)
#define IOERROR_FILE(err,file,retval) IOERROR_STRING(err,_p_get_file_name(file),retval)
