/*
Dos/PDCurses specific include file for crtc.c

This file implements the functions, as described in crtdummy.h, for a
Dos system using PDCurses 2.3. Everything except changing the number
of screen columns is implemented.

Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As a special exception, if you link this library with files compiled
with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU Library General
Public License. This exception does not however invalidate any other
reasons why the executable file might be covered by the GNU Library
General Public License.
*/

#include <pc.h>
#include <bios.h>
#include <go32.h>

/* #include <conio.h> -- conflicts with curses */ extern void clrscr (void);
#define clear_terminal clrscr

static void int_handler (int sig)
{
  (void) sig;
  if (crt_CheckBreak) /* PDCurses under DJGPP gets a SIGINT for Ctrl-C even in raw mode */
    crt_signal_handler (0x100 * ksInt);
  signal (SIGINT, &int_handler);
}

static void term_handler (int sig)
{
  (void) sig;
  crt_signal_handler (0x100 * ksTerm);
  signal (SIGTERM, &term_handler);
}

static void hup_handler (int sig)
{
  (void) sig;
  crt_signal_handler (0x100 * ksHUp);
  signal (SIGHUP, &hup_handler);
}

static void crt_schedule_refresh ()
{
  crt_refresh ();
}

static void crt_stop_refresh ()
{
}

static void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
  resize_term (Lines50 ? 50 : 25, Columns40 ? 40 : 80); /* 40 columns are not supported as of PDCurses 2.3 */
  resize_term (Lines50 ? 50 : 25, Columns40 ? 40 : 80); /* @@ does not always work the first time -- DJGPP bug? */
  crt_screen_size_changed++;
}

int crt_getshiftstate ()
{
  int state = crt_VirtualShiftState;
  unsigned short bios_state;
  /* read a word from BIOS memory at linear address 0x417 (i.e., 0x40:0x17) */
  asm ("push %%ds\n\tmovw %w1, %%ds\n\tmovw 0x417, %w0\n\tpop %%ds"
       : "=q" (bios_state) : "g" (_dos_ds));
  if (bios_state & 2) state |= shLeftShift;
  if (bios_state & 1) state |= shRightShift;
  if (bios_state & 4) state |= (bios_state & 0x100) ? shLeftCtrl : shRightCtrl;
  if (bios_state & 8) state |= (bios_state & 0x200) ? shLeftAlt  : shRightAlt;
  if (bios_state & 0x1000) state |= shExtra;
  return state;
}

void crt_sound (unsigned Hz)
{
  sound (Hz);
}

void crt_nosound ()
{
  nosound ();
}

static void crt_special_init ()
{
  signal (SIGINT,  &int_handler);
  signal (SIGTERM, &term_handler);
  signal (SIGHUP,  &hup_handler);
}

static void crt_special_done ()
{
}
