/* When locales are in use, glibc2 puts locales into memory that Checker
   doesn't know about.  This would be just fine, except that the macros in
   ctype.h access that memory directly.  So if we let those macros stick
   around, this program has trouble:

       #include <stdio.h>
       #include <ctype.h>
       #include <locale.h>

       int main()
       {
	 setlocale (LC_ALL, "en_US");
	 printf("%d\n", isprint(228));
       }

  It gets an error like this:

       From Checker (pid:12420): (nma) no memory addressed.
       When Reading 2 byte(s) at address 0x4014742c, inside the nothingness segment.
       THIS SHOULD CAUSE A SEGMENTATION FAULT.
       Known_stack_limit = 0xbffff994
       Stack frames are:
	       pc=0x080488e3 in main at demo.c:8
	       pc=0x0805544b in this_main at stubs-main.c:13
	       pc=0x4003f46b in checker_text_stubs_end at stubs/end-stubs.c:7
	       pc=0x08048738 in *unknown* at *unknown*:0

  The hard solution would be to make Checker aware of internal locale data
  structures.  The easy solution, adopted here, is to force glibc to use
  function definitions instead of macros for ctype.h. */

#ifndef	_CHECKER_CTYPE_H
#define	_CHECKER_CTYPE_H	1

#include_next <ctype.h>

#undef isalnum
#undef isalpha
#undef iscntrl
#undef isdigit
#undef islower
#undef isgraph
#undef isprint
#undef ispunct
#undef isspace
#undef isupper
#undef isxdigit

#ifdef	__USE_ISOC99
#undef isblank
#endif

#undef tolower
#undef toupper

#if defined __USE_SVID || defined __USE_MISC || defined __USE_XOPEN
#undef isascii
#undef toascii
#undef _toupper
#undef _tolower
#endif

#ifdef __USE_GNU
#undef __isalnum_l
#undef __isalpha_l
#undef __iscntrl_l
#undef __isdigit_l
#undef __islower_l
#undef __isgraph_l
#undef __isprint_l
#undef __ispunct_l
#undef __isspace_l
#undef __isupper_l
#undef __isxdigit_l
#undef __isblank_l
#undef __tolower_l
#undef__toupper_l
#endif

#endif /* _CHECKER_CTYPE_H */
