/* Checker stubs for functions defined in libpq
   Copyright (C) 1999 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#include "available-stubs.h"

#include <fenv.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_feclearexcept
/* From `/usr/include/fenv.h:65'.  */
void chkr_stub_feclearexcept (int arg0)
     __asm__ (CHKR_PREFIX ("feclearexcept"));
void
chkr_stub_feclearexcept (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (feclearexcept);
#else
  feclearexcept (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_feclearexcept */

#ifdef HAVE_fegetexceptflag
/* From `/usr/include/fenv.h:69'.  */
void chkr_stub_fegetexceptflag (fexcept_t * arg0, int arg1)
     __asm__ (CHKR_PREFIX ("fegetexceptflag"));
void
chkr_stub_fegetexceptflag (fexcept_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (fexcept_t), CHKR_WO, "flagp");
#if USE_BI_JUMP
  __builtin_jump (fegetexceptflag);
#else
  fegetexceptflag (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fegetexceptflag */

#ifdef HAVE_feraiseexcept
/* From `/usr/include/fenv.h:72'.  */
void chkr_stub_feraiseexcept (int arg0)
     __asm__ (CHKR_PREFIX ("feraiseexcept"));
void
chkr_stub_feraiseexcept (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (feraiseexcept);
#else
  feraiseexcept (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_feraiseexcept */

#ifdef HAVE_fesetexceptflag
/* From `/usr/include/fenv.h:76'.  */
void chkr_stub_fesetexceptflag (const fexcept_t * arg0, int arg1)
     __asm__ (CHKR_PREFIX ("fesetexceptflag"));
void
chkr_stub_fesetexceptflag (const fexcept_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (fexcept_t), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (fesetexceptflag);
#else
  fesetexceptflag (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fesetexceptflag */

#ifdef HAVE_fetestexcept
/* From `/usr/include/fenv.h:80'.  */
int chkr_stub_fetestexcept (int arg0)
     __asm__ (CHKR_PREFIX ("fetestexcept"));
int
chkr_stub_fetestexcept (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (fetestexcept);
#else
  return fetestexcept (arg0);
  {
    int res;
    res = fetestexcept (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fetestexcept */

#ifdef HAVE_fegetround
/* From `/usr/include/fenv.h:86'.  */
int chkr_stub_fegetround (void ) __asm__ (CHKR_PREFIX ("fegetround"));
int
chkr_stub_fegetround (void )
{
#if USE_BI_JUMP
  __builtin_jump (fegetround);
#else
  return fegetround ();
  {
    int res;
    res = fegetround ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fegetround */

#ifdef HAVE_fesetround
/* From `/usr/include/fenv.h:89'.  */
int chkr_stub_fesetround (int arg0) __asm__ (CHKR_PREFIX ("fesetround"));
int
chkr_stub_fesetround (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (fesetround);
#else
  return fesetround (arg0);
  {
    int res;
    res = fesetround (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fesetround */

#ifdef HAVE_fegetenv
/* From `/usr/include/fenv.h:96'.  */
void chkr_stub_fegetenv (fenv_t * arg0) __asm__ (CHKR_PREFIX ("fegetenv"));
void
chkr_stub_fegetenv (fenv_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (fenv_t), CHKR_WO, "envp");
#if USE_BI_JUMP
  __builtin_jump (fegetenv);
#else
  fegetenv (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fegetenv */

#ifdef HAVE_feholdexcept
/* From `/usr/include/fenv.h:101'.  */
int chkr_stub_feholdexcept (fenv_t * arg0)
     __asm__ (CHKR_PREFIX ("feholdexcept"));
int
chkr_stub_feholdexcept (fenv_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (fenv_t), CHKR_WO, "envp");
#if USE_BI_JUMP
  __builtin_jump (feholdexcept);
#else
  return feholdexcept (arg0);
  {
    int res;
    res = feholdexcept (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_feholdexcept */

#ifdef HAVE_fesetenv
/* From `/usr/include/fenv.h:105'.  */
void chkr_stub_fesetenv (const fenv_t * arg0)
     __asm__ (CHKR_PREFIX ("fesetenv"));
void
chkr_stub_fesetenv (const fenv_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (fenv_t), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (fesetenv);
#else
  fesetenv (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fesetenv */

#ifdef HAVE_feupdateenv
/* From `/usr/include/fenv.h:110'.  */
void chkr_stub_feupdateenv (const fenv_t * arg0)
     __asm__ (CHKR_PREFIX ("feupdateenv"));
void
chkr_stub_feupdateenv (const fenv_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (fenv_t), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (feupdateenv);
#else
  feupdateenv (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_feupdateenv */

