#include "available-stubs.h"

#include <glob.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_glob
/* From `/usr/include/glob.h:115'.  */
int chkr_stub_glob (const char *pattern, int flags,
		    int (*errfunc) (const char *, int),
		    glob_t *pglob)
     __asm__ (CHKR_PREFIX ("glob"));
int
chkr_stub_glob (const char *pattern, int flags,
		int (*errfunc) (const char *, int),
		glob_t *pglob)
{
  int res;

  stubs_chkr_check_str (pattern, CHKR_RO, "pattern");
  stubs_chkr_check_exec (errfunc, "errfunc");

  /* Check PGLOB structure.  */
  stubs_chkr_check_addr (&pglob->gl_pathc, sizeof (int), CHKR_MW,
			 "pglob->gl_pathc");
  stubs_chkr_check_addr (&pglob->gl_pathv, sizeof (char **), CHKR_MW,
			 "pglob->gl_pathv");
  stubs_chkr_check_addr (&pglob->gl_offs, sizeof (int), CHKR_RO,
			 "pglob->gl_offs");
#ifdef GLOB_ALTDIRFUNC
  if (flags & GLOB_ALTDIRFUNC)
    {
      stubs_chkr_check_addr (&pglob->gl_readdir, sizeof (void *), CHKR_RO,
			     "pglob->gl_readdir");
      stubs_chkr_check_exec (pglob->gl_readdir, "pglob->gl_readdir");
    }
#endif /* GLOB_ALTDIRFUNC */
  res = glob (pattern, flags, errfunc, pglob);
  if (res == 0)
    {
      char **p;

      stubs_chkr_set_right (&pglob->gl_pathc, sizeof (int), CHKR_RW);
      stubs_chkr_set_right (&pglob->gl_pathv, sizeof (int), CHKR_RW);
      stubs_chkr_set_right (pglob->gl_pathv,
			    (pglob->gl_pathc + 1) * sizeof (char *), CHKR_RW);
      for (p = pglob->gl_pathv; *p; p++)
	stubs_chkr_set_right (*p, strlen (*p) + 1, CHKR_RW);
    }
  return res;
}
#endif /* HAVE_glob */

#ifdef HAVE_globfree
/* From `/usr/include/glob.h:118'.  */
void chkr_stub_globfree (glob_t *pglob) __asm__ (CHKR_PREFIX ("globfree"));
void
chkr_stub_globfree (glob_t *pglob)
{
  stubs_chkr_check_addr (&pglob->gl_pathc, sizeof (int), CHKR_RO,
			 "pglob->gl_pathc");
  stubs_chkr_check_addr (&pglob->gl_pathv, sizeof (char **), CHKR_RO,
			 "pglob->gl_pathv");
  stubs_chkr_check_addr (pglob->gl_pathv,
			 (pglob->gl_pathc + 1) * sizeof (char *), CHKR_RO,
			 "pglob->gl_pathv[]");
#if USE_BI_JUMP
  __builtin_jump (globfree);
#else
  globfree (pglob);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_globfree */

