#include "available-stubs.h"

#include <poll.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_poll
/* From `/usr/include/sys/poll.h:128'.  */
int chkr_stub_poll (struct pollfd *fds, long unsigned int nfd,
		    int timeout) __asm__ (CHKR_PREFIX ("poll"));
int
chkr_stub_poll (struct pollfd *fds, long unsigned int nfd,
		int timeout)
{
  int i;
  int res;

  for (i = 0; i < nfd; i++)
    {
      stubs_chkr_check_addr (&fds[i].fd, sizeof (fds[i].fd), CHKR_RO, "fd");
      stubs_chkr_check_addr (&fds[i].events, sizeof (fds[i].events),
			     CHKR_RO, "events");
      stubs_chkr_check_addr (&fds[i].revents, sizeof (fds[i].revents),
			     CHKR_MW, "revents");
    }

  res = poll (fds, nfd, timeout);

  if (res >= 0)
    for (i = 0; i < nfd; i++)
      stubs_chkr_set_right (&fds[i].revents, sizeof (fds[i].revents), CHKR_RW);

  return res;
}
#endif /* HAVE_poll */

