# MySQL dump 7.1
#
# Host: localhost    Database: gcdb
#--------------------------------------------------------
# Server version	3.22.32-log

#
# Table structure for table 'Accounts'
#
DROP TABLE IF EXISTS Accounts;
CREATE TABLE Accounts (
  AccountID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned,
  Username varchar(50),
  Password varchar(50),
  Description varchar(100),
  DateOpened date,
  DateClosed date,
  Price float(5,2),
  Status varchar(25),
  Charged varchar(15) DEFAULT '' NOT NULL,
  TaxRate float(6,4),
  PRIMARY KEY (AccountID),
  UNIQUE AccountID (AccountID)
);

#
# Dumping data for table 'Accounts'
#

LOCK TABLES Accounts WRITE;
INSERT INTO Accounts VALUES (4,1,'gphat','spiffy','DialUp','2000-11-20','0000-00-00',15.00,'Open','monthly',0.0800),(6,4,'g','phat','DialUp','2000-11-29','0000-00-00',10.00,'Open','monthly',NULL),(7,6,'fred','head','DialUp','1999-01-08','0000-00-00',10.00,'Open','monthly',0.0000),(8,1,'hat','off','DialUp','2001-01-13','0000-00-00',12.00,'Open','quarterly',0.8000);
UNLOCK TABLES;

#
# Table structure for table 'Configuration'
#
DROP TABLE IF EXISTS Configuration;
CREATE TABLE Configuration (
  Version varchar(50),
  BillAhead enum('On','Off'),
  Language varchar(50),
  SameMonth enum('On','Off'),
  SearchBar enum('On','Off'),
  Anniversary enum('On','Off'),
  Name varchar(100),
  TaxRate float(6,4),
  BillFromAddress varchar(100),
  BillReplyAddress varchar(100),
  BillSubject varchar(100),
  BillHeader text,
  BillFooter text
);

#
# Dumping data for table 'Configuration'
#

LOCK TABLES Configuration WRITE;
INSERT INTO Configuration VALUES ('1.1.5','Off','english.php','On','On','Off','gcdb',0.0800,'gphat@cafes.net','billsgphat@cafes.net','gcdb Invoice','The following is an invoice for your account.','Thank you for your business!');
UNLOCK TABLES;

#
# Table structure for table 'Customers'
#
DROP TABLE IF EXISTS Customers;
CREATE TABLE Customers (
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  First varchar(30),
  Mid char(1),
  Last varchar(40),
  Address varchar(255),
  Telephone varchar(16),
  Fax varchar(16),
  Email varchar(100),
  City varchar(50),
  State char(2),
  Zip varchar(10),
  Balance float(6,2),
  CCNumber varchar(20),
  CCName varchar(80),
  Password varchar(50),
  Company varchar(100),
  CCExpire varchar(10),
  PRIMARY KEY (CustomerID),
  UNIQUE id (CustomerID)
);

#
# Dumping data for table 'Customers'
#

LOCK TABLES Customers WRITE;
INSERT INTO Customers VALUES (1,'Cory','G','Watson','123 Coolguy Drive','(931) 555-5535','(931) 555-3344','gphat@cafes.net','Tullahoma','TN','37388',-42.41,'1234-1234-1234-1234','Cory G Watson','bleh','gcdb Inc',NULL),(4,'Bob','G','McDougal','123 MadeUp Lane','(931) 393-1111','N/A','no@spam.org','Tullahoma','TN','37388',0.00,'N/A','N/A',NULL,NULL,NULL),(6,'Albert','R','Testerman','918 Made Up Road','(931) 393-0421','(931) 393-4390','nobody@nowhere.com','Nowhereville','TN','37388',-260.00,'N/A','N/A',NULL,NULL,NULL);
UNLOCK TABLES;

#
# Table structure for table 'Invoices'
#
DROP TABLE IF EXISTS Invoices;
CREATE TABLE Invoices (
  InvoiceID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL,
  Description varchar(100),
  DateBilled date,
  Amount float(5,2),
  PRIMARY KEY (InvoiceID),
  UNIQUE InvoiceID (InvoiceID)
);

#
# Dumping data for table 'Invoices'
#

LOCK TABLES Invoices WRITE;
INSERT INTO Invoices VALUES (3,1,'Setup Fee','2000-08-22',20.01),(4,4,'Setup Fee','2001-01-06',20.00),(5,6,'Setup','2001-01-08',25.00);
UNLOCK TABLES;

#
# Table structure for table 'Payments'
#
DROP TABLE IF EXISTS Payments;
CREATE TABLE Payments (
  PaymentID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL,
  DatePaid date,
  Type varchar(10),
  Number varchar(50),
  Amount float(5,2),
  PRIMARY KEY (PaymentID),
  UNIQUE PaymentID (PaymentID)
);

#
# Dumping data for table 'Payments'
#

LOCK TABLES Payments WRITE;
INSERT INTO Payments VALUES (25,1,'2001-01-11','Cash','1391',10.00),(19,4,'2001-01-06','Cash','0',30.00),(24,6,'2001-01-08','Cash','100',5.00);
UNLOCK TABLES;

#
# Table structure for table 'Tickets'
#
DROP TABLE IF EXISTS Tickets;
CREATE TABLE Tickets (
  TicketID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL,
  Description text,
  Status varchar(10),
  OpenDate date,
  OpenTime time,
  CloseDate date,
  CloseTime time,
  Opener varchar(100),
  PRIMARY KEY (TicketID),
  UNIQUE TicketID (TicketID)
);

#
# Dumping data for table 'Tickets'
#

LOCK TABLES Tickets WRITE;
INSERT INTO Tickets VALUES (3,1,'Dead, for real though!','Open','2001-01-06','07:43:40','0000-00-00','00:00:00','Cory Watson'),(4,0,'TESTING','Open','2001-01-13','10:47:44','0000-00-00','00:00:00','Guest User'),(5,0,'TEST','Open','2001-01-13','10:48:41','0000-00-00','00:00:00','Guest User'),(6,0,'wadsdasd','Open','2001-01-14','10:09:59','0000-00-00','00:00:00',''),(7,1,'dwqrwer','Open','2001-01-14','10:50:02','0000-00-00','00:00:00','Customer');
UNLOCK TABLES;

#
# Table structure for table 'Users'
#
DROP TABLE IF EXISTS Users;
CREATE TABLE Users (
  UserID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  Username varchar(50),
  Password varchar(50),
  RealName varchar(100),
  Language varchar(50),
  Admin enum('Yes','No'),
  PRIMARY KEY (UserID)
);

#
# Dumping data for table 'Users'
#

LOCK TABLES Users WRITE;
INSERT INTO Users VALUES (1,'gphat','hilandresbobo','Cory Watson','english.php','Yes'),(2,'jennifer','benner','Jennifer Benner','english.php','No'),(3,'doug','gruber','Doug Gruber','english.php','No'),(5,'guest','guest','Guest User','english.php','No');
UNLOCK TABLES;

