------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                     G C H . U N I T _ C H E C K E R                      --
--                                                                          --
--                               S p e c                                    --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

--  This package define a top-level driver for an ASIS rule checker which
--  works with a single compilation unit

with Asis;
package Gch.Unit_Checker is

   procedure Unit_Checker

     (Unit_To_Check : Asis.Compilation_Unit;
      Success       : in out Boolean);
   --  Checks a given set of rules for a given unit. Sets Success False if any
   --  violation was found during rule checking and True otherwise (that is,
   --  Success does not depend on the number of rule violations being found,
   --  this dependency is maintained outside this procedure)

end Gch.Unit_Checker;