typedef unsigned char ubyte_t;
typedef ubyte_t *ubyte_pt;
 
typedef struct {
	int	  useCount;		/* Keeps track of the number sharing */
	int	  entrySize;	/* Entry size in bytes, including overhead */
	int	  tableSize;	/* Current number of entries in the table  */
	int	  freeHeadIdx;	/* Index of first free entry in the table  */
	ubyte_pt bodyPtr;	/* Pointer to table body */
	int	  baseLength;	/* Length of handleBase.  */
	char	 handleBase [1];	/* Base handle name.  MUST BE LAST FIELD!  */
} tblHeader_t;
typedef tblHeader_t *tblHeader_pt;

typedef struct { 
    int freeLink;
  } entryHeader_t;
typedef entryHeader_t *entryHeader_pt;
 
void gdHandleFree _ANSI_ARGS_((void *headerPtr, void *entryPtr));

tblHeader_pt gdHandleTblInit _ANSI_ARGS_((CONST char *handleBase, 
	int	entrySize, int initEntries));

int gdHandleTblReset _ANSI_ARGS_((tblHeader_pt tblHdrPtr, int initEntries));

entryHeader_pt gdAllocEntry _ANSI_ARGS_((tblHeader_pt tblHdrPtr, 
	int *entryIdxPtr));

void * gdHandleXlate _ANSI_ARGS_((Tcl_Interp *interp, void *headerPtr, 
	CONST char *handle));

void * gdHandleAlloc _ANSI_ARGS_((void *headerPtr, char *handlePtr));
