*
* $Id: gshlin.F,v 1.1.1.1 1995/10/24 10:21:33 cernlib Exp $
*
* $Log: gshlin.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:33  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.23  by  S.Giani
*-- Author :
      SUBROUTINE GSHLIN
C.
C.    ******************************************************************
C.    *                                                                *
C     *       Initialize atomic shells' potentials                     *
C.    *                                                                *
C.    * Potentials according to Rev.Mod.Phys. vol. 39 nr. 1 125 (1967) *
C.    * Xe upadetd according to Grishin et al. NIM A309, 476 (1991)    *
C.    *                                                                *
C.    *    ==>Called by : GPHINI                                       *
C.    *       Author    J. Chwastowski                                 *
C.    *                                                                *
C.    ******************************************************************
C.
C  Shells
c  See alse Handbook of Phys. & Chemistry
c
      IMPLICIT NONE
#include "geant321/gcpmxz.inc"
#include "geant321/gcshpt.inc"
      INTEGER NS,N1,NP,I
      REAL TMP
      DIMENSION NS(MAXSHL),N1(MAXELZ),NP(MAXELZ)
      DIMENSION TMP(LENGTH)
      DATA NS / 1,3*5,3*17,2*21,35,2*33,
     +          2*41,2*58,3*49,2*73,3*82 /
      DATA N1(  1),NP(  1) /    1,    1 /
      DATA TMP(   1) /  13.59811 /
      DATA N1(  2),NP(  2) /    2,    1 /
      DATA TMP(   2) /  24.58678 /
      DATA N1(  3),NP(  3) /    3,    1 /
      DATA TMP(   3) /  54.75000 /
      DATA N1(  4),NP(  4) /    4,    1 /
      DATA TMP(   4) / 111.00000 /
      DATA N1(  5),NP(  5) /    5,    4 /
      DATA (TMP(I),I=  5,  8) /
     +      188.00,     12.58,      4.70,      4.70 /
      DATA N1(  6),NP(  6) /    9,    4 /
      DATA (TMP(I),I=  9, 12) /
     +      283.80,     17.56,      6.40,      6.40 /
      DATA N1(  7),NP(  7) /   13,    4 /
      DATA (TMP(I),I= 13, 16) /
     +      401.60,     23.10,      9.20,      9.20 /
      DATA N1(  8),NP(  8) /   17,    4 /
      DATA (TMP(I),I= 17, 20) /
     +      532.00,     23.70,      7.10,      7.10 /
      DATA N1(  9),NP(  9) /   21,    4 /
      DATA (TMP(I),I= 21, 24) /
     +      685.40,     31.00,      8.60,      8.60 /
      DATA N1( 10),NP( 10) /   25,    4 /
      DATA (TMP(I),I= 25, 28) /
     +      866.90,     45.00,     18.30,     18.30 /
      DATA N1( 11),NP( 11) /   29,    4 /
      DATA (TMP(I),I= 29, 32) /
     +     1072.10,     63.30,     31.10,     31.10 /
      DATA N1( 12),NP( 12) /   33,    4 /
      DATA (TMP(I),I= 33, 36) /
     +     1305.00,     89.40,     51.40,     51.40 /
      DATA N1( 13),NP( 13) /   37,    4 /
      DATA (TMP(I),I= 37, 40) /
     +     1559.60,    117.70,     73.10,     73.10 /
      DATA N1( 14),NP( 14) /   41,    4 /
      DATA (TMP(I),I= 41, 44) /
     +     1838.90,    148.70,     99.20,     99.20 /
      DATA N1( 15),NP( 15) /   45,    4 /
      DATA (TMP(I),I= 45, 48) /
     +     2145.50,    189.30,    132.20,    132.20 /
      DATA N1( 16),NP( 16) /   49,    4 /
      DATA (TMP(I),I= 49, 52) /
     +     2472.00,    229.20,    164.80,    164.80 /
      DATA N1( 17),NP( 17) /   53,    7 /
      DATA (TMP(I),I=  53,  59) /
     +     2822.40,    270.20,    201.60,    200.00
     + ,     17.50,      6.80,      6.80 /
      DATA N1( 18),NP( 18) /   60,    7 /
      DATA (TMP(I),I=  60,  66) /
     +     3202.90,    320.00,    247.30,    245.20
     + ,     25.30,     12.40,     12.40 /
      DATA N1( 19),NP( 19) /   67,    7 /
      DATA (TMP(I),I=  67,  73) /
     +     3607.40,    377.10,    296.30,    293.60
     + ,     33.90,     17.80,     17.80 /
      DATA N1( 20),NP( 20) /   74,    7 /
      DATA (TMP(I),I=  74,  80) /
     +     4038.10,    437.80,    350.00,    346.40
     + ,     43.70,     25.40,     25.40 /
      DATA N1( 21),NP( 21) /   81,    9 /
      DATA (TMP(I),I=  81,  89) /
     +     4492.80,    500.40,    406.70,    402.20
     + ,     53.80,     32.30,     32.30,      6.60,      6.60 /
      DATA N1( 22),NP( 22) /   90,    9 /
      DATA (TMP(I),I=  90,  98) /
     +     4966.40,    563.70,    461.50,    455.50
     + ,     60.30,     34.60,     34.60,      3.70,      3.70 /
      DATA N1( 23),NP( 23) /   99,    9 /
      DATA (TMP(I),I=  99, 107) /
     +     5465.10,    628.20,    520.50,    512.90
     + ,     66.50,     37.80,     37.80,      2.20,      2.20 /
      DATA N1( 24),NP( 24) /  108,    9 /
      DATA (TMP(I),I= 108, 116) /
     +     5989.20,    694.60,    583.70,    574.50
     + ,     74.10,     42.50,     42.50,      2.30,      2.30 /
      DATA N1( 25),NP( 25) /  117,    9 /
      DATA (TMP(I),I= 117, 125) /
     +     6539.00,    769.00,    651.40,    640.30
     + ,     83.90,     48.60,     48.60,      3.30,      3.30 /
      DATA N1( 26),NP( 26) /  126,    9 /
      DATA (TMP(I),I= 126, 134) /
     +     7112.00,    846.10,    721.10,    708.10
     + ,     92.90,     54.00,     54.00,      3.60,      3.60 /
      DATA N1( 27),NP( 27) /  135,    9 /
      DATA (TMP(I),I= 135, 143) /
     +     7708.90,    925.60,    793.60,    778.60
     + ,    100.70,     59.50,     59.50,      2.90,      2.90 /
      DATA N1( 28),NP( 28) /  144,    9 /
      DATA (TMP(I),I= 144, 152) /
     +     8332.80,   1008.10,    871.90,    854.70
     + ,    111.80,     68.10,     68.10,      3.60,      3.60 /
      DATA N1( 29),NP( 29) /  153,    9 /
      DATA (TMP(I),I= 153, 161) /
     +     8978.90,   1096.60,    951.00,    931.10
     + ,    119.80,     73.60,     73.60,      1.60,      1.60 /
      DATA N1( 30),NP( 30) /  162,    9 /
      DATA (TMP(I),I= 162, 170) /
     +     9658.60,   1193.60,   1042.80,   1019.70
     + ,    135.90,     86.60,     86.60,      8.10,      8.10 /
      DATA N1( 31),NP( 31) /  171,    9 /
      DATA (TMP(I),I= 171, 179) /
     +    10367.10,   1297.70,   1142.30,   1115.40
     + ,    158.10,    106.80,    102.90,     17.40,     17.40 /
      DATA N1( 32),NP( 32) /  180,    9 /
      DATA (TMP(I),I= 180, 188) /
     +    11103.10,   1414.30,   1247.80,   1216.70
     + ,    180.00,    127.90,    120.80,     28.70,     28.70 /
      DATA N1( 33),NP( 33) /  189,   12 /
      DATA (TMP(I),I= 189, 200) /
     +    11866.70,   1526.50,   1358.60,   1323.10
     + ,    203.50,    146.40,    140.50,     41.20
     + ,     41.20,      0.00,      2.50,      2.50 /
      DATA N1( 34),NP( 34) /  201,   12 /
      DATA (TMP(I),I= 201, 212) /
     +    12657.80,   1653.90,   1476.20,   1435.80
     + ,    231.50,    168.20,    161.90,     56.70
     + ,     56.70,      0.00,      5.60,      5.60 /
      DATA N1( 35),NP( 35) /  213,   12 /
      DATA (TMP(I),I= 213, 224) /
     +    13473.70,   1782.00,   1596.00,   1549.90
     + ,    256.50,    189.30,    181.50,     70.10
     + ,     69.00,     27.30,      5.20,      4.60 /
      DATA N1( 36),NP( 36) /  225,   12 /
      DATA (TMP(I),I= 225, 236) /
     +    14325.60,   1921.00,   1727.20,   1674.90
     + ,    292.80,    222.70,    213.80,     95.00
     + ,     93.80,     24.00,     10.60,     10.60 /
      DATA N1( 37),NP( 37) /  237,   12 /
      DATA (TMP(I),I= 237, 248) /
     +    15199.70,   2065.10,   1863.90,   1804.40
     + ,    322.10,    247.40,    238.50,    111.80
     + ,    110.30,     29.30,     14.80,     14.00 /
      DATA N1( 38),NP( 38) /  249,   12 /
      DATA (TMP(I),I= 249, 260) /
     +    16104.60,   2216.30,   2006.80,   1939.60
     + ,    357.50,    279.80,    269.10,    135.00
     + ,    133.10,     37.70,     19.90,     19.90 /
      DATA N1( 39),NP( 39) /  261,   12 /
      DATA (TMP(I),I= 261, 272) /
     +    17038.40,   2372.50,   2155.50,   2080.00
     + ,    393.60,    312.40,    300.30,    159.60
     + ,    157.40,     45.40,     25.60,     25.60 /
      DATA N1( 40),NP( 40) /  273,   12 /
      DATA (TMP(I),I= 273, 284) /
     +    17997.60,   2531.60,   2306.70,   2222.30
     + ,    430.30,    344.20,    350.50,    182.40
     + ,    180.00,     51.30,     28.70,     28.70 /
      DATA N1( 41),NP( 41) /  285,   14 /
      DATA (TMP(I),I= 285, 298) /
     +    18985.60,   2697.70,   2464.70,   2370.50
     + ,    468.40,    378.40,    383.00,    207.40
     + ,    204.60,     58.10,     33.90,     33.90
     + ,      3.20,      3.20 /
      DATA N1( 42),NP( 42) /  299,   14 /
      DATA (TMP(I),I= 299, 312) /
     +    19999.50,   2865.50,   2625.10,   2520.20
     + ,    504.60,    409.70,    392.30,    230.30
     + ,    227.00,     61.80,     34.80,     34.80
     + ,      1.80,      1.80 /
      DATA N1( 43),NP( 43) /  313,   12 /
      DATA (TMP(I),I= 313, 324) /
     +    21044.00,   3042.50,   2793.20,   2676.90
     + ,      0.00,    444.90,    425.00,    256.40
     + ,    252.90,      0.00,     38.90,     38.90 /
      DATA N1( 44),NP( 44) /  325,   14 /
      DATA (TMP(I),I= 325, 338) /
     +    22117.20,   3224.00,   2966.90,   2837.90
     + ,    585.00,    482.80,    460.60,    283.60
     + ,    279.40,     74.90,     43.10,     43.10
     + ,      2.00,      2.00 /
      DATA N1( 45),NP( 45) /  339,   14 /
      DATA (TMP(I),I= 339, 352) /
     +    23219.90,   3411.90,   3146.10,   3003.80
     + ,    627.10,    521.00,    496.20,    311.70
     + ,    307.00,     81.00,     47.90,     47.90
     + ,      2.50,      2.50 /
      DATA N1( 46),NP( 46) /  353,   14 /
      DATA (TMP(I),I= 353, 366) /
     +    24350.30,   3604.30,   3330.30,   3173.30
     + ,    669.90,    559.10,    531.50,    340.00
     + ,    334.70,     86.40,     51.10,     51.10
     + ,      1.50,      1.50 /
      DATA N1( 47),NP( 47) /  367,   14 /
      DATA (TMP(I),I= 367, 380) /
     +    25514.00,   3805.80,   3523.70,   3351.10
     + ,    717.50,    602.40,    571.40,    372.80
     + ,    366.70,     95.20,     62.60,     55.90
     + ,      3.30,      3.30 /
      DATA N1( 48),NP( 48) /  381,   14 /
      DATA (TMP(I),I= 381, 394) /
     +    26711.20,   4018.00,   3727.00,   3537.50
     + ,    770.20,    650.70,    616.50,    410.50
     + ,    403.70,    107.60,     66.90,     66.90
     + ,      9.30,      9.30 /
      DATA N1( 49),NP( 49) /  395,   19 /
      DATA (TMP(I),I= 395, 413) /
     +    27939.90,   4237.50,   3938.00,   3730.10
     + ,    825.60,    702.20,    664.30,    450.80
     + ,    443.10,    121.90,     77.40,     77.40
     + ,     16.20,     16.20,      0.00,      0.00
     + ,      0.10,      0.80,      0.80 /
      DATA N1( 50),NP( 50) /  414,   19 /
      DATA (TMP(I),I= 414, 432) /
     +    29200.10,   4464.70,   4156.10,   3928.80
     + ,    883.80,    756.40,    714.40,    493.30
     + ,    484.80,    136.50,     88.60,     88.60
     + ,     23.90,     23.90,      0.00,      0.00
     + ,      0.90,      1.10,      1.10 /
      DATA N1( 51),NP( 51) /  433,   19 /
      DATA (TMP(I),I= 433, 451) /
     +    30491.20,   4698.30,   4380.40,   4132.20
     + ,    943.70,    811.90,    765.60,    536.90
     + ,    527.50,    152.00,     98.40,     98.40
     + ,     31.40,     31.40,      0.00,      0.00
     + ,      6.70,      2.10,      2.10 /
      DATA N1( 52),NP( 52) /  452,   19 /
      DATA (TMP(I),I= 452, 470) /
     +    31813.80,   4939.20,   4612.00,   4341.40
     + ,   1006.00,    869.70,    818.70,    582.50
     + ,    572.10,    168.30,    110.20,    110.20
     + ,     39.80,     39.80,      0.00,      0.00
     + ,     11.60,      2.30,      2.30 /
      DATA N1( 53),NP( 53) /  471,   19 /
      DATA (TMP(I),I= 471, 489) /
     +    33169.40,   5188.10,   4852.10,   4557.10
     + ,   1072.10,    930.50,    874.60,    631.30
     + ,    619.40,    186.40,    122.70,    122.70
     + ,     49.60,     49.60,      0.00,      0.00
     + ,     13.60,      3.30,      3.30 /
      DATA N1( 54),NP( 54) /  490,   19 /
      DATA (TMP(I),I= 490, 508) /
     +    34561.40,   5452.80,   5103.70,   4782.20
     + ,   1145.70,    999.00,    937.00,    689.00
     + ,    672.30,    213.20,    157.00,    146.70
     + ,     69.50,     67.50,      0.00,      0.00
     + ,     23.39,     13.43,     12.13 /
      DATA N1( 55),NP( 55) /  509,   19 /
      DATA (TMP(I),I= 509, 527) /
     +    35984.60,   5714.30,   5359.40,   5011.90
     + ,   1217.10,   1065.00,    997.60,    739.50
     + ,    725.50,    230.80,    172.30,    161.60
     + ,     78.80,     76.50,      0.00,      0.00
     + ,     22.70,     13.10,     11.40 /
      DATA N1( 56),NP( 56) /  528,   19 /
      DATA (TMP(I),I= 528, 546) /
     +    37440.60,   5988.80,   5623.60,   5247.00
     + ,   1292.80,   1136.70,   1062.20,    796.10
     + ,    780.70,    253.00,    191.80,    179.70
     + ,     92.50,     89.90,      0.00,      0.00
     + ,     39.10,     16.60,     14.60 /
      DATA N1( 57),NP( 57) /  547,   19 /
      DATA (TMP(I),I= 547, 565) /
     +    38924.60,   6266.30,   5890.60,   5482.70
     + ,   1361.30,   1204.40,   1123.40,    848.50
     + ,    831.70,    270.40,    205.80,    191.40
     + ,     98.90,     98.90,      0.00,      0.00
     + ,     32.30,     14.40,     14.40 /
      DATA N1( 58),NP( 58) /  566,   19 /
      DATA (TMP(I),I= 566, 584) /
     +    40443.00,   6548.80,   6164.20,   5723.40
     + ,   1434.60,   1272.80,   1185.40,    901.30
     + ,    883.30,    289.60,    223.30,    207.20
     + ,    110.00,    110.00,      0.10,      0.10
     + ,     37.80,     19.80,     19.80 /
      DATA N1( 59),NP( 59) /  585,   19 /
      DATA (TMP(I),I= 585, 603) /
     +    41990.60,   6834.80,   6440.40,   5964.30
     + ,   1511.00,   1337.40,   1242.20,    951.10
     + ,    931.00,    304.50,    236.30,    217.60
     + ,    113.20,    113.20,      2.00,      2.00
     + ,     37.40,     22.30,     22.30 /
      DATA N1( 60),NP( 60) /  604,   19 /
      DATA (TMP(I),I= 604, 622) /
     +    43568.90,   7126.00,   6721.50,   6207.90
     + ,   1575.30,   1402.80,   1297.40,    999.90
     + ,    977.70,    315.20,    243.30,    224.60
     + ,    117.50,    117.50,      1.50,      1.50
     + ,     37.50,     21.20,     21.80 /
      DATA N1( 61),NP( 61) /  623,   14 /
      DATA (TMP(I),I= 623, 636) /
     +    45184.00,   7427.90,   7012.80,   6459.30
     + ,   1650.00,   1471.40,   1356.90,   1051.50
     + ,   1026.90,      0.00,    242.00,    242.00
     + ,    120.40,    120.40 /
      DATA N1( 62),NP( 62) /  637,   19 /
      DATA (TMP(I),I= 637, 655) /
     +    46834.20,   7736.80,   7311.80,   6716.20
     + ,   1722.80,   1540.70,   1419.80,   1106.00
     + ,   1080.20,    345.70,    265.60,    247.40
     + ,    129.00,    129.00,      5.50,      5.50
     + ,     37.40,     21.30,     21.30 /
      DATA N1( 63),NP( 63) /  656,   19 /
      DATA (TMP(I),I= 656, 674) /
     +    48519.00,   8052.00,   7617.10,   6976.90
     + ,   1800.00,   1613.90,   1480.60,   1160.60
     + ,   1130.90,    360.20,    283.90,    256.60
     + ,    133.20,    133.20,      0.00,      0.00
     + ,     31.80,     22.00,     22.00 /
      DATA N1( 64),NP( 64) /  675,   19 /
      DATA (TMP(I),I= 675, 693) /
     +    50239.10,   8375.60,   7930.30,   7242.80
     + ,   1880.80,   1688.30,   1544.00,   1217.20
     + ,   1185.20,    375.80,    288.50,    270.90
     + ,    140.50,    140.50,      0.10,      0.10
     + ,     36.10,     20.30,     20.30 /
      DATA N1( 65),NP( 65) /  694,   19 /
      DATA (TMP(I),I= 694, 712) /
     +    51995.70,   8708.00,   8251.60,   7514.00
     + ,   1967.50,   1767.70,   1611.30,   1275.00
     + ,   1241.20,    397.90,    310.20,    285.00
     + ,    147.00,    147.00,      2.60,      2.60
     + ,     39.00,     25.40,     25.40 /
      DATA N1( 66),NP( 66) /  713,   19 /
      DATA (TMP(I),I= 713, 731) /
     +    53788.50,   9045.80,   8580.60,   7790.10
     + ,   2046.80,   1841.80,   1675.60,   1332.50
     + ,   1294.90,    416.30,    331.80,    292.90
     + ,    154.20,    154.20,      4.20,      4.20
     + ,     62.90,     26.30,     26.30 /
      DATA N1( 67),NP( 67) /  732,   19 /
      DATA (TMP(I),I= 732, 750) /
     +    55617.70,   9394.20,   8917.80,   8071.10
     + ,   2128.30,   1922.80,   1741.20,   1391.50
     + ,   1351.40,    435.70,    343.50,    306.60
     + ,    161.00,    161.00,      3.70,      3.70
     + ,     51.20,     20.30,     20.30 /
      DATA N1( 68),NP( 68) /  751,   19 /
      DATA (TMP(I),I= 751, 769) /
     +    57485.50,   9751.30,   9264.30,   8357.90
     + ,   2206.50,   2005.80,   1811.80,   1453.30
     + ,   1409.30,    449.10,    366.20,    320.00
     + ,    176.70,    167.60,      4.30,      4.30
     + ,     59.80,     29.40,     29.40 /
      DATA N1( 69),NP( 69) /  770,   19 /
      DATA (TMP(I),I= 770, 788) /
     +    59389.60,  10115.70,   9616.90,   8648.00
     + ,   2306.80,   2089.80,   1884.50,   1514.60
     + ,   1467.70,    471.70,    385.90,    336.60
     + ,    179.60,    179.60,      5.30,      5.30
     + ,     53.20,     32.30,     32.30 /
      DATA N1( 70),NP( 70) /  789,   19 /
      DATA (TMP(I),I= 789, 807) /
     +    61332.30,  10486.40,   9978.20,   8943.60
     + ,   2398.10,   2173.00,   1949.80,   1576.30
     + ,   1527.80,    487.20,    396.70,    343.50
     + ,    198.10,    184.90,      6.30,      6.30
     + ,     54.10,     23.40,     23.40 /
      DATA N1( 71),NP( 71) /  808,   19 /
      DATA (TMP(I),I= 808, 826) /
     +    63313.80,  10870.40,  10348.60,   9244.10
     + ,   2491.20,   2263.50,   2023.60,   1639.40
     + ,   1588.50,    506.20,    410.10,    359.30
     + ,    204.80,    195.00,      6.90,      6.90
     + ,     56.80,     28.00,     28.00 /
      DATA N1( 72),NP( 72) /  827,   19 /
      DATA (TMP(I),I= 827, 845) /
     +    65350.80,  11270.70,  10739.40,   9560.70
     + ,   2600.90,   2365.40,   2107.60,   1716.40
     + ,   1661.70,    538.10,    437.00,    380.40
     + ,    223.80,    213.70,     17.10,     17.10
     + ,     64.90,     38.10,     30.60 /
      DATA N1( 73),NP( 73) /  846,   21 /
      DATA (TMP(I),I= 846, 866) /
     +    67416.40,  11681.50,  11136.10,   9881.10
     + ,   2708.00,   2468.70,   2194.00,   1793.20
     + ,   1735.10,    565.50,    464.80,    404.50
     + ,    241.30,    229.30,     25.00,     25.00
     + ,     71.10,     44.90,     36.40,      5.70,      5.70 /
      DATA N1( 74),NP( 74) /  867,   21 /
      DATA (TMP(I),I= 867, 887) /
     +    69525.00,  12099.80,  11544.00,  10206.80
     + ,   2819.60,   2574.90,   2281.00,   1871.60
     + ,   1809.20,    595.00,    491.60,    425.30
     + ,    258.80,    245.40,     36.50,     33.60
     + ,     77.10,     46.80,     35.60,      6.10,      6.10 /
      DATA N1( 75),NP( 75) /  888,   21 /
      DATA (TMP(I),I= 888, 908) /
     +    71676.40,  12526.70,  11958.70,  10535.30
     + ,   2931.70,   2681.60,   2367.30,   1948.90
     + ,   1882.90,    625.00,    517.90,    444.40
     + ,    273.70,    260.20,     40.60,     40.60
     + ,     82.80,     45.60,     34.60,      3.50,      3.50 /
      DATA N1( 76),NP( 76) /  909,   19 /
      DATA (TMP(I),I= 909, 927) /
     +    73870.80,  12968.00,  12385.00,  10870.90
     + ,   3048.50,   2792.20,   2457.20,   2030.80
     + ,   1960.10,    654.30,    546.50,    468.20
     + ,    289.40,    272.80,     46.30,     43.40
     + ,     83.70,     58.00,     45.40 /
      DATA N1( 77),NP( 77) /  928,   21 /
      DATA (TMP(I),I= 928, 948) /
     +    76111.00,  13418.50,  12824.10,  11215.20
     + ,   3173.70,   2908.70,   2550.70,   2116.10
     + ,   2040.40,    690.10,    577.10,    494.30
     + ,    311.40,    294.90,     63.40,     60.50
     + ,     95.20,     63.00,     50.50,      1.80,      1.80 /
      DATA N1( 78),NP( 78) /  949,   21 /
      DATA (TMP(I),I= 949, 969) /
     +    78394.80,  13879.90,  13272.60,  11563.70
     + ,   3296.00,   3026.50,   2645.40,   2201.90
     + ,   2121.60,    722.00,    609.20,    519.00
     + ,    330.80,    313.30,     74.30,     71.10
     + ,    101.70,     65.30,     51.70,      2.20,      2.20 /
      DATA N1( 79),NP( 79) /  970,   20 /
      DATA (TMP(I),I= 970, 989) /
     +    80724.90,  14352.80,  13733.60,  11918.70
     + ,   3424.90,   3147.80,   2743.00,   2291.10
     + ,   2205.70,    758.80,    643.70,    545.40
     + ,    352.00,    333.90,     86.40,     82.80
     + ,    107.80,     71.70,     53.70,      2.50 /
      DATA N1( 80),NP( 80) /  990,   21 /
      DATA (TMP(I),I= 990,1010) /
     +    83102.30,  14839.30,  14208.70,  12283.90
     + ,   3561.60,   3278.50,   2847.10,   2384.90
     + ,   2294.90,    800.30,    676.90,    571.00
     + ,    378.30,    359.80,    102.20,     98.50
     + ,    120.30,     80.50,     57.60,      6.40,      6.40 /
      DATA N1( 81),NP( 81) / 1011,   21 /
      DATA (TMP(I),I=1011,1031) /
     +    85530.40,  15346.70,  14697.90,  12657.50
     + ,   3704.10,   3425.70,   2956.60,   2485.10
     + ,   2389.30,    845.50,    721.30,    609.00
     + ,    406.60,    386.20,    122.80,    118.50
     + ,    136.30,     99.60,     75.40,     15.30,     13.10 /
      DATA N1( 82),NP( 82) / 1032,   24 /
      DATA (TMP(I),I=1032,1055) /
     +    88004.50,  15860.80,  15200.00,  13035.20
     + ,   3850.70,   3554.20,   3066.40,   2585.60
     + ,   2484.00,    893.60,    763.90,    644.50
     + ,    435.20,    412.90,    142.90,    138.10
     + ,    147.30,    104.80,     86.00,     21.80
     + ,     19.20,      3.10,      0.70,      0.70 /
      DATA N1( 83),NP( 83) / 1056,   24 /
      DATA (TMP(I),I=1056,1079) /
     +    90525.90,  16387.50,  15711.10,  13418.60
     + ,   3999.10,   3696.30,   3176.90,   2687.60
     + ,   2579.60,    938.20,    805.30,    678.90
     + ,    463.60,    440.00,    161.90,    157.40
     + ,    159.30,    116.80,     92.80,     26.50
     + ,     24.40,      0.00,      2.70,      2.70 /
      DATA N1( 84),NP( 84) / 1080,   21 /
      DATA (TMP(I),I=1080,1100) /
     +    93105.00,  16939.30,  16244.30,  13813.80
     + ,   4149.40,   3854.10,   3301.90,   2798.00
     + ,   2683.00,    995.30,    851.00,    705.00
     + ,    500.20,    473.40,      0.00,      0.00
     + ,      0.00,      0.00,      0.00,     31.40,     31.40 /
      DATA N1( 85),NP( 85) / 1101,   14 /
      DATA (TMP(I),I=1101,1114) /
     +    95729.90,  17493.00,  16784.70,  14213.50
     + ,   4317.00,   4008.00,   3426.00,   2908.70
     + ,   2786.70,   1042.00,    886.00,    740.00
     + ,    533.20,    506.00 /
      DATA N1( 86),NP( 86) / 1115,   14 /
      DATA (TMP(I),I=1115,1128) /
     +    98404.00,  18049.00,  17337.10,  14619.40
     + ,   4482.00,   4159.00,   3538.00,   3021.50
     + ,   2892.40,   1097.00,    929.00,    768.00
     + ,    566.60,    541.00 /
      DATA N1( 87),NP( 87) / 1129,   14 /
      DATA (TMP(I),I=1129,1142) /
     +   101137.00,  18639.00,  17906.50,  15031.20
     + ,   4652.00,   4327.00,   3663.00,   3136.20
     + ,   2999.90,   1153.00,    980.00,    810.00
     + ,    603.30,    577.00 /
      DATA N1( 88),NP( 88) / 1143,   24 /
      DATA (TMP(I),I=1143,1166) /
     +   103921.90,  19236.70,  18484.30,  15444.40
     + ,   4822.00,   4489.50,   3791.80,   3248.40
     + ,   3104.90,   1208.40,   1057.60,    879.10
     + ,    635.90,    602.70,    298.90,    298.90
     + ,    254.40,    200.40,    152.80,     67.20
     + ,     67.20,     43.50,     18.80,     18.80 /
      DATA N1( 89),NP( 89) / 1167,   14 /
      DATA (TMP(I),I=1167,1180) /
     +   106755.30,  19840.00,  19083.20,  15871.00
     + ,   5002.00,   4656.00,   3909.00,   3370.20
     + ,   3219.00,   1269.00,   1080.00,    890.00
     + ,    674.90,    644.00 /
      DATA N1( 90),NP( 90) / 1181,   24 /
      DATA (TMP(I),I=1181,1204) /
     +   109650.90,  20472.10,  19693.20,  16300.30
     + ,   5182.30,   4830.40,   4046.10,   3490.80
     + ,   3332.00,   1329.50,   1168.20,    967.30
     + ,    714.10,    676.40,    344.40,    335.20
     + ,    290.20,    229.40,    181.80,     94.30
     + ,     87.90,     59.50,     49.00,     43.00 /
      DATA N1( 91),NP( 91) / 1205,   21 /
      DATA (TMP(I),I=1205,1225) /
     +   112601.40,  21104.60,  20313.70,  16733.10
     + ,   5366.90,   5000.90,   4173.80,   3611.20
     + ,   3441.80,   1387.10,   1224.30,   1006.70
     + ,    743.40,    708.20,    371.20,    359.50
     + ,    309.60,    222.90,    222.90,     94.10,     94.10 /
      DATA N1( 92),NP( 92) / 1226,   24 /
      DATA (TMP(I),I=1226,1249) /
     +   115606.10,  21757.40,  20947.60,  17166.30
     + ,   5548.00,   5182.20,   4303.40,   3727.60
     + ,   3551.70,   1440.80,   1272.60,   1044.90
     + ,    780.40,    737.70,    391.30,    380.90
     + ,    323.70,    259.30,    195.10,    105.00
     + ,     96.30,     70.70,     42.30,     32.30 /
      DATA N1( 93),NP( 93) / 1250,   21 /
      DATA (TMP(I),I=1250,1270) /
     +   118678.00,  22426.80,  21600.50,  17610.00
     + ,   5723.20,   5366.20,   4434.70,   3850.30
     + ,   3665.80,   1500.70,   1327.70,   1086.80
     + ,    815.90,    770.30,    415.00,    404.40
     + ,      0.00,    283.40,    206.10,    109.30,    101.30 /
      DATA N1( 94),NP( 94) / 1271,   21 /
      DATA (TMP(I),I=1271,1291) /
     +   121818.00,  23097.20,  22266.20,  18056.80
     + ,   5932.90,   5541.20,   4556.60,   3972.60
     + ,   3778.10,   1558.60,   1372.10,   1114.80
     + ,    848.90,    801.40,    445.80,    432.40
     + ,    351.90,    274.10,    206.50,    116.00,    105.40 /
      DATA N1( 95),NP( 95) / 1292,   21 /
      DATA (TMP(I),I=1292,1312) /
     +   125027.00,  23772.90,  22944.00,  18504.10
     + ,   6120.50,   5710.20,   4667.00,   4092.10
     + ,   3886.90,   1617.10,   1411.80,   1135.70
     + ,    878.70,    827.60,      0.00,      0.00
     + ,      0.00,      0.00,      0.00,    115.80,    103.30 /
      DATA N1( 96),NP( 96) / 1313,   21 /
      DATA (TMP(I),I=1313,1333) /
     +   128220.00,  24460.00,  23779.00,  18930.00
     + ,   6288.00,   5895.00,   4797.00,   4227.00
     + ,   3971.00,   1643.00,   1440.00,   1154.00
     + ,      0.00,    853.00,      0.00,      0.00
     + ,    385.00,      0.00,      0.00,      0.00,    100.00 /
      DATA N1( 97),NP( 97) / 1334,   21 /
      DATA (TMP(I),I=1334,1354) /
     +   131590.00,  25275.00,  24385.00,  19452.00
     + ,   6556.00,   6147.00,   4977.00,   4366.00
     + ,   4132.00,   1755.00,   1554.00,   1235.00
     + ,      0.00,    877.00,      0.00,      0.00
     + ,    398.00,      0.00,      0.00,      0.00,    100.00 /
      DATA N1( 98),NP( 98) / 1355,   21 /
      DATA (TMP(I),I=1355,1375) /
     +   135960.00,  26110.00,  25250.00,  19930.00
     + ,   6754.00,   6359.00,   5109.00,   4497.00
     + ,   4253.00,   1799.00,   1616.00,   1279.00
     + ,      0.00,    902.00,      0.00,      0.00
     + ,    419.00,      0.00,      0.00,      0.00,    100.00 /
      DATA N1( 99),NP( 99) / 1376,   17 /
      DATA (TMP(I),I=1376,1392) /
     +   139490.00,  26900.00,  26020.00,  20410.00
     + ,   6977.00,   6574.00,   5252.00,   4630.00
     + ,   4374.00,   1868.00,   1680.00,   1321.00
     + ,      0.00,    927.00,      0.00,      0.00,    435.00 /
      DATA N1(100),NP(100) / 1393,   17 /
      DATA (TMP(I),I=1393,1409) /
     +   143090.00,  27700.00,  26810.00,  20900.00
     + ,   7205.00,   6793.00,   5397.00,   4766.00
     + ,   4498.00,   1937.00,   1747.00,   1366.00
     + ,      0.00,    952.00,      0.00,      0.00,    454.00 /
      DO 10 I = 1,LENGTH
         ESHELL(I) = TMP(I)
   10 CONTINUE
      DO 20 I = 1,MAXSHL
         NSHLST(I) = NS(I)
   20 CONTINUE
      DO 30 I = 1,MAXELZ
         N1ST(I) = N1(I)
         NSHLLS(I) = NP(I)
   30 CONTINUE
      END
