/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


/* DO NOT read or edit this file ! Use ../noweb/o_pin.nw instead */

#include <config.h>
#include <stdio.h>
#include <math.h>

#include <libgeda/libgeda.h>

#include "../include/prototype.h"

void o_pin_draw(TOPLEVEL * w_current, OBJECT * o_current)
{
  int size;
  int x1, y1, x2, y2;		/* screen coords */

  if (o_current->line == NULL) {
    return;
  }

  o_pin_recalc(w_current, o_current);

  /* reuse line's routine */
  if (!o_line_visible(w_current, o_current->line, &x1, &y1, &x2, &y2)) {
    return;
  }
#if DEBUG
  printf("drawing pin\n\n");
#endif

  if (w_current->pin_style == THICK) {
    size = SCREENabs(w_current, 10);
    gdk_gc_set_line_attributes(w_current->gc, size, GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  if (w_current->override_color != -1) {
    gdk_gc_set_foreground(w_current->gc,
			  x_get_color(w_current->override_color));
    gdk_draw_line(w_current->window, w_current->gc, x1, y1, x2, y2);
    gdk_draw_line(w_current->backingstore, w_current->gc, x1, y1, x2, y2);
  } else {
    gdk_gc_set_foreground(w_current->gc, x_get_color(o_current->color));
    gdk_draw_line(w_current->window, w_current->gc, x1, y1, x2, y2);
    gdk_draw_line(w_current->backingstore, w_current->gc, x1, y1, x2, y2);
  }
  /* yes zero is right for the width -> use hardware lines */
  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->gc, 0, GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }
#if DEBUG
  printf("drawing pin\n");
#endif

  if (o_current->draw_grips && w_current->draw_grips == TRUE) {

    if (!o_current->selected) {
      /* erase the grips */
      o_current->draw_grips = FALSE;
      gdk_gc_set_foreground(w_current->gc,
			    x_get_color(w_current->background_color));
    } else {
      gdk_gc_set_foreground(w_current->gc, x_get_color(o_current->color));
    }

    /* yes redraw the line functions */
    o_line_draw_grips(w_current, w_current->window, o_current);
    o_line_draw_grips(w_current, w_current->backingstore, o_current);
  }
}


void o_pin_erase(TOPLEVEL * w_current, OBJECT * o_current)
{
  w_current->override_color = w_current->background_color;
  o_pin_draw(w_current, o_current);
  w_current->override_color = -1;
}


void
o_pin_draw_xor(TOPLEVEL * w_current, int dx, int dy, OBJECT * o_current)
{
  int size;
  int color;

  if (o_current->line == NULL) {
    return;
  }

  if (o_current->saved_color != -1) {
    color = o_current->saved_color;
  } else {
    color = o_current->color;
  }

  gdk_gc_set_foreground(w_current->xor_gc, x_get_darkcolor(color));

  if (w_current->pin_style == THICK) {
    size = SCREENabs(w_current, 10);
    gdk_gc_set_line_attributes(w_current->xor_gc, size,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  gdk_draw_line(w_current->window, w_current->xor_gc,
		o_current->line->screen_x[0] + dx,
		o_current->line->screen_y[0] + dy,
		o_current->line->screen_x[1] + dx,
		o_current->line->screen_y[1] + dy);

  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->xor_gc, 0,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }
}


void o_pin_start(TOPLEVEL * w_current, int x, int y)
{
  int size;
  w_current->last_x = w_current->start_x = fix_x(w_current, x);
  w_current->last_y = w_current->start_y = fix_y(w_current, y);

  if (w_current->pin_style == THICK) {
    size = SCREENabs(w_current, 10);
    gdk_gc_set_line_attributes(w_current->xor_gc, size,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  gdk_gc_set_foreground(w_current->xor_gc,
			x_get_color(w_current->select_color));
  gdk_draw_line(w_current->window, w_current->xor_gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);

  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->xor_gc, 0,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }
}


void o_pin_end(TOPLEVEL * w_current, int x, int y)
{
  int x1, y1;
  int x2, y2;
  int color;
  int size;
  GList *other_objects = NULL;

  if (w_current->inside_action == 0) {
    o_redraw(w_current, w_current->page_current->object_head);
    return;
  }

  if (w_current->override_pin_color == -1) {
    color = w_current->pin_color;
  } else {
    color = w_current->override_pin_color;
  }

  /* removed 3/15 to see if we can get pins to be ortho only */
  /* w_current->last_x = fix_x(w_current, x);
     w_current->last_y = fix_y(w_current, y); */

  size = SCREENabs(w_current, 10);
  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->xor_gc, size,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  gdk_gc_set_foreground(w_current->xor_gc,
			x_get_color(w_current->select_color));
  gdk_draw_line(w_current->window, w_current->xor_gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);

  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->xor_gc, 0,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);

    gdk_gc_set_line_attributes(w_current->gc, size,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  /* don't allow zero length pins */
  if ((w_current->start_x == w_current->last_x) &&
      (w_current->start_y == w_current->last_y)) {
    w_current->start_x = (-1);
    w_current->start_y = (-1);
    w_current->last_x = (-1);
    w_current->last_y = (-1);
    return;
  }

  gdk_gc_set_foreground(w_current->gc, x_get_color(color));
  gdk_draw_line(w_current->window, w_current->gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);
  gdk_draw_line(w_current->backingstore, w_current->gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);

  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->gc, 0,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  SCREENtoWORLD(w_current, w_current->start_x, w_current->start_y, &x1,
		&y1);
  SCREENtoWORLD(w_current, w_current->last_x, w_current->last_y, &x2, &y2);
  x1 = snap_grid(w_current, x1);
  y1 = snap_grid(w_current, y1);
  x2 = snap_grid(w_current, x2);
  y2 = snap_grid(w_current, y2);

  w_current->page_current->object_tail =
      o_pin_add(w_current,
		w_current->page_current->object_tail,
		OBJ_PIN, color, x1, y1, x2, y2);

  other_objects = s_conn_return_others(other_objects,
				       w_current->
				       page_current->object_tail);
  o_cue_undraw_list(w_current, other_objects);
  o_cue_draw_list(w_current, other_objects);
  g_list_free(other_objects);
  o_cue_draw_single(w_current, w_current->page_current->object_tail);

  w_current->start_x = (-1);
  w_current->start_y = (-1);
  w_current->last_x = (-1);
  w_current->last_y = (-1);
  w_current->page_current->CHANGED = 1;
  o_undo_savestate(w_current, UNDO_ALL);
}


void o_pin_rubberpin(TOPLEVEL * w_current, int x, int y)
{
  int size;
  int diff_x, diff_y;

  if (w_current->inside_action == 0) {
    o_redraw(w_current, w_current->page_current->object_head);
    return;
  }

  size = SCREENabs(w_current, 10);

  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->xor_gc, size,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  gdk_gc_set_foreground(w_current->xor_gc,
			x_get_color(w_current->select_color));
  gdk_draw_line(w_current->window, w_current->xor_gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);

  w_current->last_x = fix_x(w_current, x);
  w_current->last_y = fix_y(w_current, y);

  diff_x = abs(w_current->last_x - w_current->start_x);
  diff_y = abs(w_current->last_y - w_current->start_y);

  if (diff_x >= diff_y) {
    w_current->last_y = w_current->start_y;
  } else {
    w_current->last_x = w_current->start_x;
  }

  gdk_gc_set_foreground(w_current->xor_gc,
			x_get_color(w_current->select_color));
  gdk_draw_line(w_current->window, w_current->xor_gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);

  if (w_current->pin_style == THICK) {
    gdk_gc_set_line_attributes(w_current->xor_gc, 0,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }
}


/* used in o_stretch.c */
void o_pin_eraserubber(TOPLEVEL * w_current)
{
  int size;

  if (w_current->net_style == THICK) {
    size = SCREENabs(w_current, 10);

    if (size < 0)
      size = 0;

    gdk_gc_set_line_attributes(w_current->gc, size,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }

  gdk_gc_set_foreground(w_current->gc,
			x_get_color(w_current->background_color));
  gdk_draw_line(w_current->window, w_current->gc, w_current->start_x,
		w_current->start_y, w_current->last_x, w_current->last_y);

  if (w_current->net_style == THICK) {
    gdk_gc_set_line_attributes(w_current->gc, 0,
			       GDK_LINE_SOLID,
			       GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  }
}
