#  model.rb -
#  model is a Model module
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


require 'yaml'
require 'singleton'
require 'geekast/models/lib/connection'
require 'geekast/models/lib/preferences'
require 'geekast/models/lib/bookmark'

# module config
require 'geekast/config/config'


module Geekast
  module Model

    def self.main
      Model.instance
    end

    class Model
      include Singleton

      def initialize
        puts "Model singleton launched" if $DEBUG

        @connection = PeercastConnection.new
        @bookmark = Bookmark.new


        SIGNAL.connect("MrefreshNB") {|hash|
          puts hash["SIGNAL"] if $DEBUG
          if hash["NUMPAGE"] == Config::BOOKMARK
            refreshMB(hash["SIGNAL"])
          elsif hash["SIGNAL"] != ""
            refreshNB(hash)
          end
        }

        SIGNAL.connect("MbookmarkAdd") {|data|
          puts "MbookmarkAdd" if $DEBUG
          @bookmark.add(data)
        }

        SIGNAL.connect("MbookmarkDel") {|data|
          puts "MbookmarkDel" if $DEBUG
          @bookmark.del
        }

      end


      #######
      private
      #######

      def refreshNB(hash)
        msg = @connection.connect(hash)
        @connection.parse_xml(hash) if msg == "true"
        SIGNAL.emit("ChandlerError", "httpConnect", msg)
      end

      def refreshMB(signal)
        @bookmark.load(signal)
      end


    end

  end
end
