% FUNCTION [...] = gf_slice_get(slice SL, [operation [, args]])
% 
%   * d = gf_slice_get(SL,'dim')
%   Return the dimension of the slice (2 for a 2D mesh, etc..).
% 
%   * a = gf_slice_get(SL,'area')
%   Return the area of the slice.
% 
%   * CVids = gf_slice_get(SL,'cvs')
%   Return the list of convexes of the original mesh contained in the slice.
% 
%   * n = gf_slice_get(SL,'nbpts')
%   Return the number of points in the slice.
% 
%   * P = gf_slice_get(SL,'pts')
%   Return the list of point coordinates.
% 
%   * ns = gf_slice_get(SL,'nbsplxs'[, int dim])
%   Return the number of simplexes in the slice.  Since the slice may contain
%   points (simplexes of dim 0), segments (simplexes of dimension 1), triangles
%   etc., the result is a vector of size gf_slice_get(SL,'dim')+1 , except if the
%   optional argument `dim` is used.
% 
%   * {S, CV2S} = gf_slice_get(SL,'splxs',int dim)
%   Return the list of simplexes of dimension `dim`.  On output, S has 'dim+1'
%   rows, each column contains the point numbers of a simplex.  The vector `CV2S`
%   can be used to find the list of simplexes for any convex stored in the slice.
%   For example 'S(:,CV2S(4):CV2S(5)-1)' gives the list of simplexes for the
%   fourth convex.
% 
%   * {P, E1, E2} = gf_slice_get(SL,'edges')
%   Return the edges of the linked mesh contained in the slice.  `P` contains the
%   list of all edge vertices, `E1` contains the indices of each mesh edge in `P`,
%   and `E2` contains the indices of each "edges" which is on the border of the
%   slice. This function is useless except for post-processing purposes.
% 
%   * Usl = gf_slice_get(SL,'interpolate_convex_data',mat Ucv)
%   Interpolate data given on each convex of the mesh to the slice nodes.  The
%   input array `Ucv` may have any number of dimensions, but its last dimension
%   should be equal to gf_mesh_get(M,'max_cvid').
%   
%     Example of use: gf_slice_get(SL,'interpolate_convex_data',
%   gf_mesh_get(M,'quality')).
% 
%   * m = gf_slice_get(SL,'linked_mesh')
%   Return the mesh on which the slice was taken.
% 
%   * gf_slice_get(SL,'export_to_vtk',string filename ... [, 'ascii'][, 'edges']
%   ...)
%   Export a slice to VTK.  Following the `filename`, you may use any of the
%   following options:
%   
%     - if 'ascii' is not used, the file will contain binary data
%      (non portable, but fast).
%    - if 'edges' is used, the edges of the original mesh will be
%      written instead of the slice content.
%   
%     More than one dataset may be written, just list them. Each dataset consists
%   of either:
%   
%     - a field interpolated on the slice (scalar, vector or tensor),
%      followed by an optional name.
%    - a mesh_fem and a field, followed by an optional name.
%   
%     Examples:
%   
%     - gf_slice_get(SL,'export_to_vtk','test.vtk',Usl,'first_dataset', mf,
%      U2, 'second_dataset')
%    - gf_slice_get(SL,'export_to_vtk','test.vtk','ascii',mf,U2)
%    - gf_slice_get(SL,'export_to_vtk','test.vtk','edges','ascii',Uslice)
% 
%   * gf_slice_get(SL,'export_to_pov',string filename, ...)
%   Export a the triangles of the slice to POV-RAY.
% 
%   * gf_slice_get(SL,'export_to_dx',string filename, ...)
%   Export a slice to OpenDX.  Following the file name, you may use any of the
%   following options:
%   
%     - if 'ascii' is not used, the file will contain binary data
%      (non portable, but fast).
%    - if 'edges' is used, the edges of the original mesh will be
%      written instead of the slice content.
%    - if 'append' is used, the opendx file will not be overwritten,
%      and the new data will be added at the end of the file.
%   
%     More than one dataset may be written, just list them. Each dataset consists
%   of either:
%   
%     - a field interpolated on the slice (scalar, vector or tensor),
%      followed by an optional name.
%    - a mesh_fem and a field, followed by an optional name.
% 
%   * z = gf_slice_get(SL,'memsize')
%   Return the amount of memory (in bytes) used by the slice object.
% 
% 
%   $Id: gf_slice_get.cc 2869 2009-01-08 01:12:35Z lsaavedr $
function [varargout]=gf_slice_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('slice_get',varargin{:});
  else
    gf_matlab('slice_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
