#include <stdio.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>

#include "gfcc.h"

extern GtkWidget *notebook;
extern struct _fwchain fwchain[];
extern gint maxchains;
extern gint modified;

static struct _fwentry chentry;

static void edit_chain_enter(GtkWidget *, RuleAction);
static void cwin_destroy(GtkWidget *, gpointer);

GtkWidget *chain_win = NULL;
ip_chainlabel newparent;
gint oldpage, oldrow;

static void cwin_destroy(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(chain_win);
	chain_win = NULL;
}

void edit_chain_window(GtkWidget *w, RuleAction flag)
{
	GtkWidget *vbox, *hbox;
	GtkWidget *table, *child;
	GtkWidget *label;
	GtkWidget *button;
	gint i=0;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	
	if(page < 0)
		return;
	if(chain_win)
		gtk_widget_destroy(chain_win);

	chain_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(chain_win, 235, 80);
	gtk_window_set_position(GTK_WINDOW(chain_win), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT(chain_win), "destroy",
			GTK_SIGNAL_FUNC(cwin_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(chain_win), "delete_event",
			GTK_SIGNAL_FUNC(cwin_destroy), NULL);
	if(flag == EDIT)
		gtk_window_set_title(GTK_WINDOW(chain_win), "Edit Chain");
	else
		gtk_window_set_title(GTK_WINDOW(chain_win), "New Chain");
	gtk_container_set_border_width(GTK_CONTAINER(chain_win), 3);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(chain_win), vbox);
	
	table = gtk_table_new(3, 2, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_container_add(GTK_CONTAINER(vbox), table);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 8);
	gtk_widget_show(table);
	
	child = gtk_alignment_new(1,1,0,1);
	gtk_widget_show(child);
	gtk_table_attach_defaults(GTK_TABLE(table), child, 0,1,i,i+1);
	label = gtk_label_new("Name:");
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(child), label);
	chentry.label = gtk_entry_new_with_max_length(sizeof(ip_chainlabel)-1);
	gtk_table_attach_defaults(GTK_TABLE(table), chentry.label, 1,2,i,i+1);
	if(flag == EDIT) {
		gtk_entry_set_text(
			GTK_ENTRY(chentry.label), fwchain[page].label);
	}
	gtk_widget_show(chentry.label);
	i++;
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 7);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(edit_chain_enter), (RuleAction *)flag);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Cancel");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(cwin_destroy), NULL);
	gtk_widget_show(button);

	gtk_widget_show(chain_win);
}

void delete_chain(GtkWidget *w, gchar *data)
{
	gchar *text;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gint i, j;
	
	if(page < 0)
		return;
	for(i=0; i<maxchains; i++) {
		for(j=0; j < GTK_CLIST(fwchain[i].rulelist)->rows; j++) {
			gtk_clist_get_text(
				GTK_CLIST(fwchain[i].rulelist), j, 6, &text);
			if(strcmp(text, fwchain[page].label))
				continue;
			if(GTK_TOGGLE_BUTTON(w)->active) {
				gtk_clist_set_text(
					GTK_CLIST(fwchain[i].rulelist),
					j,18,"1");
			} else {
				gtk_clist_set_text(
					GTK_CLIST(fwchain[i].rulelist),
					j,18,"0");
			}
		}
	}
	if(GTK_TOGGLE_BUTTON(w)->active) {
		fwchain[page].deleted = 1;
	} else {
		fwchain[page].deleted = 0;
	}
	modified = 1;
}

void edit_chain_enter(GtkWidget *w, RuleAction flag)
{
	gchar *chain, *text;
	gint i, j;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	
	if(page < 0)
		return;
	chain = gtk_entry_get_text(GTK_ENTRY(chentry.label));
	if(!*chain)
		return;
	
	for(i=0; i<maxchains; i++) {
		if(!strcmp(fwchain[i].label, chain)) {
			if(flag == EDIT && i == page)
				goto END;
			if(i<3)
				dialog_window("Cannot use default chain", NULL);
			else
				dialog_window("Chain name violation", NULL);
			return;
		}
	}
	
	for(i=0; flag == EDIT && i<maxchains; i++) {
		for(j=0; j<GTK_CLIST(fwchain[i].rulelist)->rows; j++) {
			gtk_clist_get_text(
				GTK_CLIST(fwchain[i].rulelist), j, 6, &text);
			if(strcmp(text, fwchain[page].label))
				continue;
			gtk_clist_set_text(
				GTK_CLIST(fwchain[i].rulelist), j,6,chain);
		}
	}
	if(flag != EDIT)
		page = maxchains++;
	fwchain[page].refcnt = 1;
	strcpy(fwchain[page].label, chain);
	strcpy(fwchain[page].policy, "-");

	if(flag != EDIT)
		draw_chain(notebook, page);
	else
		gtk_label_set_text(GTK_LABEL(fwchain[page].tablabel), chain);

	modified = 1;
END:
	gtk_widget_destroy(chain_win);
	chain_win = NULL;
}
