#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "gfcc.h"

static void close_dialog(GtkWidget *, gpointer);

void (* tcallback)();

GtkWidget *gfcc_toggle_new(GtkWidget *box,
		GtkSignalFunc callback, gpointer data)
{
	GtkWidget *button;

	button = gtk_toggle_button_new_with_label("!");
	gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);
	gtk_widget_set_usize(button, 12, 10);
	gtk_widget_realize(button);
	gtk_signal_connect(GTK_OBJECT(button), "toggled", callback, data);
	
	return button;
}

void menu_separator(GtkWidget *menu)
{
	GtkWidget *menu_item = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_set_sensitive(menu_item, FALSE);
	gtk_widget_show(menu_item);
}

static void close_dialog(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(gtk_widget_get_toplevel(widget));
	tcallback();
}

void dialog_window(gchar *message, GtkSignalFunc callback)
{
	GtkWidget *dwin, *label, *button;
	
	dwin = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dwin), "Message Window");
	gtk_window_set_position(GTK_WINDOW(dwin), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width(GTK_CONTAINER(dwin), 0);
	gtk_widget_set_usize(dwin, 250, 150);
	
	label = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dwin)->vbox), label,TRUE,TRUE,0);
	gtk_widget_show(label);
	
	if(callback) {
		tcallback = callback;
		button = gtk_button_new_with_label("OK");
		gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(close_dialog), GTK_OBJECT(dwin));
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dwin)->action_area),
				button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		button = gtk_button_new_with_label("Cancel");
	} else
		button = gtk_button_new_with_label("OK");
	
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dwin));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dwin)->action_area), button,
			TRUE, TRUE, 0);
	gtk_widget_show(button);
	
	gtk_widget_show(dwin);
}

GtkWidget *gfcc_pixmap_button_new(GtkWidget *box, gchar **pixmapdata,
		gint width, gint height, GtkSignalFunc callback, gpointer data)
{
	GtkWidget *button;
	GtkWidget *pixmap;

	button = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);
	gtk_widget_realize(button);

	pixmap = new_pixmap(button, pixmapdata);
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	
	gtk_signal_connect(GTK_OBJECT(button), "clicked", callback, data);
	gtk_widget_set_usize(button, width, height);
	gtk_widget_show(button);

	return button;
}

GtkWidget *new_pixmap(GtkWidget *w, gchar **data)
{
	GdkPixmap *gdkpixmap;
	GdkBitmap *pmask;
	GtkWidget *pixmap;
	
	gdkpixmap = gdk_pixmap_create_from_xpm_d(w->window, &pmask,
			&w->style->bg[GTK_STATE_NORMAL], data);
	pixmap = gtk_pixmap_new(gdkpixmap, pmask);
	
	gdk_pixmap_unref(gdkpixmap);
	gdk_pixmap_unref(pmask);
	
	return pixmap;
}

GtkWidget * append_submenu_item(
		GtkWidget *submenu, GtkSignalFunc func, gchar *text)
{
	GtkWidget *menuitem = gtk_menu_item_new_with_label(text);
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(submenu), menuitem);
	
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			GTK_SIGNAL_FUNC(func), text);

	return menuitem;
}

GtkWidget *create_menu_item(GtkWidget *menu, gchar *label,
	gint sensitive_flag, GtkSignalFunc this_func, gpointer this_func_data)
{
	GtkWidget *menu_item;

	menu_item = gtk_menu_item_new_with_label(label);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_set_sensitive(menu_item, sensitive_flag);
	gtk_widget_show(menu_item);
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(this_func), this_func_data);
	
	return menu_item;
}

GtkWidget *gfcc_entry_new(GtkWidget *box, gint max, gint width,
					gint height, gchar *defaultval)
{
	GtkWidget *newentry;
	
	if(max)
		newentry = gtk_entry_new_with_max_length(max);
	else
		newentry = gtk_entry_new();
	
	gtk_box_pack_start(GTK_BOX(box), newentry, FALSE, FALSE, 0);
	gtk_widget_set_usize(newentry, width, height);
	gtk_widget_show(newentry);
	
	if(defaultval)
		gtk_entry_set_text(GTK_ENTRY(newentry), defaultval);
	
	return newentry;
}

GtkWidget *gfcc_label_new(GtkWidget *box, gchar *message)
{
	GtkWidget *label;
	
	label = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	
	return label;
}
