/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003 The GFC Development Team.
 *
 *  marshal.cc - GObject signal callback functions.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gdk/gdk.h>
#include <sigc++/sigc++.h>
#include "private/marshal.hh"
#include <gfc/glib/private/connection.hh>
#include <gfc/gdk/display.hh>

using namespace GFC;

/*  Gdk::Marshal::void_display_callback
 */

void
Gdk::Marshal::void_display_callback(void *data, GdkDisplay *arg)
{
	G::Connection *c = static_cast<G::Connection*>(data);
	if (c)
	{
		typedef	sigc::slot<void, Display&> SlotType;
		SlotType& slot = static_cast<SlotType&>(c->slot_);
		slot(*G::Object::wrap<Display>(arg));
	}
}
