/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  range.inl - Gtk::Range inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkRange*
GFC::Gtk::Range::gtk_range() const
{
	return reinterpret_cast<GtkRange*>(instance_);
}

inline GFC::Gtk::Range::operator GtkRange* () const
{
	return this ? gtk_range() : 0;
}

inline bool
GFC::Gtk::Range::get_inverted() const
{
	return gtk_range_get_inverted(gtk_range());
}

inline double
GFC::Gtk::Range::get_value() const
{
	return gtk_range_get_value(gtk_range());
}

inline void
GFC::Gtk::Range::set_round_digits(int round_digits)
{
	gtk_range()->round_digits = round_digits;
}

inline void
GFC::Gtk::Range::set_update_policy(UpdateType policy)
{
	gtk_range_set_update_policy(gtk_range(), (GtkUpdateType)policy);
}

inline void
GFC::Gtk::Range::set_inverted(bool setting)
{
	gtk_range_set_inverted(gtk_range(), setting);
}

inline void
GFC::Gtk::Range::set_increments(double step, double page)
{
	gtk_range_set_increments(gtk_range(), step, page);
}

inline void
GFC::Gtk::Range::set_range(double min, double max)
{
	gtk_range_set_range(gtk_range(), min, max);
}

inline void
GFC::Gtk::Range::set_value(double value)
{
	gtk_range_set_value(gtk_range(), value);
}

inline const GFC::Gtk::Range::ValueChangedSignalProxy 
GFC::Gtk::Range::sig_value_changed()
{
	return ValueChangedSignalProxy(this, &value_changed_signal);
}

inline const GFC::Gtk::Range::AdjustBoundsSignalProxy 
GFC::Gtk::Range::sig_adjust_bounds()
{
	return AdjustBoundsSignalProxy(this, &adjust_bounds_signal);
}

