/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  objectsignals.cc - Gtk::Object virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "object.hh"
#include "objectsignals.hh"
#include "private/objectclass.hh"

using namespace GFC;

/*  Gtk::ObjectSignals
 */

Gtk::ObjectSignals::ObjectSignals(Object *object)
: G::ObjectSignals(object)
{
	Gtk::ObjectClass::init(GTK_OBJECT_GET_CLASS(object->gtk_object()));
}

Gtk::ObjectSignals::~ObjectSignals()
{
}

void
Gtk::ObjectSignals::on_destroy()
{
	GtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->destroy)
		g_class->destroy((GtkObject*)instance_);
}

/*  Gtk::ObjectClass
 */

void
Gtk::ObjectClass::init(GtkObjectClass *g_class)
{
	g_class->destroy = &destroy_proxy;
}

GtkObjectClass*
Gtk::ObjectClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_OBJECT_GET_CLASS(instance));
	return static_cast<GtkObjectClass*>(ptr);
}

GType
Gtk::ObjectClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_OBJECT);
	}
	return type;
}

void*
Gtk::ObjectClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ObjectClass::destroy_proxy(GtkObject *object)
{
	void *ptr = g_object_get_qdata((GObject*)object, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_destroy();
	else
	{
		GtkObjectClass *g_class = ObjectClass::get_parent_class(object);
		if (g_class->destroy)
			g_class->destroy(object);
	}
}

