/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  range.cc - GtkRange C++ wrapper implmentation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "range.hh"
#include "private/rangeclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Range
 */

Gtk::Range::Range(GtkRange *range, bool owns_reference)
: Widget((GtkWidget*)range, owns_reference)
{
}

Gtk::Range::Range()
: Widget((GtkWidget*)RangeClass::create())
{
}

Gtk::Range::~Range()
{
}

Gtk::UpdateType
Gtk::Range::get_policy() const
{
	return (UpdateType)gtk_range_get_update_policy(gtk_range());
}

Gtk::Adjustment*
Gtk::Range::get_adjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_range_get_adjustment(gtk_range()));
}

void
Gtk::Range::set_adjustment(Adjustment *adjustment)
{
	gtk_range_set_adjustment(gtk_range(), *adjustment);
}

/*  Gtk::Range signals
 */

const Gtk::Range::ValueChangedSignalType Gtk::Range::value_changed_signal("value_changed", (GCallback)&G::Marshal::void_callback);

const Gtk::Range::AdjustBoundsSignalType Gtk::Range::adjust_bounds_signal("adjust_bounds", (GCallback)&Marshal::void_double_callback);

