/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toolbuttonsignals.cc - Gtk::ToolButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toolbutton.hh"
#include "toolbuttonsignals.hh"
#include "private/toolbuttonclass.hh"

using namespace GFC;

/*  Gtk::ToolButtonSignals
 */

Gtk::ToolButtonSignals::ToolButtonSignals(ToolButton *tool_button)
: ToolItemSignals(tool_button)
{
	Gtk::ToolButtonClass::init(GTK_TOOL_BUTTON_GET_CLASS(tool_button->gtk_tool_button()));
}

Gtk::ToolButtonSignals::~ToolButtonSignals()
{
}

void
Gtk::ToolButtonSignals::on_clicked()
{
	GtkToolButtonClass *g_class = ToolButtonClass::get_parent_class(instance_);
	if (g_class->clicked)
		g_class->clicked((GtkToolButton*)instance_);
}

/*  Gtk::ToolButtonClass
 */

void
Gtk::ToolButtonClass::init(GtkToolButtonClass *g_class)
{
	g_class->clicked = &clicked_proxy;
}

GtkToolButtonClass*
Gtk::ToolButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TOOL_BUTTON_GET_CLASS(instance));
	return static_cast<GtkToolButtonClass*>(ptr);
}

GType
Gtk::ToolButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOOL_BUTTON);
	}
	return type;
}

void*
Gtk::ToolButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ToolButtonClass::clicked_proxy(GtkToolButton *tool_button)
{
	void *ptr = g_object_get_qdata((GObject*)tool_button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToolButtonSignals*>(ptr)->on_clicked();
	else
	{
		GtkToolButtonClass *g_class = ToolButtonClass::get_parent_class(tool_button);
		if (g_class->clicked)
			g_class->clicked(tool_button);
	}
}

