module Helper where
import           DynFlags (Settings(..), DynFlags, defaultDynFlags)
import           Platform
import           PlatformConstants

dynFlags :: DynFlags
dynFlags = defaultDynFlags settings
  where
    settings = Settings {
        sTargetPlatform = platform
      , sGhcUsagePath = error "Haddock.ParserSpec.sGhcUsagePath"
      , sGhciUsagePath = error "Haddock.ParserSpec.sGhciUsagePath"
      , sTopDir = error "Haddock.ParserSpec.sTopDir"
      , sTmpDir = error "Haddock.ParserSpec.sTmpDir"
      , sRawSettings = []
      , sExtraGccViaCFlags = error "Haddock.ParserSpec.sExtraGccViaCFlags"
      , sSystemPackageConfig = error "Haddock.ParserSpec.sSystemPackageConfig"
      , sPgm_L = error "Haddock.ParserSpec.sPgm_L"
      , sPgm_P = error "Haddock.ParserSpec.sPgm_P"
      , sPgm_F = error "Haddock.ParserSpec.sPgm_F"
      , sPgm_c = error "Haddock.ParserSpec.sPgm_c"
      , sPgm_s = error "Haddock.ParserSpec.sPgm_s"
      , sPgm_a = error "Haddock.ParserSpec.sPgm_a"
      , sPgm_l = error "Haddock.ParserSpec.sPgm_l"
      , sPgm_dll = error "Haddock.ParserSpec.sPgm_dll"
      , sPgm_T = error "Haddock.ParserSpec.sPgm_T"
      , sPgm_sysman = error "Haddock.ParserSpec.sPgm_sysman"
      , sPgm_windres = error "Haddock.ParserSpec.sPgm_windres"
      , sPgm_libtool = error "Haddock.ParserSpec.sPgm_libtool"
      , sPgm_lo = error "Haddock.ParserSpec.sPgm_lo"
      , sPgm_lc = error "Haddock.ParserSpec.sPgm_lc"
      , sOpt_L = []
      , sOpt_P = []
      , sOpt_F = []
      , sOpt_c = []
      , sOpt_a = []
      , sOpt_l = []
      , sOpt_windres = []
      , sOpt_lo = []
      , sOpt_lc = []
      , sLdSupportsCompactUnwind = error "Haddock.ParserSpec.sLdSupportsCompactUnwind"
      , sLdSupportsBuildId  = error "Haddock.ParserSpec.sLdSupportsBuildId "
      , sLdSupportsFilelist  = error "Haddock.ParserSpec.sLdSupportsFilelist "
      , sLdIsGnuLd = error "Haddock.ParserSpec.sLdIsGnuLd"
      , sPlatformConstants = platformConstants
      }
    platform = Platform {
        platformArch = ArchUnknown
      , platformOS = OSUnknown
      , platformWordSize = 64
      , platformHasGnuNonexecStack = False
      , platformHasIdentDirective = False
      , platformHasSubsectionsViaSymbols = False
      , platformUnregisterised = error "Haddock.ParserSpec.platformUnregisterised"
      }

    platformConstants = PlatformConstants {
        pc_platformConstants = ()
      , pc_STD_HDR_SIZE = 0
      , pc_PROF_HDR_SIZE = 0
      , pc_BLOCK_SIZE = 0
      , pc_BLOCKS_PER_MBLOCK = 0
      , pc_OFFSET_StgRegTable_rR1 = 0
      , pc_OFFSET_StgRegTable_rR2 = 0
      , pc_OFFSET_StgRegTable_rR3 = 0
      , pc_OFFSET_StgRegTable_rR4 = 0
      , pc_OFFSET_StgRegTable_rR5 = 0
      , pc_OFFSET_StgRegTable_rR6 = 0
      , pc_OFFSET_StgRegTable_rR7 = 0
      , pc_OFFSET_StgRegTable_rR8 = 0
      , pc_OFFSET_StgRegTable_rR9 = 0
      , pc_OFFSET_StgRegTable_rR10 = 0
      , pc_OFFSET_StgRegTable_rF1 = 0
      , pc_OFFSET_StgRegTable_rF2 = 0
      , pc_OFFSET_StgRegTable_rF3 = 0
      , pc_OFFSET_StgRegTable_rF4 = 0
      , pc_OFFSET_StgRegTable_rF5 = 0
      , pc_OFFSET_StgRegTable_rF6 = 0
      , pc_OFFSET_StgRegTable_rD1 = 0
      , pc_OFFSET_StgRegTable_rD2 = 0
      , pc_OFFSET_StgRegTable_rD3 = 0
      , pc_OFFSET_StgRegTable_rD4 = 0
      , pc_OFFSET_StgRegTable_rD5 = 0
      , pc_OFFSET_StgRegTable_rD6 = 0
      , pc_OFFSET_StgRegTable_rXMM1 = 0
      , pc_OFFSET_StgRegTable_rXMM2 = 0
      , pc_OFFSET_StgRegTable_rXMM3 = 0
      , pc_OFFSET_StgRegTable_rXMM4 = 0
      , pc_OFFSET_StgRegTable_rXMM5 = 0
      , pc_OFFSET_StgRegTable_rXMM6 = 0
      , pc_OFFSET_StgRegTable_rL1 = 0
      , pc_OFFSET_StgRegTable_rSp = 0
      , pc_OFFSET_StgRegTable_rSpLim = 0
      , pc_OFFSET_StgRegTable_rHp = 0
      , pc_OFFSET_StgRegTable_rHpLim = 0
      , pc_OFFSET_StgRegTable_rCCCS = 0
      , pc_OFFSET_StgRegTable_rCurrentTSO = 0
      , pc_OFFSET_StgRegTable_rCurrentNursery = 0
      , pc_OFFSET_StgRegTable_rHpAlloc = 0
      , pc_OFFSET_stgEagerBlackholeInfo = 0
      , pc_OFFSET_stgGCEnter1 = 0
      , pc_OFFSET_stgGCFun = 0
      , pc_OFFSET_Capability_r = 0
      , pc_OFFSET_bdescr_start = 0
      , pc_OFFSET_bdescr_free = 0
      , pc_OFFSET_bdescr_blocks = 0
      , pc_SIZEOF_CostCentreStack = 0
      , pc_OFFSET_CostCentreStack_mem_alloc = 0
      , pc_REP_CostCentreStack_mem_alloc = 0
      , pc_OFFSET_CostCentreStack_scc_count = 0
      , pc_REP_CostCentreStack_scc_count = 0
      , pc_OFFSET_StgHeader_ccs = 0
      , pc_OFFSET_StgHeader_ldvw = 0
      , pc_SIZEOF_StgSMPThunkHeader = 0
      , pc_OFFSET_StgEntCounter_allocs = 0
      , pc_REP_StgEntCounter_allocs = 0
      , pc_OFFSET_StgEntCounter_allocd = 0
      , pc_REP_StgEntCounter_allocd = 0
      , pc_OFFSET_StgEntCounter_registeredp = 0
      , pc_OFFSET_StgEntCounter_link = 0
      , pc_OFFSET_StgEntCounter_entry_count = 0
      , pc_SIZEOF_StgUpdateFrame_NoHdr = 0
      , pc_SIZEOF_StgMutArrPtrs_NoHdr = 0
      , pc_OFFSET_StgMutArrPtrs_ptrs = 0
      , pc_OFFSET_StgMutArrPtrs_size = 0
      , pc_SIZEOF_StgArrWords_NoHdr = 0
      , pc_OFFSET_StgTSO_cccs = 0
      , pc_OFFSET_StgTSO_stackobj = 0
      , pc_OFFSET_StgStack_sp = 0
      , pc_OFFSET_StgStack_stack = 0
      , pc_OFFSET_StgUpdateFrame_updatee = 0
      , pc_SIZEOF_StgFunInfoExtraRev = 0
      , pc_MAX_SPEC_SELECTEE_SIZE = 0
      , pc_MAX_SPEC_AP_SIZE = 0
      , pc_MIN_PAYLOAD_SIZE = 0
      , pc_MIN_INTLIKE = 0
      , pc_MAX_INTLIKE = 0
      , pc_MIN_CHARLIKE = 0
      , pc_MAX_CHARLIKE = 0
      , pc_MUT_ARR_PTRS_CARD_BITS = 0
      , pc_MAX_Vanilla_REG = 0
      , pc_MAX_Float_REG = 0
      , pc_MAX_Double_REG = 0
      , pc_MAX_Long_REG = 0
      , pc_MAX_XMM_REG = 0
      , pc_MAX_Real_Vanilla_REG = 0
      , pc_MAX_Real_Float_REG = 0
      , pc_MAX_Real_Double_REG = 0
      , pc_MAX_Real_XMM_REG = 0
      , pc_MAX_Real_Long_REG = 0
      , pc_RESERVED_C_STACK_BYTES = 0
      , pc_RESERVED_STACK_WORDS = 0
      , pc_AP_STACK_SPLIM = 0
      , pc_WORD_SIZE = 0
      , pc_DOUBLE_SIZE = 0
      , pc_CINT_SIZE = 0
      , pc_CLONG_SIZE = 0
      , pc_CLONG_LONG_SIZE = 0
      , pc_BITMAP_BITS_SHIFT = 0
      , pc_TAG_BITS = 0
      , pc_WORDS_BIGENDIAN = False
      , pc_DYNAMIC_BY_DEFAULT = False
      , pc_LDV_SHIFT = 0
      , pc_ILDV_CREATE_MASK = 0
      , pc_ILDV_STATE_CREATE = 0
      , pc_ILDV_STATE_USE = 0
      , pc_OFFSET_StgRegTable_rYMM1 = 0
      , pc_OFFSET_StgRegTable_rYMM2 = 0
      , pc_OFFSET_StgRegTable_rYMM3 = 0
      , pc_OFFSET_StgRegTable_rYMM4 = 0
      , pc_OFFSET_StgRegTable_rYMM5 = 0
      , pc_OFFSET_StgRegTable_rYMM6 = 0
      , pc_OFFSET_StgRegTable_rZMM1 = 0
      , pc_OFFSET_StgRegTable_rZMM2 = 0
      , pc_OFFSET_StgRegTable_rZMM3 = 0
      , pc_OFFSET_StgRegTable_rZMM4 = 0
      , pc_OFFSET_StgRegTable_rZMM5 = 0
      , pc_OFFSET_StgRegTable_rZMM6 = 0
      , pc_OFFSET_StgFunInfoExtraFwd_arity = 0
      , pc_REP_StgFunInfoExtraFwd_arity = 0
      , pc_OFFSET_StgFunInfoExtraRev_arity = 0
      , pc_REP_StgFunInfoExtraRev_arity = 0
      }
