/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMV_IMAGE_H__
#define __GIMV_IMAGE_H__

#include "gimageview.h"


#define IMG_TYPE_NUM 13

/* definition of image format */
/* public image format */
#define IMG_TIF "TIFF"
#define IMG_JPG "JPEG"
#define IMG_PNG "PNG"
/* X Window System Image Format */
#define IMG_XBM "XBM"             /* X11 Bitmap */
#define IMG_XPM "XPM"             /* X11 Pixmap */
#define IMG_XWD "XWD"             /* X Window Dump */
/* PNM (Portable aNyMap) */
#define IMG_PPM "PPM"             /* full color */
#define IMG_PGM "PGM"             /* gray scale */
#define IMG_PBM "PBM"             /* mono */
/* IBM PC */
#define IMG_BMP "BMP"             /* Window Bitmap */
#define IMG_PCX "PCX"
/* Macintosh */
#define IMG_PICT "PICT"           /* not support yet */
/* etc */
#define IMG_TGA  "TGA"
#define IMG_MAG  "MAG"
/* f*ck'in */
#define IMG_GIF "GIF"
#define IMG_UNKNOWN "UNKNOWN"


#if HAVE_GDK_PIXBUF
#  include <gdk-pixbuf/gdk-pixbuf.h>
typedef GdkPixbuf GimvImage;
#else
#if HAVE_GDK_IMLIB
#  include <gdk_imlib.h>
typedef GdkImlibImage GimvImage;
#endif /* HAVE_GDK_IMLIB */
#endif /* HAVE_GDK_PIXBUF */

void       gimv_image_init                 ();
GimvImage *gimv_image_load_file            (const gchar  *filename);
GimvImage *gimv_image_create_from_data     (guchar       *data,
					    gint          width,
					    gint          height);
GimvImage *gimv_image_create_from_drawable (GdkWindow    *win,
					    gint          x,
					    gint          y,
					    gint          width,
					    gint          height);
GimvImage *gimv_image_rotate_90            (GimvImage    *src_image,
					    gboolean      counter_clockwise);
GimvImage *gimv_image_rotate_180           (GimvImage    *src_image);
void       gimv_image_get_pixmap_and_mask  (GimvImage    *image,
					    GdkPixmap   **pixmap_return,
					    GdkBitmap   **mask_return);
void       gimv_image_free_pixmap_and_mask (GdkPixmap    *pixmap,
					    GdkBitmap    *mask);
GimvImage *gimv_image_scale_and_dump       (GimvImage    *src_image,
					    gint          width,
					    gint          height);
void       gimv_image_scale_get_pixmap     (GimvImage    *src_image,
					    gint          width,
					    gint          height,
					    GdkPixmap   **pixmap_return,
					    GdkBitmap   **mask_return);
void       gimv_image_get_size             (GimvImage    *image,
					    gint         *width,
					    gint         *height);
gint       gimv_image_width                (GimvImage    *image);
gint       gimv_image_height               (GimvImage    *image);
void       gimv_image_kill                 (GimvImage    *image);
gchar     *gimv_image_detect_type_by_ext   (const gchar  *str);

/* FIXME!! Implement as plugin */
gboolean   gimv_image_save_file_as_png     (GimvImage    *image,
					    const char   *filename);
gboolean   gimv_image_save_file_as_ppm     (GimvImage    *image,
					    const char   *filename);
/* End FIXME!! */

guchar    *xvpics_load                     (const gchar  *filename,
					    gint         *widthp,
					    gint         *heightp);
GimvImage *gimv_image_get_xv_thumbnail     (const gchar  *thumb_filename);

#endif /* __GIMV_IMAGE_H__ */
