/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PREFS_H__
#define __PREFS_H__

#include <gtk/gtk.h>

typedef enum
{
   WINTYPE_DEFAULT = -1,
   IMAGE_VIEW_WINDOW = 0,
   THUMBNAIL_WINDOW  = 1
} ImgWinType;


typedef struct _Config {
   /* General Option */
   gint       default_file_open_window;
   gint       default_dir_open_window;
   gboolean   scan_dir_recursive;
   gboolean   recursive_follow_link;
   gboolean   recursive_follow_parent;
   gboolean   read_dotfile;
   gboolean   detect_filetype_by_ext;
   gboolean   disp_filename_stdout;
#if HAVE_GDK_PIXBUF
   gint       interpolation;
#else
#if HAVE_GDK_IMLIB
#endif /* HAVE_GDK_IMLIB */
#endif /* HAVE_GDK_PIXBUF */
   gboolean   conv_rel_path_to_abs;
   gchar     *iconset;

   /* Boot Time Option */
   gboolean   startup_read_dir;
   gboolean   startup_open_thumbwin;
   gboolean   startup_no_warning;

   /* Image View */
   guint      imgwin_width;
   guint      imgwin_height;
   gboolean   imgwin_fit_to_image;
   gboolean   imgwin_open_new_win;
   gboolean   imgwin_raise_window;
   gboolean   imgwin_show_menubar;
   gboolean   imgwin_show_toolbar;
   gboolean   imgwin_show_statusbar;
   gint       imgwin_toolbar_style;

   guint      imgview_scale;
   gboolean   imgview_keep_aspect;
   gboolean   imgview_fit_image_to_win;
   gboolean   imgview_buffer;
   gboolean   imgview_scroll_nolimit;

   /* Thumbnail View */
   gboolean   thumbwin_save_win_state;
   guint      thumbwin_width;
   guint      thumbwin_height;
   gint       thumbwin_layout_type;
   gboolean   thumbwin_pane1_horizontal;
   gboolean   thumbwin_pane2_horizontal;
   gboolean   thumbwin_pane2_attach_1;
   gint       thumbwin_widget[3];
   guint      thumbwin_pane_size1;
   guint      thumbwin_pane_size2;

   gboolean   thumbwin_show_dir_view;
   gboolean   thumbwin_show_preview;
   gboolean   thumbwin_show_menubar;
   gboolean   thumbwin_show_toolbar;
   gboolean   thumbwin_show_statusbar;
   gboolean   thumbwin_show_tab;

   gboolean   thumbwin_raise_window;
   gint       thumbwin_toolbar_style;
   gchar     *thumbwin_disp_mode;

   gint       thumbwin_tab_pos;
   gboolean   thumbwin_move_to_newtab;
   gboolean   thumbwin_show_tab_close;
   gboolean   thumbwin_tab_fullpath;
   gboolean   thumbwin_force_open_tab;

   guint      thumbwin_thumb_size;
   guint      thumbwin_redraw_interval;

   /* Thumbnail Table */
   guint      thumbtable_colnum_min;
   guint      thumbtable_colnum_max;
   guint      thumbtable_row_space;
   guint      thumbtable_col_space;
   guint      thumbbutton_border_width;

   /* Directory View */
   gboolean   dirview_show_toolbar;
   gboolean   dirview_show_dotfile;
   gboolean   dirview_show_current_dir;
   gboolean   dirview_show_parent_dir;
   gint       dirview_line_style;
   gint       dirview_expander_style;
   gboolean   dirview_auto_scroll;
   gint       dirview_auto_scroll_time;
   gboolean   dirview_auto_expand;
   gint       dirview_auto_expand_time;

   /* Thumbnail Cache */
   gboolean   cache_gimv;
   gboolean   cache_nautilus;
   gboolean   cache_konqueror_l;
   gboolean   cache_konqueror_m;
   gboolean   cache_konqueror_s;
   gboolean   cache_kde_2_2;
   gboolean   cache_gqview;
   gboolean   cache_ee_l;
   gboolean   cache_ee_m;
   gboolean   cache_ee_s;
   gboolean   cache_picview;
   gboolean   cache_xvpics;
   gint       cache_write_type;
   gint       cache_gimv_write_size;
   gint       cache_gqview_write_size;

   /* Slide Show */
   gboolean   slideshow_fit_to_win;
   guint      slideshow_img_scale;
   gboolean   slideshow_fullscreen;
   gboolean   slideshow_menubar;
   gboolean   slideshow_toolbar;
   gboolean   slideshow_statusbar;
   gboolean   slideshow_scrollbar;
   gboolean   slideshow_keep_aspect;
   gfloat     slideshow_interval;
   gboolean   slideshow_repeat;

   /* drag and drop */
   gboolean   dnd_enable_to_external;
   gboolean   dnd_enable_from_external;
   gboolean   dnd_refresh_list_always;

   /* External Program */
   gchar     *progs[16];
   gchar     *text_viewer;
   gboolean   text_viewer_use_internal;
} Config;

typedef struct _KeyConf {
   gchar *common_open;
   gchar *common_thumbwin;
   gchar *common_quit;
   gchar *common_prefs;
   gchar *common_toggle_menubar;
   gchar *common_toggle_toolbar;
   gchar *common_toggle_tab;
   gchar *common_toggle_statusbar;
   gchar *common_fullscreen;

   gchar *imgwin_buffer;
   gchar *imgwin_close;

   gchar *imgwin_fit_win;

   gchar *imgwin_zoomin;
   gchar *imgwin_zoomout;
   gchar *imgwin_fit_img;
   gchar *imgwin_keep_aspect;
   gchar *imgwin_zoom10;
   gchar *imgwin_zoom25;
   gchar *imgwin_zoom50;
   gchar *imgwin_zoom75;
   gchar *imgwin_zoom100;
   gchar *imgwin_zoom125;
   gchar *imgwin_zoom150;
   gchar *imgwin_zoom175;
   gchar *imgwin_zoom200;

   gchar *imgwin_rotate_ccw;
   gchar *imgwin_rotate_cw;
   gchar *imgwin_rotate_180;

   gchar *thumbwin_layout0;
   gchar *thumbwin_layout1;
   gchar *thumbwin_layout2;
   gchar *thumbwin_layout3;
   gchar *thumbwin_layout4;
   gchar *thumbwin_custom;
   gchar *thumbwin_slideshow;
   gchar *thumbwin_first_page;
   gchar *thumbwin_last_page;
   gchar *thumbwin_next_page;
   gchar *thumbwin_prev_page;
   gchar *thumbwin_toggle_dir_toolbar;
   gchar *thumbwin_toggle_dirview;
   gchar *thumbwin_toggle_preview;
   gchar *thumbwin_new_tab;
   gchar *thumbwin_new_collection;
   gchar *thumbwin_close_tab;
   gchar *thumbwin_close_win;

   gchar *thumbwin_select_all;
   gchar *thumbwin_unselect_all;
   gchar *thumbwin_refresh_list;
   gchar *thumbwin_reload_cache;
   gchar *thumbwin_recreate_thumb;
   gchar *thumbwin_move_tab_forward;
   gchar *thumbwin_move_tab_backward;
   gchar *thumbwin_detach_tab;

   gchar *thumbwin_sort_name;
   gchar *thumbwin_sort_atime;
   gchar *thumbwin_sort_mtime;
   gchar *thumbwin_sort_ctime;
   gchar *thumbwin_sort_size;
   gchar *thumbwin_sort_type;
   gchar *thumbwin_sort_rev;
} KeyConf;

extern Config conf;
extern KeyConf akey;

void prefs_load_config_default ();
void prefs_load_config ();
void prefs_save_config ();
void prefs_bind_key ();

#endif /* __PREFS_H__ */
