/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GFILEUTIL_H__
#define __GFILEUTIL_H__

#include <gtk/gtk.h>

#include "gtkutils.h"


typedef enum
{
   GETDIR_READ_DOT       = 1 << 0,
   GETDIR_FOLLOW_SYMLINK = 1 << 1,
   GETDIR_DETECT_EXT     = 1 << 2,
   GETDIR_DISP_STDOUT    = 1 << 3,
   GETDIR_DISP_STDERR    = 1 << 4,
   GETDIR_ENABLE_CANCEL  = 1 << 5
} GetDirFlags;


void      get_dir           (const gchar     *dirname,
			     GetDirFlags      flags,
			     GList          **filelist,
			     GList          **dirlist);
void      get_dir_stop      ();
GList    *get_dir_all       (const gchar     *dirname);
gchar    *link2abs          (const gchar     *path);


gboolean  move_file         (const gchar   *from_path,
			     const gchar   *dir,
			     ConfirmType   *action,
			     gboolean       show_error);
gboolean  copy_file_to_file (const gchar   *from_path,
			     const gchar   *to_path,
			     ConfirmType   *action,
			     gboolean       show_error);
gboolean  copy_file         (const gchar   *from_path,
			     const gchar   *dir,
			     ConfirmType   *action,
			     gboolean       show_error);
gboolean  link_file         (const gchar   *from_path,
			     const gchar   *dir,
			     gboolean       show_error);

#endif
