/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <string.h>
#include <gtk/gtk.h>

#include "fileutil.h"
#include "icon.h"

/* common icons */
#include "pixmaps/nfolder.xpm"
#include "pixmaps/paper.xpm"
#include "pixmaps/prefs.xpm"
#include "pixmaps/alert.xpm"
#include "pixmaps/question.xpm"
#include "pixmaps/image.xpm"

/* icons for image window */
#include "pixmaps/no_zoom.xpm"
#include "pixmaps/zoom_in.xpm"
#include "pixmaps/zoom_out.xpm"
#include "pixmaps/zoom_fit.xpm"
#include "pixmaps/zoom.xpm"
#include "pixmaps/rotate.xpm"
#include "pixmaps/resize.xpm"
#include "pixmaps/fullscreen.xpm"

/* icons for thumbnail window */
#include "pixmaps/refresh.xpm"
#include "pixmaps/skip.xpm"
#include "pixmaps/stop.xpm"
#include "pixmaps/leftarrow.xpm"
#include "pixmaps/rightarrow.xpm"
#include "pixmaps/close.xpm"
#include "pixmaps/small_close.xpm"

/* icons for directory view */
#include "pixmaps/folder.xpm"
#include "pixmaps/folder-open.xpm"
#include "pixmaps/small_home.xpm"
#include "pixmaps/small_up.xpm"
#include "pixmaps/small_refresh.xpm"
#include "pixmaps/dotfile.xpm"


typedef struct DefaultIcon_Tag
{
   gchar   *name;
   char   **data;
} DefaultIcon;


static DefaultIcon default_icons [] = {
   {"nfolder",           nfolder_xpm},
   {"paper",             paper_xpm},
   {"prefs",             prefs_xpm},
   {"alert",             alert_xpm},
   {"question",          question_xpm},
   {"image",             image_xpm},

   {"no_zoom",           no_zoom_xpm},
   {"zoom_in",           zoom_in_xpm},
   {"zoom_out",          zoom_out_xpm},
   {"zoom_fit",          zoom_fit_xpm},
   {"zoom",              zoom_xpm},
   {"rotate",            rotate_xpm},
   {"resize",            resize_xpm},
   {"fullscreen",        fullscreen_xpm},

   {"refresh",           refresh_xpm},
   {"skip",              skip_xpm},
   {"stop",              stop_xpm},
   {"leftarrow",         leftarrow_xpm},
   {"rightarrow",        rightarrow_xpm},
   {"close",             close_xpm},
   {"small_close",       small_close_xpm},

   {"folder",            folder_xpm},
   {"folder-open",       folder_open_xpm},
   {"small_home",        small_home_xpm},
   {"small_up",          small_up_xpm},
   {"small_refresh",     small_refresh_xpm},
   {"dotfile",           dotfile_xpm},
};
static gint default_icons_num
               = sizeof (default_icons) / sizeof (default_icons[0]);


static gchar       *icondir         = NULL,
                   *default_icondir = NULL;
static GdkColormap *sys_colormap    = NULL;
static GHashTable  *icons           = NULL;


gboolean
icon_init (gchar *iconset)
{
   Icon *icon;

   if (!default_icondir)
      default_icondir = g_strconcat (ICONDIR, "/", DEFAULT_ICONSET, NULL);
   if (icondir)
      g_free (icondir);
   if (iconset)
      icondir = g_strconcat (ICONDIR, "/", iconset, NULL);
   /* if (!file_exists (icondir)) return FALSE; */

   icons = g_hash_table_new (g_str_hash, g_str_equal);

   if (!sys_colormap)
   sys_colormap = gdk_colormap_get_system ();

   /* set drag icon */
   icon = icon_get ("image");
   if (icon)
      gtk_drag_set_default_icon (sys_colormap,
				 icon->pixmap, icon->mask,
				 0, 0);

   return TRUE;
}


Icon *
icon_get (const gchar *icon_name)
{
   gchar *path = NULL;
   Icon *icon;
   gint i;

   g_return_val_if_fail (icon_name, NULL);;

   icon = g_hash_table_lookup (icons, icon_name);

   if (icon) {
      return icon;
   }

   icon = g_new0 (Icon, 1);
   icon->pixmap = NULL;
   icon->mask = NULL;

   if (icondir) {
      path = g_strconcat (icondir, "/", icon_name, ".xpm", NULL);
      if (file_exists (path))
	 icon->pixmap = gdk_pixmap_colormap_create_from_xpm (NULL, sys_colormap,
							     &icon->mask, NULL, path);
   }

   if (!icon->pixmap) {
      if (path)
	 g_free (path);
      path = g_strconcat (default_icondir, "/", icon_name, ".xpm", NULL);
      if (file_exists (path))
	 icon->pixmap = gdk_pixmap_colormap_create_from_xpm (NULL, sys_colormap,
							     &icon->mask, NULL, path);
   }

   g_free (path);

   if (!icon->pixmap) {
      for (i = 0; i < default_icons_num; i++) {
	 if (!strcmp (icon_name, default_icons[i].name))
	    icon->pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, sys_colormap,
								  &icon->mask, NULL,
								  default_icons[i].data);
      }
   } 

   if (icon->pixmap) {
      g_hash_table_insert (icons, (gchar *) icon_name, icon);
   } else {
      if (icon->mask) gdk_bitmap_unref (icon->mask);
      g_free (icon);
      return NULL;
   }

   return icon;
}


GtkWidget *
icon_get_widget (const gchar *icon_name)
{
   Icon *icon;
   GtkWidget *widget = NULL;

   g_return_val_if_fail (icon_name, NULL);

   icon = icon_get (icon_name);

   if (icon)
      widget = gtk_pixmap_new (icon->pixmap, icon->mask);   

   return widget;
}
