/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __THUMBNAIL_WINDOW_H__
#define __THUMBNAIL_WINDOW_H__

#include "gimageview.h"

#include "dirview.h"
#include "fileload.h"
#include "image_view.h"
#include "thumbnail_view.h"

#define MIN_THUMB_SIZE 4
#define MAX_THUMB_SIZE 640

/* current page of notebook */
#define THUMB_CURRENT_PAGE -1


/* program status */
typedef enum
{
   THUMB_WIN_STATUS_NORMAL,
   THUMB_WIN_STATUS_LOADING,
   THUMB_WIN_STATUS_LOADING_BG,
   THUMB_WIN_STATUS_NO_SENSITIVE
} ThumbwinStatus;


typedef enum
{
   NAME,
   ATIME,
   MTIME,
   CTIME,
   SIZE,
   TYPE
} SortItem;


typedef enum
{
   WIDGET_UNKNOWN,
   WIDGET_DIRVIEW,
   WIDGET_THUMBVIEW,
   WIDGET_PREVIEW
} ThumbwinWidgetType;


typedef struct ThumbwinComposeType_Tag {
   gboolean pane1_horizontal;
   gboolean pane2_horizontal;
   gboolean pane2_attach_to_child1;
   gint     widget_type[3];
} ThumbwinComposeType;

extern ThumbwinComposeType compose_type[];


/* thumbnail window composition */
struct ThumbWindow_Tag
{
   GtkWidget *window;
   GtkWidget *main_vbox;

   /* top of window (menu & toolbar) */
   GtkWidget *menubar;
   GtkWidget *menubar_handle;
   GtkWidget *toolbar;
   GtkWidget *toolbar_handle;
   GtkWidget *location_entry;
   GtkWidget *disp_mode_menu;

   /* middle of window (main contens) */
   GtkWidget *main_contents;
   GtkWidget *dirview;
   GtkWidget *notebook;
   GtkWidget *preview;
   GtkWidget *pane1;
   GtkWidget *pane2;

   /* dir view module */
   DirView   *dv;

   /* image view module */
   ImageView *iv;
   GList *thumb_pos;

   /* bottom of window (status bar) */
   GtkWidget *status_bar_container;
   GtkWidget *status_bar1;
   GtkWidget *status_bar2;
   GtkWidget *status_bar3;
   GtkWidget *progressbar;

   /* popup menu */
   GtkWidget *thumbview_popup;

   /* sub menus */
   GtkWidget *view_menu;
   GtkWidget *sort_menu;

   struct    /* menuitems */
   {
      GtkWidget *file;
      GtkWidget *edit;
      GtkWidget *view;

      GtkWidget *dirview;
      GtkWidget *preview;
      GtkWidget *menubar;
      GtkWidget *toolbar;
      GtkWidget *dir_toolbar;
      GtkWidget *statusbar;
      GtkWidget *tab;
      GtkWidget *fullscr;

      GtkWidget *layout[5];

      GtkWidget *tab_top;
      GtkWidget *tab_bottom;
      GtkWidget *tab_left;
      GtkWidget *tab_right;

      GtkWidget *sort_name;
      GtkWidget *sort_access;
      GtkWidget *sort_time;
      GtkWidget *sort_change;
      GtkWidget *sort_size;
      GtkWidget *sort_type;
      GtkWidget *sort_rev;
   } menuitem;

   struct    /* buttons in toolbar */
   {
      GtkWidget *fileopen;
      GtkWidget *prefs;
      GtkWidget *refresh;
      GtkWidget *skip;
      GtkWidget *stop;
      GtkWidget *prev;
      GtkWidget *next;
      GtkWidget *quit;
      GtkWidget *size_spin;
   } button;

   /* window status */
   ThumbwinStatus status;
   gboolean   show_dirview;
   gboolean   show_preview;
   gboolean   fullscreen;
   gint       win_x;
   gint       win_y;
   gint       win_width;
   gint       win_height;
   gint       pane_size1;
   gint       pane_size2;
   gint       thumb_disp_mode;
   SortItem   sortitem;
   gint       layout_type;
   GtkPositionType tab_pos;

   gint filenum; /* image files number in this window */
   gint pagenum; /* notebook pages number in this window */
   gint newpage_count;
   gint filesize;

   /* File open dialog */
   GtkWidget *open_dialog;
};

/* list of thumbnail widnows */
extern GList *ThumbWinList;

extern GtkWidget *newest_tab;
extern gchar    **disp_mode_labels;
extern gint collection_page_count;


ThumbView   *thumbwin_find_thumbtable           (ThumbWindow    *tw,
						 gint            pagenum);
void         thumbwin_set_statusbar_page_info   (ThumbWindow    *tw,
						 gint            pagenum);
void         thumbwin_set_sensitive             (ThumbWindow    *tw,
						 ThumbwinStatus  status);
void         thumbwin_set_tab_label_text        (GtkWidget      *page_container,
						 const gchar    *title);
GtkWidget   *thumbwin_create_new_tab            (ThumbWindow    *tw);
GtkWidget   *thumbwin_detach_tab                (ThumbWindow    *tw_dest,
						 ThumbWindow    *tw_src,
						 ThumbView      *tv);
void         thumbwin_close_tab                 (ThumbWindow    *tw,
						 gint            page);
void         thumbwin_reload_thumbnail          (ThumbWindow    *tw,
						 ThumbLoadType   type);
ThumbWindow *thumbwin_open_window               ();
void         thumbwin_location_entry_set_text   (ThumbWindow    *tw,
						 const gchar    *location);
void         thumbwin_store_win_state_to_config (ThumbWindow *tw);

/* FIXMEEEEEEEEEEEEEEEEEE!! (TOT */
void         thumbwin_notebook_drag_src_unset   (ThumbWindow *tw);
void         thumbwin_notebook_drag_src_reset   (ThumbWindow *tw);
/* END FIXMEEEEEEEEEEEEEEEEEE!! (TOT */

#endif /* __THUMBNAIL_WINDOW_H__ */
