/*
** THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
** PURSUANT TO THE 3DFX GLIDE GENERAL PUBLIC LICENSE. THERE IS NO RIGHT
** TO USE THE GLIDE TRADEMARK WITHOUT PRIOR WRITTEN PERMISSION OF 3DFX
** INTERACTIVE, INC. A COPY OF THIS LICENSE MAY BE OBTAINED FROM THE 
** DISTRIBUTOR OR BY CONTACTING 3DFX INTERACTIVE INC(info@3dfx.com). 
** THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
** EXPRESSED OR IMPLIED. SEE THE 3DFX GLIDE GENERAL PUBLIC LICENSE FOR A
** FULL TEXT OF THE NON-WARRANTY PROVISIONS.  
** 
** USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
** RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
** AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
** SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
** THE UNITED STATES.  
** 
** COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS RESERVED
**
** File name:   modetabl.h
**
** Description: Mode table that contains modes and related register values.
**
** $Revision: 1.1.1.1 $
** $Date: 1999/11/24 21:44:53 $
**
** $History: modetabl.h $
** 
** *****************  Version 1  *****************
** User: Sapphire     Date: 3/16/99    Time: 7:28p
** Created in $/Releases/Voodoo3/V3_OEM_100/3dfx/devel/H3/cinit
** 
** *****************  Version 25  *****************
** User: Stb_srogers  Date: 3/02/99    Time: 4:04p
** Updated in $/devel/h3/Win95/dx/minivdd
** Adding the 960x720 & 1280x960 modes
** 
** *****************  Version 24  *****************
** User: Stb_srogers  Date: 2/16/99    Time: 5:04p
** Updated in $/devel/h3/win95/dx/minivdd
** 
** *****************  Version 22  *****************
** User: Stb_srogers  Date: 2/11/99    Time: 6:59p
** Updated in $/devel/h3/win95/dx/minivdd
** 
** *****************  Version 21  *****************
** User: Stb_srogers  Date: 2/09/99    Time: 11:30a
** Updated in $/devel/h3/win95/dx/minivdd
** 
** *****************  Version 20  *****************
** User: Andrew       Date: 2/07/99    Time: 4:45p
** Updated in $/devel/h3/Win95/dx/minivdd
** Change the clocks as per Malcolm Gray suggestion and added new modes
** 1600x1024, 1920x1200, and 2048x1536.
** 
** *****************  Version 19  *****************
** User: Stb_srogers  Date: 1/29/99    Time: 8:08a
** Updated in $/devel/h3/win95/dx/minivdd
** 
** *****************  Version 18  *****************
** User: Andrew       Date: 1/12/99    Time: 12:40p
** Updated in $/devel/h3/Win95/dx/minivdd
** Removed my changes since complaint mode is 75 Hz
** 
** *****************  Version 16  *****************
** User: Michael      Date: 1/11/99    Time: 3:54p
** Updated in $/devel/h3/Win95/dx/minivdd
** Implement the 3Dfx/STB unified header.
** 
** *****************  Version 15  *****************
** User: Michael      Date: 12/31/98   Time: 9:55a
** Updated in $/devel/h3/Win95/dx/minivdd
** STB's customized refresh rates.  Customizations are surrounded by
** "#ifdef INCSTBCUST".
** 
** *****************  Version 14  *****************
** User: Andrew       Date: 8/31/98    Time: 11:26p
** Updated in $/devel/h3/Win95/dx/minivdd
** John's fixes for 800x600
** 
** *****************  Version 13  *****************
** User: Andrew       Date: 8/20/98    Time: 10:11p
** Updated in $/devel/h3/Win95/dx/minivdd
** Updated 320x240@60,72 400x300 @ 72 & 85, 1792x1392 changed from 72 to
** 75.
** 
** *****************  Version 12  *****************
** User: Andrew       Date: 7/27/98    Time: 11:12a
** Updated in $/devel/h3/Win95/dx/minivdd
** Added updates for 400x300 modes since SCANLINEDBL was not set in xls
** file
** 
** *****************  Version 11  *****************
** User: Andrew       Date: 7/21/98    Time: 2:42p
** Updated in $/devel/h3/Win95/dx/minivdd
** Modified to support the new final mode list -- add new refreshs
** 320x200, 320x240, 400x300, 512x384, and 1152x864.
** 
** *****************  Version 10  *****************
** User: Andrew       Date: 7/04/98    Time: 10:37a
** Updated in $/devel/h3/Win95/dx/minivdd
** Got modetabl.h the right way.....Differences  hsync skew on 1920x1440
** and clocks on low-rez modes
** 
** *****************  Version 9  *****************
** User: Andrew       Date: 6/29/98    Time: 10:58a
** Updated in $/devel/h3/Win95/dx/minivdd
** Changed Dot Clock on 1792x1344 and Refresh Rate from 70 to 72.  Changed
** CR04 on 1792x1344 @ 60 Hz
** 
** *****************  Version 8  *****************
** User: Andrew       Date: 6/24/98    Time: 9:32a
** Updated in $/devel/h3/Win95/dx/minivdd
** New mode additions for 1792x1344 and 1856x1392 plus 1152x864 @ 100
** 
** *****************  Version 7  *****************
** User: Andrew       Date: 5/19/98    Time: 6:12p
** Updated in $/devel/h3/Win95/dx/minivdd
** changed 1800 to 1808 and changed timing to 1808
** 
** *****************  Version 6  *****************
** User: Andrew       Date: 5/07/98    Time: 11:24a
** Updated in $/devel/h3/Win95/dx/minivdd
** Added modes 1792x1440 and 1920x1440.  1800x1440 was updated but still
** does not work
** 
** *****************  Version 5  *****************
** User: Andrew       Date: 4/22/98    Time: 2:58p
** Updated in $/devel/h3/Win95/dx/minivdd
** Changed clock at 1280x960 @ 75 hz and 1600x1200 @ 85 Hz and added
** broken 1800x1440
** 
** *****************  Version 4  *****************
** User: Ken          Date: 4/15/98    Time: 6:42p
** Updated in $/devel/h3/win95/dx/minivdd
** added unified header to all files, with revision, etc. info in it
**
*/


// Begin STB Changes
// STB-SR 12/23/98 changing modetable
// STB-SR 12/30/98 All but 720x350 and 720x400 work
// STB-SR 01/07/99 720x350 and 720x400 work.  I had assumed that SR1 (Sequencer
// Register 1), was always 0x21.  Bit 0 defines wether or not the character
// width is 8 or 9.  1->8 pixel wide char, 0->9 pixel char.  The actual change
// was made in minivdd\modetabl.h
// STB-SR 02/11/99 Adding STB & 3Dfx unified modes for Voodoo3
#ifdef H4
// If you need to make changes to the modetable, you must also edit
// dd16\h3.c and dd16\setmode.c
//              r[0]  r[1]  r[2]  r[3]  r[4]  r[5]  r[6]  r[7]  r[8]  r[9]  r[10] r[11] r[12] r[13] r[14] r[15] r[16] r[17] r[18] r[19] r[20]
// x    y  rr,    0h    1h    2h    3h    4h    5h    6h    7h    9h   10h    11h   12h   15h   16h   1ah   1bh  3c2   SR1  pllctrl0  dacmode
// x    y  rr, Htotl HDEnE HBlSt HBlEn HSySt HSyEn Vtotl Ovflw MxSLn VSySt  VSyEn VDEnE VBlSt VBlEn HExtn VExtn MiscO  SR1  pllctrl0  dacmode 
// New Standardized modetable for both 3Dfx and STB
{  320,  200,  70, 0x2d, 0x27, 0x27, 0x91, 0x29, 0x8f, 0xbf, 0x1f, 0xc0, 0x9c,
	0x2e, 0x8f, 0x97, 0xb8, 0x80, 0x00, 0x4f, 0x21, 0x73, 0xd1, 0x00},
{  320,  200,  85, 0x2f, 0x27, 0x27, 0x93, 0x2a, 0x8e, 0xbb, 0x1f, 0xc0, 0x90,
	0x23, 0x8f, 0x8f, 0xbc, 0x80, 0x00, 0x4f, 0x21, 0xd5, 0x77, 0x00},
{  320,  240,  60, 0x2d, 0x27, 0x27, 0x91, 0x29, 0x8f, 0x0b, 0x3e, 0xc0, 0xe9,
	0x2b, 0xdf, 0xdf, 0x0c, 0x80, 0x00, 0xcf, 0x21, 0x73, 0xd1, 0x00},
{  320,  240,  72, 0x2f, 0x27, 0x27, 0x93, 0x2a, 0x8c, 0x06, 0x3e, 0xc0, 0xe8,
	0x2b, 0xdf, 0xdf, 0x07, 0x80, 0x00, 0xcf, 0x21, 0xd5, 0x77, 0x00},
{  320,  240,  75, 0x30, 0x27, 0x27, 0x94, 0x29, 0x8d, 0xf2, 0x1f, 0xc0, 0xe0,
	0x23, 0xdf, 0xdf, 0xf3, 0x80, 0x00, 0xcf, 0x21, 0xca, 0xe5, 0x00},
{  320,  240,  85, 0x2f, 0x27, 0x27, 0x93, 0x2b, 0x8f, 0xfb, 0x1f, 0xc0, 0xe0,
	0x23, 0xdf, 0xdf, 0xfc, 0x80, 0x00, 0xcf, 0x21, 0x86, 0xae, 0x00},
{  400,  300,  60, 0x3d, 0x31, 0x31, 0x81, 0x35, 0x1d, 0x72, 0xf0, 0xe0, 0x58,
	0x2c, 0x57, 0x57, 0x73, 0xa0, 0x00, 0x0f, 0x21, 0x3f, 0xbc, 0x00},
{  400,  300,  72, 0x3c, 0x31, 0x31, 0x80, 0x36, 0x1d, 0x98, 0xf0, 0xe0, 0x7c,
	0x22, 0x57, 0x57, 0x99, 0xa0, 0x00, 0x0f, 0x21, 0xfd, 0xe1, 0x00},
{  400,  300,  75, 0x3d, 0x31, 0x31, 0x81, 0x33, 0x18, 0x6f, 0xf0, 0xe0, 0x58,
	0x2b, 0x57, 0x57, 0x70, 0xa0, 0x00, 0x0f, 0x21, 0x8a, 0xf7, 0x00},
{  400,  300,  85, 0x3d, 0x31, 0x31, 0x81, 0x34, 0x18, 0x75, 0xf0, 0xe0, 0x58,
	0x2b, 0x57, 0x57, 0x76, 0xa0, 0x00, 0x0f, 0x21, 0x2f, 0xcc, 0x00},
{  512,  384,  60, 0x4f, 0x3f, 0x3f, 0x93, 0x42, 0x0a, 0x24, 0xf5, 0xe0, 0x02,
	0x28, 0xff, 0xff, 0x25, 0x20, 0x00, 0xcf, 0x21, 0xc1, 0xe1, 0x00},
{  512,  384,  70, 0x4e, 0x3f, 0x3f, 0x92, 0x42, 0x0a, 0x24, 0xf5, 0xe0, 0x02,
	0x28, 0xff, 0xff, 0x25, 0x20, 0x00, 0xcf, 0x21, 0x2b, 0xf9, 0x00},
{  512,  384,  75, 0x4d, 0x3f, 0x3f, 0x91, 0x41, 0x07, 0x1e, 0xf5, 0xe0, 0x00,
	0x23, 0xff, 0xff, 0x1f, 0x20, 0x00, 0xcf, 0x21, 0x26, 0x77, 0x00},
{  512,  384,  85, 0x51, 0x3f, 0x3f, 0x95, 0x43, 0x09, 0x26, 0xf5, 0xe0, 0x00,
	0x23, 0xff, 0xff, 0x27, 0x20, 0x00, 0xcf, 0x21, 0x21, 0x40, 0x00},
{  640,  400,  70, 0x5f, 0x4f, 0x50, 0x82, 0x52, 0x9e, 0xbf, 0x1f, 0x40, 0x9c,
	0x2e, 0x8f, 0x97, 0xb8, 0x20, 0x00, 0x4f, 0x21, 0x72, 0xd1, 0x00},
{  640,  400,  85, 0x63, 0x4f, 0x4f, 0x87, 0x54, 0x9c, 0xbb, 0x1f, 0x40, 0x90,
	0x23, 0x8f, 0x8f, 0xbc, 0x20, 0x00, 0x4f, 0x21, 0xd4, 0x77, 0x00},
{  640,  480,  60, 0x5f, 0x4f, 0x50, 0x82, 0x52, 0x9e, 0x0b, 0x3e, 0x40, 0xe9,
	0x2b, 0xdf, 0xe7, 0x04, 0x20, 0x00, 0xcf, 0x21, 0x72, 0xd1, 0x00},
{  640,  480,  72, 0x63, 0x4f, 0x50, 0x86, 0x53, 0x98, 0x06, 0x3e, 0x40, 0xe8,
	0x2b, 0xdf, 0xe7, 0xff, 0x20, 0x00, 0xcf, 0x21, 0xd4, 0x77, 0x00},
{  640,  480,  75, 0x64, 0x4f, 0x4f, 0x88, 0x52, 0x9a, 0xf2, 0x1f, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0xf3, 0x20, 0x00, 0xcf, 0x21, 0xd4, 0x77, 0x00},
{  640,  480,  85, 0x63, 0x4f, 0x4f, 0x87, 0x57, 0x9e, 0xfb, 0x1f, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0xfc, 0x20, 0x00, 0xcf, 0x21, 0x85, 0xae, 0x00},
{  640,  480, 100, 0x65, 0x4f, 0x4f, 0x89, 0x55, 0x9d, 0xfb, 0x1f, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0xfc, 0x20, 0x00, 0x4f, 0x21, 0x1f, 0xd7, 0x00},
{  640,  480, 120, 0x65, 0x4f, 0x4f, 0x89, 0x55, 0x9d, 0x01, 0x3e, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0x02, 0x20, 0x00, 0x4f, 0x21, 0x17, 0xcb, 0x00},
{  640,  480, 140, 0x67, 0x4f, 0x4f, 0x8b, 0x55, 0x9e, 0x07, 0x3e, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0x08, 0x20, 0x00, 0x4f, 0x21, 0x22, 0xae, 0x00},
{  640,  480, 160, 0x67, 0x4f, 0x4f, 0x8b, 0x55, 0x9e, 0x0d, 0x3e, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0x0e, 0x20, 0x00, 0x4f, 0x21, 0x24, 0x36, 0x00},
{  720,  480,  60, 0x6b, 0x59, 0x59, 0x8f, 0x5c, 0x8b, 0x0b, 0x3e, 0x40, 0xe9,
	0x2b, 0xdf, 0xdf, 0x0c, 0xa0, 0x00, 0xcf, 0x21, 0xfc, 0x7e, 0x00},
{  720,  480,  72, 0x6e, 0x59, 0x59, 0x92, 0x5c, 0x8d, 0x06, 0x3e, 0x40, 0xe8,
	0x2b, 0xdf, 0xdf, 0x07, 0xa0, 0x00, 0xcf, 0x21, 0xc9, 0xfb, 0x00},
{  720,  480,  85, 0x70, 0x59, 0x59, 0x94, 0x62, 0x8a, 0xfb, 0x1f, 0x40, 0xe0,
	0x23, 0xdf, 0xdf, 0xfc, 0xa0, 0x00, 0xcf, 0x21, 0x1b, 0xb3, 0x00},
{  720,  576,  72, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x8a, 0x80, 0xf0, 0x60, 0x41,
	0x25, 0x3f, 0x3f, 0x81, 0xa0, 0x00, 0x0f, 0x21, 0x2a, 0x8f, 0x00},
{  720,  576, 100, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x8a, 0x80, 0xf0, 0x60, 0x41,
	0x25, 0x3f, 0x3f, 0x81, 0xa0, 0x00, 0x0f, 0x21, 0x17, 0xe9, 0x00},
{  800,  600,  60, 0x7f, 0x63, 0x63, 0x83, 0x69, 0x19, 0x72, 0xf0, 0x60, 0x58,
	0x2c, 0x57, 0x57, 0x73, 0x80, 0x00, 0x0f, 0x21, 0x26, 0x79, 0x00},
{  800,  600,  72, 0x7d, 0x63, 0x63, 0x81, 0x6b, 0x1a, 0x98, 0xf0, 0x60, 0x7c,
	0x22, 0x57, 0x57, 0x99, 0x80, 0x00, 0x0f, 0x21, 0x1f, 0xf9, 0x00},
{  800,  600,  75, 0x7f, 0x63, 0x63, 0x83, 0x66, 0x10, 0x6f, 0xf0, 0x60, 0x58,
	0x2b, 0x57, 0x57, 0x70, 0x80, 0x00, 0x0f, 0x21, 0x1f, 0xf7, 0x00},
{  800,  600,  85, 0x7e, 0x63, 0x63, 0x82, 0x68, 0x10, 0x75, 0xf0, 0x60, 0x58,
	0x2b, 0x57, 0x57, 0x76, 0x80, 0x00, 0x0f, 0x21, 0x17, 0xda, 0x00},
{  800,  600, 100, 0x81, 0x63, 0x63, 0x85, 0x6a, 0x15, 0x7a, 0xf0, 0x60, 0x58,
	0x2b, 0x57, 0x57, 0x7b, 0x80, 0x00, 0x4f, 0x21, 0x2a, 0xe3, 0x00},
{  800,  600, 120, 0x83, 0x63, 0x63, 0x87, 0x6b, 0x16, 0x81, 0xf0, 0x60, 0x58,
	0x2b, 0x57, 0x57, 0x82, 0x80, 0x00, 0x4f, 0x21, 0x1e, 0xd1, 0x00},
{  800,  600, 140, 0x83, 0x63, 0x63, 0x87, 0x6b, 0x16, 0x89, 0xf0, 0x60, 0x58,
	0x2b, 0x57, 0x57, 0x8a, 0x80, 0x00, 0x4f, 0x21, 0x15, 0x5f, 0x00},
{  800,  600, 160, 0x85, 0x63, 0x63, 0x89, 0x6c, 0x17, 0x91, 0xf0, 0x60, 0x58,
	0x2b, 0x57, 0x57, 0x92, 0x80, 0x00, 0x4f, 0x21, 0x29, 0xc1, 0x00},
{  960,  720,  60, 0x97, 0x77, 0x77, 0x9b, 0x7e, 0x0a, 0xe8, 0xf0, 0x60, 0xd0,
	0x23, 0xcf, 0xcf, 0xe9, 0x00, 0x00, 0x4f, 0x21, 0x22, 0x9a, 0x00},
{  960,  720,  75, 0x9b, 0x77, 0x77, 0x9f, 0x7f, 0x0c, 0xee, 0xf0, 0x60, 0xd0,
	0x23, 0xcf, 0xcf, 0xef, 0x00, 0x00, 0x4f, 0x21, 0x29, 0x77, 0x00},
{  960,  720,  85, 0x9b, 0x77, 0x77, 0x9f, 0x7f, 0x0c, 0xf2, 0xf0, 0x60, 0xd0,
	0x23, 0xcf, 0xcf, 0xf3, 0x00, 0x00, 0x4f, 0x21, 0x21, 0x71, 0x00},
{ 1024,  768,  60, 0xa3, 0x7f, 0x7f, 0x87, 0x83, 0x94, 0x24, 0xf5, 0x60, 0x02,
	0x28, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x29, 0x6b, 0x00},
{ 1024,  768,  70, 0xa1, 0x7f, 0x7f, 0x85, 0x83, 0x94, 0x24, 0xf5, 0x60, 0x02,
	0x28, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x2a, 0xf9, 0x00},
{ 1024,  768,  75, 0x9f, 0x7f, 0x7f, 0x83, 0x82, 0x8e, 0x1e, 0xf5, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x0f, 0x21, 0x25, 0x77, 0x00},
{ 1024,  768,  85, 0xa7, 0x7f, 0x7f, 0x8b, 0x86, 0x92, 0x26, 0xf5, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x20, 0x40, 0x00},
{ 1024,  768, 100, 0xa9, 0x7f, 0x7f, 0x8d, 0x89, 0x97, 0x2c, 0xf5, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x2d, 0x00, 0x00, 0x4f, 0x21, 0x28, 0x5d, 0x00},
{ 1024,  768, 120, 0xab, 0x7f, 0x7f, 0x8f, 0x8a, 0x98, 0x35, 0xf5, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x36, 0x00, 0x00, 0x4f, 0x21, 0x15, 0x86, 0x00},
{ 1152,  864,  60, 0xb3, 0x8f, 0x8f, 0x97, 0x94, 0x80, 0x87, 0xff, 0x60, 0x60,
	0x23, 0x5f, 0x5f, 0x88, 0x80, 0x00, 0x0f, 0x21, 0x25, 0x79, 0x00},
{ 1152,  864,  70, 0xb4, 0x8f, 0x8f, 0x98, 0x94, 0x80, 0x8e, 0xff, 0x60, 0x60,
	0x23, 0x5f, 0x5f, 0x8f, 0x80, 0x00, 0x0f, 0x21, 0x20, 0x40, 0x00},
{ 1152,  864,  75, 0xc3, 0x8f, 0x8f, 0x87, 0x98, 0x08, 0x82, 0xff, 0x60, 0x60,
	0x23, 0x5f, 0x5f, 0x83, 0xa0, 0x00, 0x0f, 0x21, 0x29, 0xb3, 0x00},
{ 1152,  864,  85, 0xbf, 0x8f, 0x8f, 0x83, 0x98, 0x08, 0x8d, 0xff, 0x60, 0x60,
	0x23, 0x5f, 0x5f, 0x8e, 0xa0, 0x00, 0x0f, 0x21, 0x28, 0x64, 0x00},
{ 1152,  864, 100, 0xbf, 0x8f, 0x8f, 0x83, 0x9a, 0x0a, 0x91, 0xff, 0x60, 0x60,
	0x23, 0x5f, 0x5f, 0x92, 0xa0, 0x00, 0x4f, 0x21, 0x24, 0x6c, 0x00},
{ 1152,  864, 120, 0xc1, 0x8f, 0x8f, 0x85, 0x9b, 0x0b, 0x9c, 0xff, 0x60, 0x60,
	0x23, 0x5f, 0x5f, 0x9d, 0xa0, 0x00, 0x4f, 0x21, 0x21, 0xf4, 0x00},
{ 1280,  960,  60, 0xdc, 0x9f, 0x9f, 0x80, 0xac, 0x9a, 0xe6, 0xff, 0x60, 0xc0,
	0x23, 0xbf, 0xbf, 0xe7, 0xa0, 0x00, 0x0f, 0x21, 0x29, 0xb3, 0x00},
{ 1280,  960,  75, 0xd3, 0x9f, 0x9f, 0x97, 0xab, 0x1c, 0xe8, 0xff, 0x60, 0xc0,
	0x23, 0xbf, 0xbf, 0xe9, 0xa0, 0x00, 0x4f, 0x21, 0x15, 0x7d, 0x00},
{ 1280,  960,  85, 0xd3, 0x9f, 0x9f, 0x97, 0xa8, 0x1c, 0xf1, 0xff, 0x60, 0xc0,
	0x23, 0xbf, 0xbf, 0xf2, 0xa0, 0x00, 0x0f, 0x21, 0x18, 0x51, 0x00},
{ 1280, 1024,  60, 0xce, 0x9f, 0x9f, 0x92, 0xa6, 0x14, 0x28, 0x5a, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x29, 0xa0, 0x41, 0x0f, 0x21, 0x29, 0xb3, 0x00},
{ 1280, 1024,  75, 0xce, 0x9f, 0x9f, 0x92, 0xa2, 0x14, 0x28, 0x5a, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x29, 0xa0, 0x41, 0x0f, 0x21, 0x14, 0x40, 0x00},
{ 1280, 1024,  85, 0xd3, 0x9f, 0x9f, 0x97, 0xa8, 0x1c, 0x2e, 0x5a, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x2f, 0xa0, 0x41, 0x0f, 0x21, 0x24, 0x77, 0x00},
{ 1280, 1024, 100, 0x69, 0x4f, 0x4f, 0x8d, 0x56, 0x9f, 0x3b, 0x5a, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x3c, 0x20, 0x41, 0x4f, 0x21, 0x28, 0x9e, 0x01},
{ 1600, 1024,  60, 0x07, 0xc7, 0xc7, 0x8b, 0xd5, 0x0a, 0x22, 0x5a, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x23, 0x81, 0x41, 0x4f, 0x21, 0x29, 0xe3, 0x00},
{ 1600, 1024,  76, 0x01, 0xc7, 0xc7, 0x85, 0xcc, 0x00, 0x2c, 0x5a, 0x60, 0x02,
	0x25, 0xff, 0xff, 0x2d, 0x81, 0x41, 0xcf, 0x21, 0x21, 0xec, 0x00},
{ 1600, 1024,  85, 0x83, 0x63, 0x63, 0x87, 0x6b, 0x16, 0x31, 0x5a, 0x60, 0x00,
	0x23, 0xff, 0xff, 0x32, 0x80, 0x41, 0x4f, 0x21, 0x1d, 0xf8, 0x01},
{ 1600, 1200,  60, 0x09, 0xc7, 0xc7, 0x8d, 0xd0, 0x08, 0xe0, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xe1, 0x81, 0x55, 0x0f, 0x21, 0x19, 0xb3, 0x00},
{ 1600, 1200,  65, 0x09, 0xc7, 0xc7, 0x8d, 0xd0, 0x08, 0xe0, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xe1, 0x81, 0x55, 0x0f, 0x21, 0x28, 0x91, 0x00},
{ 1600, 1200,  70, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x20, 0x82, 0x01},
{ 1600, 1200,  75, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x14, 0x61, 0x01},
{ 1600, 1200,  80, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x11, 0xb3, 0x01},
{ 1600, 1200,  85, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x0c, 0x4e, 0x01},
{ 1600, 1200, 100, 0x85, 0x63, 0x63, 0x89, 0x6c, 0x17, 0xf5, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xf6, 0x80, 0x55, 0x4f, 0x21, 0x0c, 0x60, 0x01},
{ 1792, 1344,  60, 0x94, 0x6f, 0x6f, 0x98, 0x78, 0x05, 0x70, 0x1f, 0x40, 0x40,
	0x23, 0x3f, 0x3f, 0x71, 0x00, 0x55, 0x4f, 0x21, 0x0d, 0x8d, 0x01},
{ 1792, 1344,  75, 0x95, 0x6f, 0x6f, 0x99, 0x76, 0x04, 0x87, 0x1f, 0x40, 0x40,
	0x23, 0x3f, 0x3f, 0x88, 0x00, 0x55, 0x4f, 0x21, 0x15, 0xfd, 0x01},
{ 1856, 1392,  60, 0x99, 0x73, 0x73, 0x9d, 0x7a, 0x08, 0x9d, 0x1f, 0x40, 0x70,
	0x23, 0x6f, 0x6f, 0x9e, 0x00, 0x55, 0x4f, 0x21, 0x11, 0xb5, 0x01},
{ 1856, 1392,  75, 0x9b, 0x73, 0x73, 0x9f, 0x7c, 0x0a, 0xda, 0x1f, 0x40, 0x70,
	0x23, 0x6f, 0x6f, 0xdb, 0x00, 0x55, 0x4f, 0x21, 0x09, 0x9f, 0x01},
{ 1920, 1080,  60, 0x23, 0xef, 0xef, 0x87, 0xf4, 0x86, 0x63, 0x10, 0x40, 0x3a,
	0x2d, 0x37, 0x37, 0x64, 0x01, 0x55, 0xcf, 0x21, 0x28, 0x84, 0x00},
{ 1920, 1080,  72, 0x9b, 0x77, 0x77, 0x9f, 0x7b, 0x09, 0x92, 0x10, 0x40, 0x3a,
	0x2d, 0x37, 0x37, 0x93, 0x00, 0x55, 0xcf, 0x21, 0x11, 0xb3, 0x01},
{ 1920, 1080,  75, 0x9e, 0x77, 0x77, 0x82, 0x81, 0x8e, 0x66, 0x10, 0x40, 0x38,
	0x2b, 0x37, 0x37, 0x67, 0x00, 0x55, 0x4f, 0x21, 0x11, 0xb7, 0x01},
{ 1920, 1080,  85, 0x9f, 0x77, 0x77, 0x83, 0x81, 0x8e, 0x6c, 0x10, 0x40, 0x38,
	0x2b, 0x37, 0x37, 0x6d, 0x00, 0x55, 0x4f, 0x21, 0x11, 0xd2, 0x01},
{ 1920, 1200,  60, 0x9d, 0x77, 0x77, 0x81, 0x80, 0x8d, 0xd8, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xd9, 0x00, 0x55, 0x4f, 0x21, 0x15, 0xbb, 0x01},
{ 1920, 1200,  76, 0x9d, 0x77, 0x77, 0x81, 0x7c, 0x8c, 0xe0, 0x10, 0x40, 0xb2,
	0x25, 0xaf, 0xaf, 0xe1, 0x00, 0x55, 0xcf, 0x21, 0x14, 0x76, 0x01},
{ 1920, 1200,  85, 0xa0, 0x77, 0x77, 0x84, 0x82, 0x8f, 0xea, 0x10, 0x40, 0xb0,
	0x23, 0xaf, 0xaf, 0xeb, 0x00, 0x55, 0x4f, 0x21, 0x08, 0x4d, 0x01},
{ 1920, 1440,  60, 0x9e, 0x77, 0x77, 0x82, 0x80, 0x8d, 0xda, 0x1f, 0x40, 0xa0,
	0x23, 0x9f, 0x9f, 0xdb, 0x00, 0x55, 0x4f, 0x21, 0x10, 0x60, 0x01},
{ 1920, 1440,  75, 0xa0, 0x77, 0x77, 0x84, 0x81, 0x8f, 0xda, 0x1f, 0x40, 0xa0,
	0x23, 0x9f, 0x9f, 0xdb, 0x00, 0x55, 0x4f, 0x21, 0x08, 0x51, 0x01},
{ 2048, 1536,  60, 0x98, 0x7f, 0x7f, 0x9c, 0x83, 0x11, 0x3b, 0xba, 0x40, 0x00,
	0x23, 0xff, 0xff, 0x3c, 0x00, 0x55, 0x0f, 0x21, 0x11, 0xc7, 0x01},
{ 2048, 1536,  75, 0xa1, 0x7f, 0x7f, 0x85, 0x84, 0x92, 0x44, 0xba, 0x40, 0x00,
	0x23, 0xff, 0xff, 0x45, 0x00, 0x55, 0x0f, 0x21, 0x10, 0x84, 0x01},
{ 2048, 1536,  85, 0x9c, 0x7f, 0x7f, 0x80, 0x80, 0x8c, 0x30, 0x3e, 0x40, 0xff,
	0x22, 0xff, 0xff, 0x31, 0x00, 0x55, 0x0f, 0x21, 0x10, 0x8f, 0x01},
#else // #ifdef H4
// STB End Changes


{320, 200, 70, 0x2f, 0x27, 0x27, 0x93, 0x2a, 0x8e, 0xbb, 0x1f, 0x40, 0x91,
	0x24, 0x8f, 0x8f, 0xbc, 0x80, 0x00, 0x4f, 0x21, 0xee, 0xdb, 0x00},
{320, 200, 85, 0x2f, 0x27, 0x27, 0x93, 0x2a, 0x8e, 0xbb, 0x1f, 0x40, 0x91,
	0x24, 0x8f, 0x8f, 0xbc, 0x80, 0x00, 0x4f, 0x21, 0x37, 0x82, 0x00},
{320, 240, 60, 0x2d, 0x27, 0x27, 0x8f, 0x29, 0x8e, 0x0b, 0x3e, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xfc, 0x80, 0x00, 0xcf, 0x21, 0xea, 0xd1, 0x00},
{320, 240, 72, 0x2f, 0x27, 0x27, 0x93, 0x2a, 0x8e, 0x06, 0x3e, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xfc, 0x80, 0x00, 0xcf, 0x21, 0x37, 0x82, 0x00},
{320, 240, 85, 0x2f, 0x27, 0x27, 0x93, 0x2a, 0x8e, 0xfb, 0x1f, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xfc, 0x80, 0x00, 0xcf, 0x21, 0x3f, 0xa9, 0x00},
{400, 300, 60, 0x3d, 0x31, 0x31, 0x81, 0x34, 0x1c, 0x72, 0xf0, 0x60, 0x59,
	0x2d, 0x57, 0x57, 0x73, 0xa0, 0x00, 0x0f, 0x21, 0xf4, 0x56, 0x00},
{400, 300, 72, 0x3c, 0x31, 0x31, 0x80, 0x34, 0x1b, 0x98, 0xf0, 0x60, 0x7d,
	0x23, 0x57, 0x57, 0x99, 0xa0, 0x00, 0x0f, 0x21, 0xf4, 0x6c, 0x00},
{400, 300, 85, 0x3d, 0x31, 0x31, 0x80, 0x33, 0x1b, 0x75, 0xf0, 0x60, 0x59,
	0x2c, 0x57, 0x57, 0x76, 0xa0, 0x00, 0x0f, 0x21, 0xb8, 0x5d, 0x00},
{512, 384, 60, 0x4f, 0x3f, 0x3f, 0x93, 0x41, 0x0a, 0x24, 0xf5, 0x60, 0x04,
	0x2a, 0xff, 0xff, 0x25, 0x20, 0x00, 0xcf, 0x21, 0x5e, 0xe1, 0x00},
{512, 384, 72, 0x4e, 0x3f, 0x3f, 0x92, 0x41, 0x0a, 0x24, 0xf5, 0x60, 0x03,
	0x29, 0xff, 0xff, 0x25, 0x20, 0x00, 0xcf, 0x21, 0xbc, 0x82, 0x00},
{512, 384, 75, 0x4d, 0x3f, 0x3f, 0x91, 0x41, 0x07, 0x1e, 0xf5, 0x60, 0x01,
	0x24, 0xff, 0xff, 0x1f, 0x20, 0x00, 0x0f, 0x21, 0x2a, 0x82, 0x00},
{512, 384, 85, 0x51, 0x3f, 0x3f, 0x95, 0x43, 0x09, 0x26, 0xf5, 0x60, 0x01,
	0x24, 0xff, 0xff, 0x27, 0x20, 0x00, 0x0f, 0x21, 0x36, 0xc4, 0x00},
{640, 350, 85, 0x63, 0x4f, 0x4f, 0x87, 0x54, 0x9c, 0xbb, 0x1f, 0x40, 0x7e,
	0x21, 0x5d, 0x5d, 0xbc, 0x20, 0x00, 0x8f, 0x21, 0x36, 0x82, 0x00},
{640, 400, 70, 0x63, 0x4f, 0x4f, 0x87, 0x54, 0x9c, 0xbb, 0x1f, 0x40, 0x91,
	0x24, 0x8f, 0x8f, 0xbc, 0x20, 0x00, 0x4f, 0x21, 0xed, 0xdb, 0x00},
{640, 400, 85, 0x63, 0x4f, 0x4f, 0x87, 0x54, 0x9c, 0xbb, 0x1f, 0x40, 0x91,
	0x24, 0x8f, 0x8f, 0xbc, 0x20, 0x00, 0x4f, 0x21, 0x36, 0x82, 0x00},
{640, 480, 60, 0x5f, 0x4f, 0x4f, 0x83, 0x52, 0x9e, 0x0b, 0x3e, 0x40, 0xea,
	0x2c, 0xdf, 0xdf, 0x0c, 0x20, 0x00, 0xcf, 0x21, 0x7d, 0x72, 0x00},
{640, 480, 72, 0x63, 0x4f, 0x4f, 0x87, 0x56, 0x9b, 0x06, 0x3e, 0x40, 0xe9,
	0x2c, 0xdf, 0xdf, 0x07, 0x20, 0x00, 0xcf, 0x21, 0x36, 0x82, 0x00},
{640, 480, 75, 0x64, 0x4f, 0x4f, 0x88, 0x51, 0x99, 0xf2, 0x1f, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xf3, 0x20, 0x00, 0xcf, 0x21, 0x36, 0x82, 0x00},
{640, 480, 85, 0x63, 0x4f, 0x4f, 0x87, 0x56, 0x9e, 0xfb, 0x1f, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xfc, 0x20, 0x00, 0xcf, 0x21, 0x3e, 0xa9, 0x00},
{640, 480, 100, 0x63, 0x4f, 0x4f, 0x87, 0x56, 0x9e, 0xfb, 0x1f, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xfc, 0x20, 0x00, 0xcf, 0x21, 0x58, 0x45, 0x00},
{640, 480, 120, 0x63, 0x4f, 0x4f, 0x87, 0x56, 0x9e, 0xfb, 0x1f, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0xfc, 0x20, 0x00, 0xcf, 0x21, 0x48, 0x45, 0x00},
{720, 400, 72, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x87, 0xbc, 0x1f, 0x40, 0x91,
	0x24, 0x8f, 0x8f, 0xbd, 0xa0, 0x00, 0x4f, 0x21, 0x20, 0x13, 0x00},
{720, 400, 85, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x87, 0xbc, 0x1f, 0x40, 0x91,
	0x24, 0x8f, 0x8f, 0xbd, 0xa0, 0x00, 0x4f, 0x21, 0xb8, 0x75, 0x00},
{720, 480, 60, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x87, 0x15, 0x3e, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0x16, 0xa0, 0x00, 0x4f, 0x21, 0xc4, 0x69, 0x00},
{720, 480, 72, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x87, 0x15, 0x3e, 0x40, 0xe1,
	0x24, 0xdf, 0xdf, 0x16, 0xa0, 0x00, 0x4f, 0x21, 0xd8, 0x8b, 0x00},
{720, 576, 72, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x87, 0x80, 0xf0, 0x60, 0x41,
	0x24, 0x3f, 0x3f, 0x81, 0xa0, 0x00, 0x4f, 0x21, 0xb0, 0x89, 0x00},
{720, 576, 100, 0x70, 0x59, 0x59, 0x94, 0x5e, 0x87, 0x80, 0xf0, 0x60, 0x41,
	0x24, 0x3f, 0x3f, 0x81, 0xa0, 0x00, 0x4f, 0x21, 0xec, 0xfe, 0x00},
{800, 600, 56, 0x7b, 0x63, 0x63, 0x9f, 0x69, 0x99, 0x6f, 0xf0, 0x60, 0x59,
	0x2b, 0x57, 0x57, 0x70, 0xa0, 0x00, 0x0f, 0x21, 0x3e, 0xa9, 0x00},
{800, 600, 60, 0x7b, 0x63, 0x63, 0x9f, 0x6a, 0x94, 0x6c, 0xf0, 0x60, 0x59,
	0x2c, 0x57, 0x57, 0x6d, 0xa0, 0x00, 0x0f, 0x21, 0x06, 0x1e, 0x00},
{800, 600, 72, 0x7d, 0x63, 0x63, 0x81, 0x68, 0x17, 0x98, 0xf0, 0x60, 0x7d,
	0x23, 0x57, 0x57, 0x99, 0x80, 0x00, 0x0f, 0x21, 0x06, 0x28, 0x00},
{800, 600, 75, 0x7f, 0x63, 0x63, 0x83, 0x65, 0x0f, 0x6f, 0xf0, 0x60, 0x59,
	0x2c, 0x57, 0x57, 0x70, 0x80, 0x00, 0x0f, 0x21, 0x55, 0x9d, 0x00},
{800, 600, 85, 0x7e, 0x63, 0x63, 0x82, 0x67, 0x0f, 0x75, 0xf0, 0x60, 0x59,
	0x2c, 0x57, 0x57, 0x76, 0x80, 0x00, 0x0f, 0x21, 0x31, 0x6c, 0x00},
{800, 600, 100, 0x7e, 0x63, 0x63, 0x82, 0x66, 0x0e, 0x75, 0xf0, 0x60, 0x59,
//	0x2c, 0x57, 0x57, 0x76, 0x80, 0x00, 0x0f, 0x21, 0x8c, 0xa9, 0x00},
	0x2c, 0x57, 0x57, 0x76, 0x80, 0x00, 0x0f, 0x21, 0x0b, 0x92, 0x00},
{800, 600, 120, 0x7e, 0x63, 0x63, 0x82, 0x66, 0x0e, 0x75, 0xf0, 0x60, 0x59,
	0x2c, 0x57, 0x57, 0x76, 0x80, 0x00, 0x0f, 0x21, 0x24, 0x3b, 0x00},
{1152, 864, 60, 0xb4, 0x8f, 0x8f, 0x98, 0x94, 0x80, 0x8e, 0xff, 0x60, 0x61,
//	0x24, 0x5f, 0x5f, 0x8f, 0x80, 0x00, 0x0f, 0x21, 0x84, 0xc4, 0x00},
	0x24, 0x5f, 0x5f, 0x8f, 0x80, 0x00, 0x0f, 0x21, 0x0b, 0xb3, 0x00},
{1152, 864, 75, 0xc3, 0x8f, 0x8f, 0x87, 0x98, 0x08, 0x82, 0xff, 0x60, 0x61,
//	0x24, 0x5f, 0x5f, 0x83, 0xa0, 0x00, 0x0f, 0x21, 0x50, 0xa4, 0x00},
	0x24, 0x5f, 0x5f, 0x83, 0xa0, 0x00, 0x0f, 0x21, 0x12, 0xb3, 0x00},
{1152, 864, 85, 0xc0, 0x8f, 0x8f, 0x84, 0x98, 0x08, 0x89, 0xff, 0x60, 0x61,
//	0x24, 0x5f, 0x5f, 0x8a, 0xa0, 0x00, 0x0f, 0x21, 0x6c, 0xf4, 0x00},
	0x24, 0x5f, 0x5f, 0x8a, 0xa0, 0x00, 0x0f, 0x21, 0x16, 0xeb, 0x00},
{1152, 864, 100, 0x5f, 0x47, 0x47, 0x83, 0x4c, 0x93, 0x82, 0xff, 0x60, 0x61,
//	0x24, 0x5f, 0x5f, 0x83, 0x20, 0x00, 0x0f, 0x21, 0x40, 0xb3, 0x01},
	0x24, 0x5f, 0x5f, 0x83, 0x20, 0x00, 0x0f, 0x21, 0x0a, 0x9f, 0x01},
{1024, 768, 60, 0xa3, 0x7f, 0x7f, 0x87, 0x83, 0x94, 0x24, 0xf5, 0x60, 0x04,
//	0x2a, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x5d, 0xe1, 0x00},
	0x2a, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x07, 0x6b, 0x00},
{1024, 768, 70, 0xa1, 0x7f, 0x7f, 0x85, 0x83, 0x94, 0x24, 0xf5, 0x60, 0x03,
//	0x29, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x4d, 0xda, 0x00},
	0x29, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x13, 0xf9, 0x00},
{1024, 768, 72, 0xa1, 0x7f, 0x7f, 0x85, 0x83, 0x94, 0x24, 0xf5, 0x60, 0x03,
	0x29, 0xff, 0xff, 0x25, 0x00, 0x00, 0xcf, 0x21, 0x74, 0xa5, 0x00},
{1024, 768, 75, 0x9f, 0x7f, 0x7f, 0x83, 0x82, 0x8e, 0x1e, 0xf5, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x0f, 0x21, 0x29, 0x82, 0x00},
	0x24, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x0f, 0x21, 0x12, 0x82, 0x00},
{1024, 768, 85, 0xa7, 0x7f, 0x7f, 0x8b, 0x86, 0x92, 0x26, 0xf5, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x35, 0xc4, 0x00},
	0x24, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x0e, 0x82, 0x00},
{1024, 768, 100, 0xa7, 0x7f, 0x7f, 0x8b, 0x86, 0x92, 0x26, 0xf5, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x3c, 0x82, 0x00},
	0x24, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x06, 0x5b, 0x00},
{1024, 768, 120, 0xa7, 0x7f, 0x7f, 0x8b, 0x86, 0x92, 0x26, 0xf5, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x50, 0xcb, 0x00},
	0x24, 0xff, 0xff, 0x27, 0x00, 0x00, 0x0f, 0x21, 0x0a, 0x93, 0x00},
{1280, 960, 60, 0xdc, 0x9f, 0x9f, 0x80, 0xac, 0x9a, 0xe6, 0xff, 0x60, 0xc1,
	0x24, 0xbf, 0xbf, 0xe7, 0xa0, 0x00, 0x0f, 0x21, 0x50, 0xa4, 0x00},
{1280, 960, 75, 0xcd, 0x9f, 0x9f, 0x91, 0xa4, 0x16, 0xe6, 0xff, 0x60, 0xc1,
	0x24, 0xbf, 0xbf, 0xe7, 0xa0, 0x00, 0x0f, 0x21, 0x0c, 0x2a, 0x00},
{1280, 960, 85, 0x67, 0x4f, 0x4f, 0x8b, 0x54, 0x9e, 0xf1, 0xff, 0x60, 0xc1,
	0x24, 0xbf, 0xbf, 0xf2, 0x20, 0x00, 0x0f, 0x21, 0x38, 0xa4, 0x01},
{1280, 1024, 60, 0xce, 0x9f, 0x9f, 0x92, 0xa6, 0x14, 0x28, 0x5a, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x29, 0xa0, 0x41, 0x0f, 0x21, 0x50, 0xa4, 0x00},
	0x24, 0xff, 0xff, 0x29, 0xa0, 0x41, 0x0f, 0x21, 0x12, 0xb3, 0x00},
{1280, 1024, 75, 0xce, 0x9f, 0x9f, 0x92, 0xa2, 0x14, 0x28, 0x5a, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x29, 0xa0, 0x41, 0x0f, 0x21, 0x30, 0x82, 0x00},
	0x24, 0xff, 0xff, 0x29, 0xa0, 0x41, 0x0f, 0x21, 0x15, 0x82, 0x00},
{1280, 1024, 85, 0x67, 0x4f, 0x4f, 0x8b, 0x54, 0x9e, 0x2e, 0x5a, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x2f, 0x20, 0x41, 0x0f, 0x21, 0x28, 0x82, 0x01},
	0x24, 0xff, 0xff, 0x2f, 0x20, 0x41, 0x0f, 0x21, 0x11, 0x82, 0x01},
{1280, 1024, 100, 0x67, 0x4f, 0x4f, 0x8b, 0x54, 0x9e, 0x2e, 0x5a, 0x60, 0x01,
//	0x24, 0xff, 0xff, 0x2f, 0x20, 0x41, 0x0f, 0x21, 0x3c, 0xda, 0x01},
	0x24, 0xff, 0xff, 0x2f, 0x20, 0x41, 0x0f, 0x21, 0x0a, 0xcd, 0x01},
{1600, 1024, 76, 0x7e, 0x63, 0x63, 0x82, 0x66, 0x0f, 0x2c, 0x5a, 0x60, 0x03,
   0x06, 0xff, 0xff, 0x2d, 0x80, 0x41, 0xcf, 0x21, 0x4c, 0xf8, 0x01,},
{1600, 1200, 60, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb1,
//	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x44, 0xd5, 0x01},
	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x0a, 0xb3, 0x01},
{1600, 1200, 65, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb1,
//	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x44, 0xe7, 0x01},
	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x11, 0x91, 0x01},
{1600, 1200, 70, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb1,
//	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x34, 0xc4, 0x01},
	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x0d, 0x82, 0x01},
{1600, 1200, 75, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb1,
//	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x30, 0xc4, 0x01},
	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x09, 0x6f, 0x01},
{1600, 1200, 80, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb1,
//	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x24, 0xa4, 0x01},
	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x11, 0xb3, 0x01},
{1600, 1200, 85, 0x82, 0x63, 0x63, 0x86, 0x68, 0x14, 0xe0, 0x10, 0x40, 0xb1,
//	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x0c, 0x4e, 0x01},
	0x24, 0xaf, 0xaf, 0xe1, 0x80, 0x55, 0x0f, 0x21, 0x09, 0x7e, 0x01},
{1792, 1344, 60, 0x8e, 0x6f, 0x6f, 0x92, 0x71, 0x1f, 0x74, 0x1f, 0x40, 0x43,
//	0x29, 0x3f, 0x3f, 0x75, 0x80, 0x55, 0x0f, 0x21, 0x30, 0xbf, 0x01},
	0x29, 0x3f, 0x3f, 0x75, 0x80, 0x55, 0x0f, 0x21, 0x15, 0xbf, 0x01},
{1792, 1344, 75, 0x94, 0x6f, 0x6f, 0x98, 0x74, 0x01, 0x87, 0x1f, 0x40, 0x4a,
//	0x4d, 0x3f, 0x3f, 0x88, 0x00, 0x55, 0x0f, 0x21, 0x0c, 0x59, 0x01},
	0x4d, 0x3f, 0x3f, 0x88, 0x00, 0x55, 0x0f, 0x21, 0x05, 0x6b, 0x01},
{1856, 1392, 60, 0x92, 0x73, 0x73, 0x96, 0x7c, 0x03, 0xa4, 0x1f, 0x40, 0x73,
//	0x29, 0x6f, 0x6f, 0xa5, 0x00, 0x55, 0x0f, 0x21, 0x3c, 0xf7, 0x01},
	0x29, 0x6f, 0x6f, 0xa5, 0x00, 0x55, 0x0f, 0x21, 0x15, 0xcb, 0x01},
{1920, 1200, 76, 0x9d, 0x77, 0x77, 0x81, 0x7c, 0x8b, 0xe0, 0x10, 0x40, 0xb3,
   0xb6, 0xaf, 0xaf, 0xe1, 0x00, 0x55, 0xcf, 0x21, 0x14, 0x76, 0x01,},
{1920, 1440, 60, 0x9d, 0x77, 0x77, 0x81, 0x7a, 0x87, 0xda, 0x1f, 0x40, 0xa1,
//	0x24, 0x9f, 0x9f, 0xdb, 0x00, 0x55, 0x0f, 0x21, 0x30, 0xe3, 0x01},
	0x24, 0x9f, 0x9f, 0xdb, 0x00, 0x55, 0x0f, 0x21, 0x0d, 0xa1, 0x01},
{2048, 1536, 60, 0x98, 0x7f, 0x7f, 0x9c, 0x80, 0x0f, 0x3b, 0xba, 0x40, 0x01,
   0x04, 0xff, 0xff, 0x3c, 0x00, 0x55, 0x0f, 0x21, 0x28, 0xc7, 0x01,},
{2048, 1536, 75, 0xa1, 0x7f, 0x7f, 0x85, 0x84, 0x90, 0x44, 0xba, 0x40, 0x01,
   0x04, 0xff, 0xff, 0x45, 0x00, 0x55, 0x0f, 0x21, 0x1c, 0xc7, 0x01,},
// STB Begin Changes
#endif  // #ifdef H4
// STB End Changes
