/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtksimplebutton.h"

static void gtk_simple_button_class_init (GtkSimpleButtonClass *klass);
static void gtk_simple_button_init	 (GtkSimpleButton      *simple_button);


static GtkButtonClass *parent_class = NULL;

GType
gtk_simple_button_get_type (void)
{
  static GType simple_button_type = 0;

  if (!simple_button_type)
    {
      static const GTypeInfo simple_button_info =
      {
	sizeof (GtkSimpleButtonClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) gtk_simple_button_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (GtkSimpleButton),
	0,		/* n_preallocs */
	(GInstanceInitFunc) gtk_simple_button_init,
        NULL,           /* value_table */
      };

      simple_button_type =
	g_type_register_static (GTK_TYPE_BUTTON,
				"GtkSimpleButton",
				&simple_button_info, 0);
    }

  return simple_button_type;
}

static void
gtk_simple_button_class_init (GtkSimpleButtonClass *class)
{
  GObjectClass *gobject_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;
  GtkButtonClass *button_class;
  GtkSimpleButtonClass *simple_button_class;

  gobject_class = G_OBJECT_CLASS (class);
  widget_class = (GtkWidgetClass*) class;
  container_class = (GtkContainerClass*) class;
  button_class = (GtkButtonClass*) class;
  simple_button_class = (GtkSimpleButtonClass *) class;

  parent_class = g_type_class_peek_parent (class);

  widget_class->size_request  = _gtk_simple_button_size_request;
  widget_class->size_allocate = _gtk_simple_button_size_allocate;
  widget_class->expose_event  = _gtk_simple_button_expose;
}

static void
gtk_simple_button_init (GtkSimpleButton *simple_button)
{
}


GtkWidget*
gtk_simple_button_new (void)
{
  return g_object_new (GTK_TYPE_SIMPLE_BUTTON,
		       NULL);
}

GtkWidget*
gtk_simple_button_new_with_label (const gchar *label)
{
  return g_object_new (GTK_TYPE_SIMPLE_BUTTON,
		       "label", label,
		       NULL);
}



void
_gtk_simple_button_size_request (GtkWidget        *widget,
				 GtkRequisition   *requisition)
{
  GtkWidget *child;
  gint tmp_width;
  gint tmp_height;


  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_BUTTON (widget));


  child = GTK_BIN (widget)->child;

  if ((child != NULL) &&
      GTK_WIDGET_VISIBLE (child))
    {
      GtkRequisition child_requisition;

      gtk_widget_size_request (child, &child_requisition);

      tmp_width = child_requisition.width;
      tmp_height = child_requisition.height;
    }
  else
    {
      tmp_width  = 10;
      tmp_height = 10;
    }

  requisition->width  = tmp_width;
  requisition->height = tmp_height;
}

void
_gtk_simple_button_size_allocate (GtkWidget     *widget,
				  GtkAllocation *allocation)
{
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_BUTTON (widget));


  widget->allocation = *allocation;

  if (GTK_WIDGET_REALIZED (widget))
    {
      gdk_window_move_resize (GTK_BUTTON (widget)->event_window,
			      widget->allocation.x,
			      widget->allocation.y,
			      widget->allocation.width,
			      widget->allocation.height);
    }

  if (GTK_BIN (widget)->child &&
      GTK_WIDGET_VISIBLE (GTK_BIN (widget)->child))
    {
      gtk_widget_size_allocate (GTK_BIN (widget)->child, allocation);
    }
}

gint
_gtk_simple_button_expose (GtkWidget      *widget,
			   GdkEventExpose *event)
{
  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_BUTTON (widget), FALSE);


  if (GTK_WIDGET_DRAWABLE (widget))
    {
      gtk_paint_flat_box (widget->style,
			  widget->window,
			  ((GTK_WIDGET_STATE (widget) == GTK_STATE_PRELIGHT)
			   ? GTK_STATE_PRELIGHT
			   : GTK_STATE_NORMAL),
			  GTK_SHADOW_NONE,
			  &event->area,
			  widget,
			  "simplebutton",
			  event->area.x,
			  event->area.y,
			  event->area.width,
			  event->area.height);

      if (GTK_BIN (widget)->child)
	gtk_container_propagate_expose (GTK_CONTAINER (widget),
					GTK_BIN (widget)->child, event);
    }
  
  return FALSE;
}
