/* gmpc-test-plugin.c generated by valac, the Vala compiler
 * generated from gmpc-test-plugin.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <metadata.h>
#include <gmpc_easy_download.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <metadata-cache.h>
#include <main.h>
#include <plugin.h>
#include <config1.h>
#include <gdk/gdk.h>

#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))

struct _GmpcMetaDataEditWindowPrivate {
	mpd_Song* song;
	MetaDataType query_type;
	GList* downloads;
	void* handle;
	void* handle2;
	GtkHBox* pbox;
	GtkLabel* warning_label;
	GtkEntry* artist_entry;
	GtkEntry* album_entry;
	GtkEntry* title_entry;
	GtkButton* cancel;
	GtkButton* refresh;
	GtkComboBox* combo;
	GtkProgressBar* bar;
	GtkScrolledWindow* sw;
	GtkEventBox* ilevent;
	GtkVBox* itemslist;
};


static gpointer gmpc_meta_data_edit_window_parent_class = NULL;
static gpointer gmpc_test_plugin_parent_class = NULL;
static GmpcPluginToolMenuIfaceIface* gmpc_test_plugin_gmpc_plugin_tool_menu_iface_parent_iface = NULL;
static GmpcPluginSongListIfaceIface* gmpc_test_plugin_gmpc_plugin_song_list_iface_parent_iface = NULL;

#define use_transition_tp TRUE
#define GMPC_META_DATA_EDIT_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_META_DATA_TYPE_EDIT_WINDOW, GmpcMetaDataEditWindowPrivate))
enum  {
	GMPC_META_DATA_EDIT_WINDOW_DUMMY_PROPERTY
};
#define GMPC_META_DATA_EDIT_WINDOW_some_unique_name VERSION
static void gmpc_meta_data_edit_window_set_metadata (GmpcMetaDataEditWindow* self, GtkButton* button);
static void _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gmpc_meta_data_edit_window_add_entry_image (GmpcMetaDataEditWindow* self, const char* provider, const char* uri, GdkPixbufFormat* format, GdkPixbuf* pb, gboolean is_raw);
static void gmpc_meta_data_edit_window_add_entry_text (GmpcMetaDataEditWindow* self, const char* provider, const char* uri, const char* text);
static void _gmpc_meta_data_edit_window_image_downloaded_gmpc_async_download_callback (const GEADAsyncHandler* handle, GEADStatus status, gpointer self);
static guchar* _vala_array_dup1 (guchar* self, int length);
static void _gmpc_meta_data_edit_window_store_image_gmpc_async_download_callback (const GEADAsyncHandler* handle, GEADStatus status, gpointer self);
static void gmpc_meta_data_edit_window_clear_itemslist (GmpcMetaDataEditWindow* self);
static void _gmpc_meta_data_edit_window_callback_gmpc_meta_data_callback (void* handle, const char* plugin_name, GList* list, gpointer self);
static void gmpc_meta_data_edit_window_combo_box_changed (GmpcMetaDataEditWindow* self, GtkComboBox* comb);
static void _gmpc_meta_data_edit_window_b_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_meta_data_edit_window_destroy_popup_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_meta_data_edit_window_combo_box_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _gmpc_meta_data_edit_window_refresh_query_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda38_ (GtkWidget* source, GtkStyle* old, GmpcMetaDataEditWindow* self);
static void __lambda38__gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self);
static void _lambda39_ (GtkWidget* source, GdkRectangle* alloc, GmpcMetaDataEditWindow* self);
static void __lambda39__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static GObject * gmpc_meta_data_edit_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_meta_data_edit_window_finalize (GObject* obj);
enum  {
	GMPC_TEST_PLUGIN_DUMMY_PROPERTY
};
static gint* gmpc_test_plugin_real_get_version (GmpcPluginBase* base, int* result_length1);
static const char* gmpc_test_plugin_real_get_name (GmpcPluginBase* base);
static void gmpc_test_plugin_real_save_yourself (GmpcPluginBase* base);
static gboolean gmpc_test_plugin_real_get_enabled (GmpcPluginBase* base);
static void gmpc_test_plugin_real_set_enabled (GmpcPluginBase* base, gboolean state);
static void _g_list_free_gtk_tree_path_free (GList* self);
static void gmpc_test_plugin_menu_activate_tree (GmpcTestPlugin* self, GtkMenuItem* item);
static void _gmpc_test_plugin_menu_activate_tree_gtk_menu_item_activate (GtkImageMenuItem* _sender, gpointer self);
static gint gmpc_test_plugin_real_song_list (GmpcPluginSongListIface* base, GtkWidget* tree, GtkMenu* menu);
static void _gmpc_test_plugin_menu_activated_album_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gint gmpc_test_plugin_real_tool_menu_integration (GmpcPluginToolMenuIface* base, GtkMenu* menu);
static GObject * gmpc_test_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);



static void _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_set_metadata (self, _sender);
}


static void gmpc_meta_data_edit_window_add_entry_image (GmpcMetaDataEditWindow* self, const char* provider, const char* uri, GdkPixbufFormat* format, GdkPixbuf* pb, gboolean is_raw) {
	char* a;
	char* _tmp0_;
	gint new_h = 0;
	gint new_w = 0;
	GtkHBox* hbox;
	GtkLabel* label;
	GdkPixbuf* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* image;
	GtkAlignment* ali;
	GtkButton* button;
	GtkHSeparator* sep;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (pb != NULL);
	a = NULL;
	a = (_tmp0_ = g_strdup (""), _g_free0 (a), _tmp0_);
	if (provider != NULL) {
		char* _tmp2_;
		char* _tmp1_;
		a = (_tmp2_ = g_strconcat (a, _tmp1_ = g_markup_printf_escaped ("\n<b>%s</b>:  %s", _ ("Provider"), provider), NULL), _g_free0 (a), _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (format != NULL) {
		char* _tmp4_;
		char* _tmp3_;
		a = (_tmp4_ = g_strconcat (a, _tmp3_ = g_markup_printf_escaped ("\n<b>%s</b>: %s", _ ("Filetype"), gdk_pixbuf_format_get_name (format)), NULL), _g_free0 (a), _tmp4_);
		_g_free0 (_tmp3_);
	}
	if (pb != NULL) {
		char* _tmp6_;
		char* _tmp5_;
		a = (_tmp6_ = g_strconcat (a, _tmp5_ = g_strdup_printf ("\n<b>%s</b>: %ix%i (%s)", _ ("Size"), gdk_pixbuf_get_width (pb), gdk_pixbuf_get_height (pb), _ ("wxh")), NULL), _g_free0 (a), _tmp6_);
		_g_free0 (_tmp5_);
	}
	if (gdk_pixbuf_get_width (pb) < gdk_pixbuf_get_height (pb)) {
		new_h = 150;
		new_w = (gint) ((150.0 / ((double) gdk_pixbuf_get_height (pb))) * gdk_pixbuf_get_width (pb));
	} else {
		new_w = 150;
		new_h = (gint) ((150.0 / ((double) gdk_pixbuf_get_width (pb))) * gdk_pixbuf_get_height (pb));
	}
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_markup (label, a);
	gtk_label_set_line_wrap (label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	image = (_tmp8_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_pixbuf (_tmp7_ = gdk_pixbuf_scale_simple (pb, new_w, new_h, GDK_INTERP_BILINEAR))), _g_object_unref0 (_tmp7_), _tmp8_);
	gtk_widget_set_size_request ((GtkWidget*) image, 180, -1);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f));
	button = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Set")));
	if (!is_raw) {
		g_object_set_data_full ((GObject*) button, "path", (void*) g_strdup (uri), (GDestroyNotify) g_free);
	} else {
		g_object_set_data_full ((GObject*) button, "data", (void*) g_strdup (uri), (GDestroyNotify) g_free);
	}
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, TRUE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) hbox, FALSE, TRUE, (guint) 0);
	sep = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ());
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_widget_show ((GtkWidget*) sep);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) sep, FALSE, TRUE, (guint) 0);
	_g_free0 (a);
	_g_object_unref0 (hbox);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (ali);
	_g_object_unref0 (button);
	_g_object_unref0 (sep);
}


static void gmpc_meta_data_edit_window_add_entry_text (GmpcMetaDataEditWindow* self, const char* provider, const char* uri, const char* text) {
	char* a;
	char* _tmp0_;
	GtkHBox* hbox;
	GtkLabel* label;
	GtkLabel* text_label;
	GtkAlignment* ali;
	GtkButton* button;
	GtkHSeparator* sep;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (text != NULL);
	a = NULL;
	a = (_tmp0_ = g_strdup (""), _g_free0 (a), _tmp0_);
	if (provider != NULL) {
		char* _tmp2_;
		char* _tmp1_;
		a = (_tmp2_ = g_strconcat (a, _tmp1_ = g_strdup_printf ("\n<b>%s</b>:  %s", _ ("Provider"), provider), NULL), _g_free0 (a), _tmp2_);
		_g_free0 (_tmp1_);
	}
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
	gtk_label_set_markup (label, a);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_line_wrap (label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.0f);
	gtk_widget_set_size_request ((GtkWidget*) label, 280, -1);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, TRUE, (guint) 0);
	text_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (text));
	gtk_label_set_ellipsize (text_label, PANGO_ELLIPSIZE_END);
	gtk_misc_set_alignment ((GtkMisc*) text_label, 0.0f, 0.0f);
	gtk_widget_set_size_request ((GtkWidget*) text_label, 180, -1);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) text_label, TRUE, TRUE, (guint) 0);
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f));
	button = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Set")));
	g_object_set_data_full ((GObject*) button, "lyrics", (void*) g_strdup (text), (GDestroyNotify) g_free);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, TRUE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) hbox, FALSE, TRUE, (guint) 0);
	sep = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ());
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_widget_show ((GtkWidget*) sep);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) sep, FALSE, TRUE, (guint) 0);
	_g_free0 (a);
	_g_object_unref0 (hbox);
	_g_object_unref0 (label);
	_g_object_unref0 (text_label);
	_g_object_unref0 (ali);
	_g_object_unref0 (button);
	_g_object_unref0 (sep);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gmpc_meta_data_edit_window_image_downloaded (GmpcMetaDataEditWindow* self, const GEADAsyncHandler* handle, GEADStatus status) {
	GError * _inner_error_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	_inner_error_ = NULL;
	if (status == GEAD_PROGRESS) {
		return;
	}
	self->priv->downloads = g_list_remove (self->priv->downloads, handle);
	gtk_progress_bar_pulse (self->priv->bar);
	if (status == GEAD_DONE) {
		guchar* _tmp1_;
		gint data_size;
		gint data_length1;
		gint _tmp0_;
		guchar* data;
		gboolean _tmp2_ = FALSE;
		data = (_tmp1_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp0_), data_length1 = _tmp0_, data_size = data_length1, _tmp1_);
		if (self->priv->query_type == META_ALBUM_ART) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->query_type == META_ARTIST_ART;
		}
		if (_tmp2_) {
			{
				GdkPixbufLoader* load;
				GdkPixbuf* pb;
				load = gdk_pixbuf_loader_new ();
				{
					gdk_pixbuf_loader_write (load, data, (gsize) data_length1, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch18_g_error;
					}
				}
				goto __finally18;
				__catch18_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stdout, "Failed to load file: %s::%s\n", e->message, gmpc_easy_handler_get_uri (handle));
						_g_error_free0 (e);
					}
				}
				__finally18:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (load);
					goto __catch17_g_error;
				}
				gdk_pixbuf_loader_close (load, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (load);
					goto __catch17_g_error;
				}
				pb = _g_object_ref0 (gdk_pixbuf_loader_get_pixbuf (load));
				if (pb != NULL) {
					gmpc_meta_data_edit_window_add_entry_image (self, (const char*) gmpc_easy_handler_get_user_data (handle), gmpc_easy_handler_get_uri (handle), gdk_pixbuf_loader_get_format (load), pb, FALSE);
				}
				_g_object_unref0 (load);
				_g_object_unref0 (pb);
			}
			goto __finally17;
			__catch17_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					fprintf (stdout, "Failed to load file: %s::%s\n", e->message, gmpc_easy_handler_get_uri (handle));
					_g_error_free0 (e);
				}
			}
			__finally17:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			gmpc_meta_data_edit_window_add_entry_text (self, (const char*) gmpc_easy_handler_get_user_data (handle), gmpc_easy_handler_get_uri (handle), (const char*) data);
		}
	}
	if (self->priv->handle == NULL) {
		_tmp4_ = self->priv->handle2 == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = self->priv->downloads == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gtk_widget_hide ((GtkWidget*) self->priv->pbox);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
	}
}


static void _gmpc_meta_data_edit_window_image_downloaded_gmpc_async_download_callback (const GEADAsyncHandler* handle, GEADStatus status, gpointer self) {
	gmpc_meta_data_edit_window_image_downloaded (self, handle, status);
}


static guchar* _vala_array_dup1 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


void gmpc_meta_data_edit_window_callback (GmpcMetaDataEditWindow* self, void* handle, const char* plugin_name, GList* list) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	gtk_progress_bar_pulse (self->priv->bar);
	if (list == NULL) {
		if (self->priv->handle == handle) {
			gboolean _tmp0_ = FALSE;
			self->priv->handle = NULL;
			if (self->priv->handle == NULL) {
				_tmp0_ = self->priv->downloads == NULL;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gtk_widget_hide ((GtkWidget*) self->priv->pbox);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
			}
		}
		if (self->priv->handle2 == handle) {
			gboolean _tmp1_ = FALSE;
			self->priv->handle2 = NULL;
			if (self->priv->handle == NULL) {
				_tmp1_ = self->priv->downloads == NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				gtk_widget_hide ((GtkWidget*) self->priv->pbox);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
			}
		}
	}
	{
		GList* md_collection;
		GList* md_it;
		md_collection = list;
		for (md_it = md_collection; md_it != NULL; md_it = md_it->next) {
			const MetaData* md;
			md = (const MetaData*) md_it->data;
			{
				gboolean _tmp2_ = FALSE;
				if (self->priv->query_type == META_ALBUM_ART) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = self->priv->query_type == META_ARTIST_ART;
				}
				if (_tmp2_) {
					if (md->content_type == META_DATA_CONTENT_URI) {
						const char* uri;
						uri = meta_data_get_uri (md);
						if (md->content_type == META_DATA_CONTENT_URI) {
							if (g_utf8_get_char (g_utf8_offset_to_pointer (uri, 0)) == '/') {
								{
									GdkPixbuf* pb;
									pb = gdk_pixbuf_new_from_file (uri, &_inner_error_);
									if (_inner_error_ != NULL) {
										goto __catch19_g_error;
									}
									if (pb != NULL) {
										gint w = 0;
										gint h = 0;
										gmpc_meta_data_edit_window_add_entry_image (self, plugin_name, uri, gdk_pixbuf_get_file_info (uri, &w, &h), pb, FALSE);
									}
									_g_object_unref0 (pb);
								}
								goto __finally19;
								__catch19_g_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									{
										_g_error_free0 (e);
									}
								}
								__finally19:
								if (_inner_error_ != NULL) {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							} else {
								GEADAsyncHandler* h;
								h = gmpc_easy_async_downloader (uri, _gmpc_meta_data_edit_window_image_downloaded_gmpc_async_download_callback, self);
								if (h != NULL) {
									gmpc_easy_handler_set_user_data (h, md->plugin_name);
									self->priv->downloads = g_list_append (self->priv->downloads, h);
								}
							}
						}
					} else {
						if (md->content_type == META_DATA_CONTENT_RAW) {
							guchar* _tmp5_;
							gint data_size;
							gint data_length1;
							guchar* _tmp4_;
							gint _tmp3_;
							guchar* data;
							GdkPixbufLoader* load;
							GdkPixbuf* pb;
							data = (_tmp5_ = (_tmp4_ = meta_data_get_raw (md, &_tmp3_), (_tmp4_ == NULL) ? ((gpointer) _tmp4_) : _vala_array_dup1 (_tmp4_, _tmp3_)), data_length1 = _tmp3_, data_size = data_length1, _tmp5_);
							load = gdk_pixbuf_loader_new ();
							{
								gdk_pixbuf_loader_write (load, data, (gsize) data_length1, &_inner_error_);
								if (_inner_error_ != NULL) {
									goto __catch20_g_error;
								}
							}
							goto __finally20;
							__catch20_g_error:
							{
								GError * e;
								e = _inner_error_;
								_inner_error_ = NULL;
								{
									fprintf (stdout, "Failed to load raw data: %s\n", e->message);
									_g_error_free0 (e);
								}
							}
							__finally20:
							if (_inner_error_ != NULL) {
								data = (g_free (data), NULL);
								_g_object_unref0 (load);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							{
								gdk_pixbuf_loader_close (load, &_inner_error_);
								if (_inner_error_ != NULL) {
									goto __catch21_g_error;
								}
							}
							goto __finally21;
							__catch21_g_error:
							{
								GError * e;
								e = _inner_error_;
								_inner_error_ = NULL;
								{
									fprintf (stdout, "Failed to close loader: %s\n", e->message);
									_g_error_free0 (e);
								}
							}
							__finally21:
							if (_inner_error_ != NULL) {
								data = (g_free (data), NULL);
								_g_object_unref0 (load);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							pb = _g_object_ref0 (gdk_pixbuf_loader_get_pixbuf (load));
							if (pb != NULL) {
								char* base16;
								base16 = g_base64_encode (data, data_length1);
								gmpc_meta_data_edit_window_add_entry_image (self, plugin_name, base16, gdk_pixbuf_loader_get_format (load), pb, TRUE);
								_g_free0 (base16);
							}
							data = (g_free (data), NULL);
							_g_object_unref0 (load);
							_g_object_unref0 (pb);
						}
					}
				} else {
					if (md->content_type == META_DATA_CONTENT_TEXT) {
						const char* uri;
						uri = meta_data_get_text (md);
						gmpc_meta_data_edit_window_add_entry_text (self, plugin_name, "n/a", uri);
					} else {
						if (md->content_type == META_DATA_CONTENT_HTML) {
							char* uri;
							uri = meta_data_get_text_from_html (md);
							gmpc_meta_data_edit_window_add_entry_text (self, plugin_name, "n/a", uri);
							_g_free0 (uri);
						} else {
							if (md->content_type == META_DATA_CONTENT_URI) {
								const char* uri;
								uri = meta_data_get_uri (md);
								if (g_utf8_get_char (g_utf8_offset_to_pointer (uri, 0)) == '/') {
									{
										char* content;
										char* _tmp8_;
										gboolean _tmp7_;
										char* _tmp6_ = NULL;
										gboolean _tmp9_;
										content = NULL;
										_tmp9_ = (_tmp7_ = g_file_get_contents (uri, &_tmp6_, NULL, &_inner_error_), content = (_tmp8_ = _tmp6_, _g_free0 (content), _tmp8_), _tmp7_);
										if (_inner_error_ != NULL) {
											_g_free0 (content);
											goto __catch22_g_error;
										}
										if (_tmp9_) {
											gmpc_meta_data_edit_window_add_entry_text (self, plugin_name, uri, content);
										}
										_g_free0 (content);
									}
									goto __finally22;
									__catch22_g_error:
									{
										GError * e;
										e = _inner_error_;
										_inner_error_ = NULL;
										{
											_g_error_free0 (e);
										}
									}
									__finally22:
									if (_inner_error_ != NULL) {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


void gmpc_meta_data_edit_window_store_image (GmpcMetaDataEditWindow* self, const GEADAsyncHandler* handle, GEADStatus status) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	_inner_error_ = NULL;
	if (status == GEAD_PROGRESS) {
		guchar* _tmp1_;
		gint data_size;
		gint data_length1;
		gint _tmp0_;
		guchar* data;
		gint64 total_size;
		gboolean _tmp2_ = FALSE;
		data = (_tmp1_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp0_), data_length1 = _tmp0_, data_size = data_length1, _tmp1_);
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
		gtk_widget_show ((GtkWidget*) self->priv->pbox);
		total_size = gmpc_easy_handler_get_content_size (handle);
		if (data_length1 > 0) {
			_tmp2_ = total_size > 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			double progress;
			progress = data_length1 / ((double) total_size);
			gtk_progress_bar_set_fraction (self->priv->bar, progress);
		} else {
			gtk_progress_bar_pulse (self->priv->bar);
		}
		return;
	}
	self->priv->downloads = g_list_remove (self->priv->downloads, handle);
	if (status == GEAD_DONE) {
		guchar* _tmp4_;
		gint data_size;
		gint data_length1;
		gint _tmp3_;
		guchar* data;
		char* file;
		data = (_tmp4_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp3_), data_length1 = _tmp3_, data_size = data_length1, _tmp4_);
		file = gmpc_get_metadata_filename (self->priv->query_type, self->priv->song, NULL);
		{
			MetaData* met;
			MetaData* met_false;
			g_file_set_contents (file, (const char*) data, (gssize) ((glong) data_length1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
			met = meta_data_new ();
			met->type = self->priv->query_type;
			met->plugin_name = "User set";
			met->content_type = META_DATA_CONTENT_URI;
			meta_data_set_uri (met, file);
			meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
			met_false = meta_data_new ();
			met_false->type = self->priv->query_type;
			met_false->plugin_name = "User set";
			met_false->content_type = META_DATA_CONTENT_EMPTY;
			g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
			g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
			_meta_data_free0 (met);
			_meta_data_free0 (met_false);
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally23:
		if (_inner_error_ != NULL) {
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (file);
	}
	gtk_widget_hide ((GtkWidget*) self->priv->pbox);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
}


static void _gmpc_meta_data_edit_window_store_image_gmpc_async_download_callback (const GEADAsyncHandler* handle, GEADStatus status, gpointer self) {
	gmpc_meta_data_edit_window_store_image (self, handle, status);
}


static void gmpc_meta_data_edit_window_set_metadata (GmpcMetaDataEditWindow* self, GtkButton* button) {
	GError * _inner_error_;
	char* path;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_inner_error_ = NULL;
	path = NULL;
	if (self->priv->query_type == META_ALBUM_ART) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->query_type == META_ARTIST_ART;
	}
	if (_tmp0_) {
		char* _tmp1_;
		path = (_tmp1_ = g_strdup ((const char*) g_object_get_data ((GObject*) button, "path")), _g_free0 (path), _tmp1_);
		if (path != NULL) {
			if (g_utf8_get_char (g_utf8_offset_to_pointer (path, 0)) == '/') {
				MetaData* met;
				MetaData* met_false;
				met = meta_data_new ();
				met->type = self->priv->query_type;
				met->plugin_name = "User set";
				met->content_type = META_DATA_CONTENT_URI;
				meta_data_set_uri (met, path);
				meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
				met_false = meta_data_new ();
				met_false->type = self->priv->query_type;
				met_false->plugin_name = "User set";
				met_false->content_type = META_DATA_CONTENT_EMPTY;
				g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
				g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
				_meta_data_free0 (met);
				_meta_data_free0 (met_false);
			} else {
				GEADAsyncHandler* h;
				h = gmpc_easy_async_downloader (path, _gmpc_meta_data_edit_window_store_image_gmpc_async_download_callback, self);
				if (h != NULL) {
					self->priv->downloads = g_list_append (self->priv->downloads, h);
				}
			}
		} else {
			char* base64;
			base64 = g_strdup ((const char*) g_object_get_data ((GObject*) button, "data"));
			if (base64 != NULL) {
				char* filename;
				gsize len;
				guchar* _tmp3_;
				gint data_size;
				gint data_length1;
				size_t _tmp2_;
				guchar* data;
				filename = gmpc_get_metadata_filename (self->priv->query_type, self->priv->song, NULL);
				len = (gsize) 0;
				data = (_tmp3_ = g_base64_decode (base64, &_tmp2_), data_length1 = _tmp2_, data_size = data_length1, _tmp3_);
				{
					MetaData* met;
					MetaData* met_false;
					g_file_set_contents (filename, (const char*) data, (gssize) len, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch24_g_error;
					}
					met = meta_data_new ();
					met->type = self->priv->query_type;
					met->plugin_name = "User set";
					met->content_type = META_DATA_CONTENT_URI;
					meta_data_set_uri (met, filename);
					meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
					met_false = meta_data_new ();
					met_false->type = self->priv->query_type;
					met_false->plugin_name = "User set";
					met_false->content_type = META_DATA_CONTENT_EMPTY;
					g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
					g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
					_meta_data_free0 (met);
					_meta_data_free0 (met_false);
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (e);
					}
				}
				__finally24:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					data = (g_free (data), NULL);
					_g_free0 (base64);
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (filename);
				data = (g_free (data), NULL);
			}
			_g_free0 (base64);
		}
	} else {
		char* lyric;
		char* _tmp4_;
		char* file;
		lyric = NULL;
		lyric = (_tmp4_ = g_strdup ((const char*) g_object_get_data ((GObject*) button, "lyrics")), _g_free0 (lyric), _tmp4_);
		file = gmpc_get_metadata_filename (self->priv->query_type, self->priv->song, NULL);
		{
			MetaData* met;
			MetaData* met_false;
			g_file_set_contents (file, lyric, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch25_g_error;
			}
			met = meta_data_new ();
			met->type = self->priv->query_type;
			met->plugin_name = "User set";
			met->content_type = META_DATA_CONTENT_URI;
			meta_data_set_uri (met, file);
			meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
			met_false = meta_data_new ();
			met_false->type = self->priv->query_type;
			met_false->plugin_name = "User set";
			met_false->content_type = META_DATA_CONTENT_EMPTY;
			g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
			g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
			_meta_data_free0 (met);
			_meta_data_free0 (met_false);
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally25:
		if (_inner_error_ != NULL) {
			_g_free0 (lyric);
			_g_free0 (file);
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (lyric);
		_g_free0 (file);
	}
	_g_free0 (path);
}


void gmpc_meta_data_edit_window_destroy_popup (GmpcMetaDataEditWindow* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


static void gmpc_meta_data_edit_window_clear_itemslist (GmpcMetaDataEditWindow* self) {
	g_return_if_fail (self != NULL);
	{
		GList* client_collection;
		GList* client_it;
		client_collection = gtk_container_get_children ((GtkContainer*) self->priv->itemslist);
		for (client_it = client_collection; client_it != NULL; client_it = client_it->next) {
			GtkWidget* client;
			client = _g_object_ref0 ((GtkWidget*) client_it->data);
			{
				gtk_object_destroy ((GtkObject*) client);
				_g_object_unref0 (client);
			}
		}
		_g_list_free0 (client_collection);
	}
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _gmpc_meta_data_edit_window_callback_gmpc_meta_data_callback (void* handle, const char* plugin_name, GList* list, gpointer self) {
	gmpc_meta_data_edit_window_callback (self, handle, plugin_name, list);
}


void gmpc_meta_data_edit_window_refresh_query (GmpcMetaDataEditWindow* self, GtkButton* button) {
	mpd_Song* ss;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gmpc_meta_data_edit_window_clear_itemslist (self);
	g_log ("MetadataSelector", G_LOG_LEVEL_DEBUG, "gmpc-test-plugin.vala:466: Query metadata");
	ss = _mpd_songDup0 (self->priv->song);
	ss->artist = (_tmp0_ = g_strdup (gtk_entry_get_text (self->priv->artist_entry)), _g_free0 (ss->artist), _tmp0_);
	ss->album = (_tmp1_ = g_strdup (gtk_entry_get_text (self->priv->album_entry)), _g_free0 (ss->album), _tmp1_);
	ss->title = (_tmp2_ = g_strdup (gtk_entry_get_text (self->priv->title_entry)), _g_free0 (ss->title), _tmp2_);
	if (self->priv->handle == NULL) {
		_tmp3_ = self->priv->handle2 == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gtk_widget_show ((GtkWidget*) self->priv->pbox);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, FALSE);
		g_log ("MetadataSelector", G_LOG_LEVEL_DEBUG, "gmpc-test-plugin.vala:477: Start metdata get_list query");
		self->priv->handle = metadata_get_list (ss, self->priv->query_type, _gmpc_meta_data_edit_window_callback_gmpc_meta_data_callback, self);
		g_log ("MetadataSelector", G_LOG_LEVEL_DEBUG, "gmpc-test-plugin.vala:479: Wait");
	}
	_mpd_freeSong0 (ss);
}


static void gmpc_meta_data_edit_window_combo_box_changed (GmpcMetaDataEditWindow* self, GtkComboBox* comb) {
	gint active;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comb != NULL);
	gmpc_meta_data_edit_window_clear_itemslist (self);
	active = gtk_combo_box_get_active (comb);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_entry, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, FALSE);
	gtk_widget_hide ((GtkWidget*) self->priv->warning_label);
	if (active == 0) {
		self->priv->query_type = META_ARTIST_ART;
		if (self->priv->song->artist != NULL) {
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
		} else {
			gtk_widget_show ((GtkWidget*) self->priv->warning_label);
		}
	} else {
		if (active == 1) {
			gboolean _tmp0_ = FALSE;
			self->priv->query_type = META_ALBUM_ART;
			if (self->priv->song->artist != NULL) {
				_tmp0_ = self->priv->song->album != NULL;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
			} else {
				gtk_widget_show ((GtkWidget*) self->priv->warning_label);
			}
		} else {
			if (active == 2) {
				gboolean _tmp1_ = FALSE;
				self->priv->query_type = META_SONG_TXT;
				if (self->priv->song->artist != NULL) {
					_tmp1_ = self->priv->song->title != NULL;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
					gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_entry, TRUE);
					gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
				} else {
					gtk_widget_show ((GtkWidget*) self->priv->warning_label);
				}
			} else {
				if (active == 3) {
					gboolean _tmp2_ = FALSE;
					self->priv->query_type = META_ALBUM_TXT;
					if (self->priv->song->artist != NULL) {
						_tmp2_ = self->priv->song->album != NULL;
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
						gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, TRUE);
						gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
					} else {
						gtk_widget_show ((GtkWidget*) self->priv->warning_label);
					}
				} else {
					if (active == 4) {
						self->priv->query_type = META_ARTIST_TXT;
						if (self->priv->song->artist != NULL) {
							gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
							gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
						} else {
							gtk_widget_show ((GtkWidget*) self->priv->warning_label);
						}
					} else {
						if (active == 5) {
							gboolean _tmp3_ = FALSE;
							self->priv->query_type = META_SONG_GUITAR_TAB;
							if (self->priv->song->artist != NULL) {
								_tmp3_ = self->priv->song->title != NULL;
							} else {
								_tmp3_ = FALSE;
							}
							if (_tmp3_) {
								gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
								gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_entry, TRUE);
								gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
							} else {
								gtk_widget_show ((GtkWidget*) self->priv->warning_label);
							}
						}
					}
				}
			}
		}
	}
}


static void _gmpc_meta_data_edit_window_b_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_b_cancel (self);
}


static void _gmpc_meta_data_edit_window_destroy_popup_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_destroy_popup (self, _sender);
}


static void _gmpc_meta_data_edit_window_combo_box_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	gmpc_meta_data_edit_window_combo_box_changed (self, _sender);
}


static void _gmpc_meta_data_edit_window_refresh_query_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_refresh_query (self, _sender);
}


static void _lambda38_ (GtkWidget* source, GtkStyle* old, GmpcMetaDataEditWindow* self) {
	GdkColor _tmp0_;
	g_return_if_fail (source != NULL);
	gtk_widget_modify_bg (gtk_widget_get_parent ((GtkWidget*) self->priv->itemslist), GTK_STATE_NORMAL, (_tmp0_ = gtk_widget_get_style ((GtkWidget*) self)->base[GTK_STATE_NORMAL], &_tmp0_));
}


static void __lambda38__gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self) {
	_lambda38_ (_sender, previous_style, self);
}


GmpcMetaDataEditWindow* gmpc_meta_data_edit_window_construct (GType object_type, const mpd_Song* song, MetaDataType type) {
	GmpcMetaDataEditWindow * self;
	GtkVBox* vbox;
	mpd_Song* _tmp0_;
	GtkHBox* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkButton* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkHBox* hbox;
	GtkButton* button;
	GtkLabel* _tmp5_;
	char* _tmp6_;
	GtkSizeGroup* group;
	GtkHBox* qhbox;
	GtkLabel* label;
	GtkListStore* list;
	GtkComboBox* _tmp7_;
	GtkCellRenderer* renderer;
	GtkCellRenderer* _tmp8_;
	GtkHBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkImage* image;
	GtkEntry* _tmp11_;
	GtkHBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkImage* _tmp14_;
	GtkEntry* _tmp15_;
	GtkHBox* _tmp16_;
	GtkLabel* _tmp17_;
	GtkImage* _tmp18_;
	GtkEntry* _tmp19_;
	GtkButton* _tmp21_;
	GtkButton* _tmp20_;
	GtkAlignment* ali;
	GtkEventBox* _tmp22_;
	GdkColor _tmp23_;
	g_return_val_if_fail (song != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	self->priv->song = (_tmp0_ = _mpd_songDup0 (song), _mpd_freeSong0 (self->priv->song), _tmp0_);
	self->priv->query_type = type;
	self->priv->pbox = (_tmp1_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6)), _g_object_unref0 (self->priv->pbox), _tmp1_);
	self->priv->bar = (_tmp2_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->bar), _tmp2_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->pbox, FALSE, FALSE, (guint) 0);
	self->priv->cancel = (_tmp3_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock ("gtk-cancel")), _g_object_unref0 (self->priv->cancel), _tmp3_);
	g_signal_connect_object (self->priv->cancel, "clicked", (GCallback) _gmpc_meta_data_edit_window_b_cancel_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->pbox, (GtkWidget*) self->priv->bar, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->pbox, (GtkWidget*) self->priv->cancel, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->bar);
	gtk_widget_show ((GtkWidget*) self->priv->cancel);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->pbox, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->pbox);
	self->priv->sw = (_tmp4_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (self->priv->sw), _tmp4_);
	gtk_scrolled_window_set_policy (self->priv->sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (self->priv->sw, GTK_SHADOW_ETCHED_IN);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	button = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock ("gtk-quit"));
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_destroy_popup_gtk_button_clicked, self, 0);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	self->priv->warning_label = (_tmp5_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->warning_label), _tmp5_);
	gtk_label_set_markup (self->priv->warning_label, _tmp6_ = g_strdup_printf ("<span size='x-large'>%s</span>", _ ("Insufficient information to store/fetch this metadata")));
	_g_free0 (_tmp6_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->warning_label, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->warning_label, FALSE, FALSE, (guint) 0);
	gtk_widget_hide ((GtkWidget*) self->priv->warning_label);
	group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	qhbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	label = NULL;
	list = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1, NULL);
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-artist", 1, _ ("Artist art"), -1);
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-album", 1, _ ("Album art"), -1);
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "gtk-dnd", 1, _ ("Song lyrics"), -1);
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-album", 1, _ ("Album Info"), -1);
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-artist", 1, _ ("Artist Biography"), -1);
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-album", 1, _ ("Guitar Tab"), -1);
	self->priv->combo = (_tmp7_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) list)), _g_object_unref0 (self->priv->combo), _tmp7_);
	renderer = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->combo, renderer, "icon-name", 0);
	renderer = (_tmp8_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp8_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->combo, renderer, "text", 1);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->combo, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (self->priv->combo, "changed", (GCallback) _gmpc_meta_data_edit_window_combo_box_changed_gtk_combo_box_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	qhbox = (_tmp9_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6)), _g_object_unref0 (qhbox), _tmp9_);
	label = (_tmp10_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Artist"))), _g_object_unref0 (label), _tmp10_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_size_group_add_widget (group, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_BUTTON));
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	self->priv->artist_entry = (_tmp11_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->artist_entry), _tmp11_);
	gtk_entry_set_text (self->priv->artist_entry, song->artist);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->artist_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	qhbox = (_tmp12_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6)), _g_object_unref0 (qhbox), _tmp12_);
	label = (_tmp13_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Album"))), _g_object_unref0 (label), _tmp13_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_size_group_add_widget (group, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	image = (_tmp14_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (image), _tmp14_);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	self->priv->album_entry = (_tmp15_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->album_entry), _tmp15_);
	if (song->album != NULL) {
		gtk_entry_set_text (self->priv->album_entry, song->album);
	}
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->album_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	qhbox = (_tmp16_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6)), _g_object_unref0 (qhbox), _tmp16_);
	label = (_tmp17_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Title"))), _g_object_unref0 (label), _tmp17_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_size_group_add_widget (group, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	image = (_tmp18_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-title", GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (image), _tmp18_);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	self->priv->title_entry = (_tmp19_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->title_entry), _tmp19_);
	if (song->title != NULL) {
		gtk_entry_set_text (self->priv->title_entry, song->title);
	}
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->title_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	if (type != META_ALBUM_ART) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, FALSE);
	}
	self->priv->refresh = (_tmp21_ = _g_object_ref0 (button = (_tmp20_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Query"))), _g_object_unref0 (button), _tmp20_)), _g_object_unref0 (self->priv->refresh), _tmp21_);
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f));
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_refresh_query_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->sw, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	gtk_widget_hide_on_delete ((GtkWidget*) self);
	self->priv->ilevent = (_tmp22_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (self->priv->ilevent), _tmp22_);
	gtk_container_set_border_width ((GtkContainer*) self->priv->itemslist, (guint) 8);
	gtk_event_box_set_visible_window (self->priv->ilevent, TRUE);
	gtk_widget_modify_bg ((GtkWidget*) self->priv->ilevent, GTK_STATE_NORMAL, (_tmp23_ = gtk_widget_get_style ((GtkWidget*) self)->base[GTK_STATE_NORMAL], &_tmp23_));
	g_signal_connect_object ((GtkWidget*) self, "style-set", (GCallback) __lambda38__gtk_widget_style_set, self, 0);
	gtk_container_add ((GtkContainer*) self->priv->ilevent, (GtkWidget*) self->priv->itemslist);
	gtk_scrolled_window_add_with_viewport (self->priv->sw, (GtkWidget*) self->priv->ilevent);
	gtk_widget_show_all ((GtkWidget*) self);
	if (type == META_ARTIST_ART) {
		gtk_combo_box_set_active (self->priv->combo, 0);
	} else {
		if (type == META_ALBUM_ART) {
			gtk_combo_box_set_active (self->priv->combo, 1);
		} else {
			if (type == META_SONG_TXT) {
				gtk_combo_box_set_active (self->priv->combo, 2);
			} else {
				if (type == META_ALBUM_TXT) {
					gtk_combo_box_set_active (self->priv->combo, 3);
				} else {
					if (type == META_ARTIST_TXT) {
						gtk_combo_box_set_active (self->priv->combo, 4);
					} else {
						if (type == META_SONG_GUITAR_TAB) {
							gtk_combo_box_set_active (self->priv->combo, 5);
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (button);
	_g_object_unref0 (group);
	_g_object_unref0 (qhbox);
	_g_object_unref0 (label);
	_g_object_unref0 (list);
	_g_object_unref0 (renderer);
	_g_object_unref0 (image);
	_g_object_unref0 (ali);
	return self;
}


GmpcMetaDataEditWindow* gmpc_meta_data_edit_window_new (const mpd_Song* song, MetaDataType type) {
	return gmpc_meta_data_edit_window_construct (GMPC_META_DATA_TYPE_EDIT_WINDOW, song, type);
}


void gmpc_meta_data_edit_window_b_cancel (GmpcMetaDataEditWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->handle != NULL) {
		metadata_get_list_cancel (self->priv->handle);
		self->priv->handle = NULL;
	}
	if (self->priv->handle2 != NULL) {
		metadata_get_list_cancel (self->priv->handle2);
		self->priv->handle2 = NULL;
	}
	g_list_first (self->priv->downloads);
	while (TRUE) {
		GEADAsyncHandler* handle;
		if (!(self->priv->downloads != NULL)) {
			break;
		}
		handle = (const GEADAsyncHandler*) self->priv->downloads->data;
		gmpc_easy_async_cancel (handle);
		g_list_first (self->priv->downloads);
	}
	gtk_widget_hide ((GtkWidget*) self->priv->pbox);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
}


static void _lambda39_ (GtkWidget* source, GdkRectangle* alloc, GmpcMetaDataEditWindow* self) {
	g_return_if_fail (source != NULL);
	cfg_set_single_value_as_int (config, "Metadata Selector", "window_width", (*alloc).width);
	cfg_set_single_value_as_int (config, "Metadata Selector", "window_height", (*alloc).height);
}


static void __lambda39__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda39_ (_sender, allocation, self);
}


static GObject * gmpc_meta_data_edit_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcMetaDataEditWindow * self;
	parent_class = G_OBJECT_CLASS (gmpc_meta_data_edit_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_META_DATA_EDIT_WINDOW (obj);
	{
		gint height;
		gint width;
		g_object_set ((GtkWindow*) self, "type", GTK_WINDOW_TOPLEVEL, NULL);
		height = cfg_get_single_value_as_int_with_default (config, "Metadata Selector", "window_height", 600);
		width = cfg_get_single_value_as_int_with_default (config, "Metadata Selector", "window_width", 480);
		gtk_window_resize ((GtkWindow*) self, width, height);
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 8);
		g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __lambda39__gtk_widget_size_allocate, self, 0);
	}
	return obj;
}


static void gmpc_meta_data_edit_window_class_init (GmpcMetaDataEditWindowClass * klass) {
	gmpc_meta_data_edit_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaDataEditWindowPrivate));
	G_OBJECT_CLASS (klass)->constructor = gmpc_meta_data_edit_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_data_edit_window_finalize;
}


static void gmpc_meta_data_edit_window_instance_init (GmpcMetaDataEditWindow * self) {
	self->priv = GMPC_META_DATA_EDIT_WINDOW_GET_PRIVATE (self);
	self->priv->song = NULL;
	self->priv->query_type = META_ALBUM_ART;
	self->priv->downloads = NULL;
	self->priv->handle = NULL;
	self->priv->handle2 = NULL;
	self->priv->pbox = NULL;
	self->priv->warning_label = NULL;
	self->priv->cancel = NULL;
	self->priv->refresh = NULL;
	self->priv->combo = NULL;
	self->priv->bar = NULL;
	self->priv->sw = NULL;
	self->priv->ilevent = NULL;
	self->priv->itemslist = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
}


static void gmpc_meta_data_edit_window_finalize (GObject* obj) {
	GmpcMetaDataEditWindow * self;
	self = GMPC_META_DATA_EDIT_WINDOW (obj);
	{
		gmpc_meta_data_edit_window_b_cancel (self);
	}
	_mpd_freeSong0 (self->priv->song);
	_g_list_free0 (self->priv->downloads);
	_g_object_unref0 (self->priv->pbox);
	_g_object_unref0 (self->priv->warning_label);
	_g_object_unref0 (self->priv->artist_entry);
	_g_object_unref0 (self->priv->album_entry);
	_g_object_unref0 (self->priv->title_entry);
	_g_object_unref0 (self->priv->cancel);
	_g_object_unref0 (self->priv->refresh);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->bar);
	_g_object_unref0 (self->priv->sw);
	_g_object_unref0 (self->priv->ilevent);
	_g_object_unref0 (self->priv->itemslist);
	G_OBJECT_CLASS (gmpc_meta_data_edit_window_parent_class)->finalize (obj);
}


GType gmpc_meta_data_edit_window_get_type (void) {
	static GType gmpc_meta_data_edit_window_type_id = 0;
	if (gmpc_meta_data_edit_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaDataEditWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_data_edit_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaDataEditWindow), 0, (GInstanceInitFunc) gmpc_meta_data_edit_window_instance_init, NULL };
		gmpc_meta_data_edit_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "GmpcMetaDataEditWindow", &g_define_type_info, 0);
	}
	return gmpc_meta_data_edit_window_type_id;
}


static gint* gmpc_test_plugin_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcTestPlugin * self;
	gint* result;
	gint* _tmp0_;
	self = (GmpcTestPlugin*) base;
	result = (_tmp0_ = GMPC_TEST_PLUGIN_version, *result_length1 = G_N_ELEMENTS (GMPC_TEST_PLUGIN_version), _tmp0_);
	return result;
}


static const char* gmpc_test_plugin_real_get_name (GmpcPluginBase* base) {
	GmpcTestPlugin * self;
	const char* result;
	self = (GmpcTestPlugin*) base;
	result = "Vala test plugin";
	return result;
}


static void gmpc_test_plugin_real_save_yourself (GmpcPluginBase* base) {
	GmpcTestPlugin * self;
	self = (GmpcTestPlugin*) base;
}


static gboolean gmpc_test_plugin_real_get_enabled (GmpcPluginBase* base) {
	GmpcTestPlugin * self;
	gboolean result;
	self = (GmpcTestPlugin*) base;
	result = (gboolean) cfg_get_single_value_as_int_with_default (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "enabled", 1);
	return result;
}


static void gmpc_test_plugin_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcTestPlugin * self;
	self = (GmpcTestPlugin*) base;
	cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "enabled", (gint) state);
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static void gmpc_test_plugin_menu_activate_tree (GmpcTestPlugin* self, GtkMenuItem* item) {
	GtkTreeIter iter = {0};
	GtkTreeView* tv;
	GtkTreeModel* model;
	GtkTreeSelection* selection;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	tv = _g_object_ref0 (GTK_TREE_VIEW (g_object_get_data ((GObject*) item, "treeview")));
	model = _g_object_ref0 (gtk_tree_view_get_model (tv));
	selection = _g_object_ref0 (gtk_tree_view_get_selection (tv));
	{
		GtkTreeModel* _tmp2_;
		GList* _tmp1_;
		GtkTreeModel* _tmp0_ = NULL;
		GList* path_collection;
		GList* path_it;
		path_collection = (_tmp1_ = gtk_tree_selection_get_selected_rows (selection, &_tmp0_), model = (_tmp2_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp2_), _tmp1_);
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* path;
			path = (GtkTreePath*) path_it->data;
			{
				if (gtk_tree_model_get_iter (model, &iter, path)) {
					const mpd_Song* song;
					song = NULL;
					gtk_tree_model_get (model, &iter, 0, &song, -1);
					if (song != NULL) {
						GmpcMetaDataEditWindow* _tmp3_;
						_tmp3_ = g_object_ref_sink (gmpc_meta_data_edit_window_new (song, META_ALBUM_ART));
						_g_object_unref0 (_tmp3_);
					}
				}
			}
		}
		__g_list_free_gtk_tree_path_free0 (path_collection);
	}
	_g_object_unref0 (tv);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void _gmpc_test_plugin_menu_activate_tree_gtk_menu_item_activate (GtkImageMenuItem* _sender, gpointer self) {
	gmpc_test_plugin_menu_activate_tree (self, _sender);
}


static gint gmpc_test_plugin_real_song_list (GmpcPluginSongListIface* base, GtkWidget* tree, GtkMenu* menu) {
	GmpcTestPlugin * self;
	gint result;
	GtkTreeView* tv;
	GtkTreeSelection* selection;
	self = (GmpcTestPlugin*) base;
	g_return_val_if_fail (tree != NULL, 0);
	g_return_val_if_fail (menu != NULL, 0);
	tv = _g_object_ref0 (GTK_TREE_VIEW (tree));
	selection = _g_object_ref0 (gtk_tree_view_get_selection (tv));
	if (gtk_tree_selection_count_selected_rows (selection) > 0) {
		GtkImageMenuItem* item;
		GtkImage* _tmp0_;
		item = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Metadata selector")));
		gtk_image_menu_item_set_image (item, (GtkWidget*) (_tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ("gtk-edit", GTK_ICON_SIZE_MENU))));
		_g_object_unref0 (_tmp0_);
		g_object_set_data ((GObject*) item, "treeview", tv);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_test_plugin_menu_activate_tree_gtk_menu_item_activate, self, 0);
		result = 1;
		_g_object_unref0 (item);
		_g_object_unref0 (tv);
		_g_object_unref0 (selection);
		return result;
	}
	result = 0;
	_g_object_unref0 (tv);
	_g_object_unref0 (selection);
	return result;
}


void gmpc_test_plugin_menu_activated_album (GmpcTestPlugin* self, GtkMenuItem* item) {
	const mpd_Song* song;
	GmpcMetaDataEditWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	song = mpd_playlist_get_current_song (connection);
	_tmp0_ = g_object_ref_sink (gmpc_meta_data_edit_window_new (song, META_ALBUM_ART));
	_g_object_unref0 (_tmp0_);
}


static void _gmpc_test_plugin_menu_activated_album_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_test_plugin_menu_activated_album (self, _sender);
}


static gint gmpc_test_plugin_real_tool_menu_integration (GmpcPluginToolMenuIface* base, GtkMenu* menu) {
	GmpcTestPlugin * self;
	gint result;
	GtkMenuItem* item;
	self = (GmpcTestPlugin*) base;
	g_return_val_if_fail (menu != NULL, 0);
	item = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label ("Edit metadata current song"));
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	g_signal_connect_object (item, "activate", (GCallback) _gmpc_test_plugin_menu_activated_album_gtk_menu_item_activate, self, 0);
	result = 2;
	_g_object_unref0 (item);
	return result;
}


GmpcTestPlugin* gmpc_test_plugin_construct (GType object_type) {
	GmpcTestPlugin * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcTestPlugin* gmpc_test_plugin_new (void) {
	return gmpc_test_plugin_construct (GMPC_TYPE_TEST_PLUGIN);
}


static GObject * gmpc_test_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcTestPlugin * self;
	parent_class = G_OBJECT_CLASS (gmpc_test_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_TEST_PLUGIN (obj);
	{
		((GmpcPluginBase*) self)->plugin_type = 8 + 4;
	}
	return obj;
}


static void gmpc_test_plugin_class_init (GmpcTestPluginClass * klass) {
	gmpc_test_plugin_parent_class = g_type_class_peek_parent (klass);
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_test_plugin_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_test_plugin_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->save_yourself = gmpc_test_plugin_real_save_yourself;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_enabled = gmpc_test_plugin_real_get_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_test_plugin_real_set_enabled;
	G_OBJECT_CLASS (klass)->constructor = gmpc_test_plugin_constructor;
}


static void gmpc_test_plugin_gmpc_plugin_tool_menu_iface_interface_init (GmpcPluginToolMenuIfaceIface * iface) {
	gmpc_test_plugin_gmpc_plugin_tool_menu_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->tool_menu_integration = gmpc_test_plugin_real_tool_menu_integration;
}


static void gmpc_test_plugin_gmpc_plugin_song_list_iface_interface_init (GmpcPluginSongListIfaceIface * iface) {
	gmpc_test_plugin_gmpc_plugin_song_list_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->song_list = gmpc_test_plugin_real_song_list;
}


static void gmpc_test_plugin_instance_init (GmpcTestPlugin * self) {
}


GType gmpc_test_plugin_get_type (void) {
	static GType gmpc_test_plugin_type_id = 0;
	if (gmpc_test_plugin_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcTestPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_test_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcTestPlugin), 0, (GInstanceInitFunc) gmpc_test_plugin_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_tool_menu_iface_info = { (GInterfaceInitFunc) gmpc_test_plugin_gmpc_plugin_tool_menu_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gmpc_plugin_song_list_iface_info = { (GInterfaceInitFunc) gmpc_test_plugin_gmpc_plugin_song_list_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gmpc_test_plugin_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcTestPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_test_plugin_type_id, GMPC_PLUGIN_TYPE_TOOL_MENU_IFACE, &gmpc_plugin_tool_menu_iface_info);
		g_type_add_interface_static (gmpc_test_plugin_type_id, GMPC_PLUGIN_TYPE_SONG_LIST_IFACE, &gmpc_plugin_song_list_iface_info);
	}
	return gmpc_test_plugin_type_id;
}




