/**
 * GMyth Library
 *
 * @file gmyth/gmyth_upnp.h
 * 
 * @brief <p> GMythUPnP allows that a MythTV frontend discovers a 
 * MythTV backend, using the UPnP architecture.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 * @authon Renato Araujo Oliveira Filho <renato.filho@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GMYTH_UPNP_H_
#define _GMYTH_UPNP_H_

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS
#define GMYTH_UPNP_TYPE                 (gmyth_upnp_get_type ())
#define GMYTH_UPNP(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_UPNP_TYPE, GMythUPnP))
#define GMYTH_UPNP_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_UPNP_TYPE, GMythUPnPClass))
#define IS_GMYTH_UPNP(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_UPNP_TYPE))
#define IS_GMYTH_UPNP_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_UPNP_TYPE))
#define GMYTH_UPNP_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_UPNP_TYPE, GMythUPnPClass))

typedef struct _GMythUPnP GMythUPnP;
typedef struct _GMythUPnPClass GMythUPnPClass;

struct _GMythUPnPClass {
    GObjectClass    parent_class;
};

struct _GMythUPnP {
    GObject         parent;
};

GType               gmyth_upnp_get_type         (void);
GMythUPnP*          gmyth_upnp_get_instance     (void);
void                gmyth_upnp_search           (GMythUPnP * gmyth_upnp);
GList*              gmyth_upnp_get_devices      (GMythUPnP * gmyth_upnp);

G_END_DECLS
#endif                          /* _GMYTH_UPNP_H_ */
