#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <ctype.h>
#include "interface.h"
#include "gtkutil.h"
#include "callbacks.h"
#include "gnap.h"

// globals
main_window *the_window = NULL;
GtkWidget *download_window;
GtkWidget *properties_window;
int napster_socket;
GList *sr_list = NULL;
GList *downloads = NULL;
GList *searches = NULL;

void gnap_download_add(transfer *download) 
{
 gint row;
 GtkCList *clist;
 gchar *input[4];

 input[0] = download->filename;
 input[1] = download->user;
 input[2] = 0;
 input[3] = 0;

 clist = gtk_object_get_data(GTK_OBJECT(download_window),"clist");
 row = gtk_clist_append(GTK_CLIST(clist),input);
 gtk_clist_set_row_data(GTK_CLIST(clist),row,download);    

 download->size = 0;
 download->oldsize = 0;
 download->tag = gdk_input_add(download->socket,GDK_INPUT_READ,nap_handle_download,download);
 download->update_tag = gtk_timeout_add (5000,gnap_download_update,download);
}

gint gnap_download_update(gpointer user_data) 
{
 GtkCList *clist;
 transfer *download = NULL;
 gchar kbsec[10],percentleft[10];
 gint row;
 guint diff;

 download = user_data;

 clist = gtk_object_get_data(GTK_OBJECT(download_window),"clist");
 row = gtk_clist_find_row_from_data(clist,download);    

 // figure out transfer speed
 diff = download->size - download->oldsize;
 download->oldsize = download->size;
 sprintf(kbsec,"%.1f",(float)diff / 1024 / 5);

 // percent left
 sprintf(percentleft,"%.2f",(float)download->size/(float)(download->totalsize) * 100);

 // print data to clist
 gtk_clist_set_text(clist,row,2,percentleft);
 gtk_clist_set_text(clist,row,3,kbsec);

 return TRUE;
} 

void gnap_download_end(transfer *data) 
{
 GList *node;
 GtkCList *clist;
 gint row;

 clist = gtk_object_get_data(GTK_OBJECT(download_window),"clist");
 row = gtk_clist_find_row_from_data(clist,data);    
 gtk_clist_remove(GTK_CLIST(clist),row); 	

 node = g_list_find(downloads,data);
 g_list_remove_link(downloads,node);

 gdk_input_remove(data->tag);
 gtk_timeout_remove(data->update_tag);

 fclose(data->filehandle);
 close(data->socket);
 g_free(data);
 g_free(node);
}

void gnap_status(gchar *line) {

 gchar libraries[20], gigs[10], songs[30], status[100];

 sscanf(line,"  %s %s %s",libraries,songs,gigs);
 sprintf(status,"songs: %s  libraries: %s  gigs: %s",songs,libraries,gigs);
 gnome_appbar_pop(GNOME_APPBAR(the_window->appbar));
 gnome_appbar_push(GNOME_APPBAR(the_window->appbar),status);
}

void gnap_add_search_result(search_result *result) {
 gint row, seconds;
 gchar *row_of_results[7],*speed,size[12],bitrate[20],length[50];

 if(result) {    // yey i error checked!
  speed = gnap_int_to_connection(result->speed);
  sprintf(size,"%0.02f",(double)(result->size/1024)/1024);
  sprintf(bitrate,"%d",result->bitrate);
  // TODO: make this into minutes:seconds
  seconds = (result->size * 8) / (result->bitrate * 1024);
  sprintf(length,"%d:%02d",seconds/60,seconds%60);
  result->selected = 0;
 
  row_of_results[0] = gnap_strip_path(result->filename);
  row_of_results[1] = result->user;
  row_of_results[2] = speed;
  row_of_results[3] = size; 
  row_of_results[4] = bitrate;
  row_of_results[5] = length;
  row_of_results[6] = NULL;
  sr_list = g_list_append(sr_list,result);
  row = gtk_clist_append(GTK_CLIST(the_window->clist),row_of_results);
  gtk_clist_set_row_data(GTK_CLIST(the_window->clist),row,result);
 }
}

// all it does its puts the two strings together.
void gnap_error_dialog(gchar *string1,gchar * string2) 
{
 gchar buffer[strlen(string1) + strlen(string2)];

 bzero(buffer,sizeof(buffer));
 strcpy(buffer,string1);
 strcat(buffer,string2);
 gnome_error_dialog(buffer);
}

gchar *gnap_strip_path(gchar *input) 
{
 return(strrchr(input,'\\') + sizeof(gchar));
}

int gnap_connect (gpointer user_data)
{
  gboolean *new_user;
  new_user = (gboolean*)user_data;

  if(*new_user) 
   gnome_appbar_push(GNOME_APPBAR(the_window->appbar),_("Connecting... Creating account..."));
  else 
   gnome_appbar_push(GNOME_APPBAR(the_window->appbar),_("Connecting..."));

  napster_socket = nap_connect(
   gnome_config_get_string("/gnap/General/username"),
   gnome_config_get_string("/gnap/General/password"),
   6699,
   gnome_config_get_int("/gnap/General/connection"),
   *new_user);
  if(napster_socket != -1) {
   gdk_input_add(napster_socket,GDK_INPUT_READ,nap_handle_input,NULL);   
  } 
  return FALSE;
}

// please someone come up with a better way to
// hash up these values!@#!@#
gint gnap_connection_to_int(gchar *string) 
{
 if(!strcmp("14.4",string))		return 1;
 if(!strcmp("28.8",string))		return 2;
 if(!strcmp("33.6",string))		return 3;
 if(!strcmp("56k",string))		return 4;
 if(!strcmp("ISDN-64k",string))		return 5;
 if(!strcmp("ISDN-128k",string))	return 6;
 if(!strcmp("Cable",string))		return 7;
 if(!strcmp("DSL",string))		return 8;
 if(!strcmp("T1",string))		return 9;
 if(!strcmp("T3",string))		return 10;
 return 0;
}

gchar *gnap_int_to_connection(gint number) 
{
 switch(number) {
  case 1:  return(g_strdup("14.4"));
  case 2:  return(g_strdup("28.8"));
  case 3:  return(g_strdup("33.6"));
  case 4:  return(g_strdup("56k"));
  case 5:  return(g_strdup("ISDN-64k"));
  case 6:  return(g_strdup("ISDN-128k"));
  case 7:  return(g_strdup("Cable"));
  case 8:  return(g_strdup("DSL"));
  case 9:  return(g_strdup("T1"));
  case 10: return(g_strdup("T3"));
  default: return(g_strdup("Unknown")); 
 }
}

// 0 if fail
// 1 if saved
gint check_input(GnomeDialog *dialog, gpointer user_data)
{
 struct entrys{
  GtkWidget *username;
  GtkWidget *password;
  GtkWidget *email;
  GtkWidget *connection;
  GtkWidget *upload;
  GtkWidget *download;
 } *input;

 input = user_data;

 // make sure they entered stuff
 if(strlen(gtk_entry_get_text(GTK_ENTRY(input->username))) &&
    strlen(gtk_entry_get_text(GTK_ENTRY(input->password))) &&
    strlen(gtk_entry_get_text(GTK_ENTRY(input->email)))    &&
    strlen(gtk_entry_get_text(GTK_ENTRY(input->upload)))   &&
    strlen(gtk_entry_get_text(GTK_ENTRY(input->download))) &&
    strlen(gtk_entry_get_text(GTK_ENTRY(input->connection)))) {
  // save everything.
  gnome_config_set_string("/gnap/General/username",gtk_entry_get_text(GTK_ENTRY(input->username)));
  gnome_config_set_string("/gnap/General/password",gtk_entry_get_text(GTK_ENTRY(input->password)));
  gnome_config_set_string("/gnap/General/email",gtk_entry_get_text(GTK_ENTRY(input->email)));
  gnome_config_set_int("/gnap/General/connection",gnap_connection_to_int(gtk_entry_get_text(GTK_ENTRY(input->connection))));
  gnome_config_set_string("/gnap/General/upload_dir",gtk_entry_get_text(GTK_ENTRY(input->upload)));
  gnome_config_set_string("/gnap/General/download_dir",gtk_entry_get_text(GTK_ENTRY(input->download)));
  gnome_config_sync();
  printf("saved file\n");
  return 1;
 } else {
  missing_fields_dialog(); 
  printf("did not save file\n");
  return 0;
 }

}


int main (int argc, char *argv[])
{
  gboolean new_user = FALSE;

  the_window = g_malloc (sizeof (main_window));
  //bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  gnome_init ("gnap", VERSION, argc, argv);

  // check for losers
  if(!gnome_config_has_section("/gnap/General")) {
   if(create_undefined_user_window()) {
    // not new user :(
    new_user = FALSE;
    if(!create_new_user_window())
     return(0); 
   } else {
    // new user!
    new_user = TRUE;
    if(!create_new_user_window())
     return(0); 
   }
  }   

  download_window = create_download_window(); 
  properties_window = create_pref_window();
  create_main_window ();
  gtk_widget_show (the_window->app);
  gtk_idle_add(gnap_connect,&new_user);

  gtk_main ();
  return 0;
}
