
--  This test file is used to test that the values are correctly updated on
--  the canvas display.
--  In particular, the visible state of array components should be kept.

procedure Updating is

   type Arr is array (1 .. 3, 1 .. 100) of Integer;

   A : Arr := (others => (others => 0));

   procedure Set_Range_1 is
   begin
      for J in 20 .. 25 loop
         A (1, J) := 4;
      end loop;
   end Set_Range_1;

   procedure Set_Range_2 is
   begin
      for J in 23 .. 35 loop
         A (1, J) := 5;
      end loop;
   end Set_Range_2;

   type Point is record X, Y : Integer; end record;
   type Record_Array is array (1 .. 50) of Point;

   Ra : Record_Array := (others => (X => 0, Y => 0));

begin

   null;
   --  A should have three repeat items.

   A (1, 20) := 1;
   --  The first one should be split into three parts

   A (2,1) := 2;
   --  The second one should be split into two parts

   A (3, 100) := 3;
   --  The third one should be split into three parts

   Set_Range_1;
   --  The first one should be split into five parts

   Set_Range_2;
   --  Potential conflicts, since the new range overrides another one.


   null;

   Ra (5) := (X => 10, Y => 10);
   --  First line should be split into 3 parts

   --  Try to hide the item at index 5


   Ra (5) := (X => 11, Y => 4);
   --  Index 5 should still be hidden

   Ra (5).X := 20;
   --  Updating a single field (See if it is correctly highlighted).
end Updating;
