/*
 * util.c - libgnews utility functions
 * Copyright 2000-2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "../include/gnewslib.h"

/*
 * returns true if string is NULL or ""
 */

gboolean
isemptystr (gchar * str)
{
  gint ret = -1;

  if (str == NULL) {
    ret = 0;
  } else if (strcmp (str, "") == 0) {
    ret = 0;
  }
  return (ret == 0);
}

/*
 * wrap string
 * taken from php-4.0.6
 */

gchar *
wrapstring (gchar * text, gint linelength, gchar * breakchar, gint docut)
{
  gchar *newtext = NULL;
  gint i, l = 0, pgr, breakcharlen, last = 0;

  if (text != NULL) {
    breakcharlen = strlen (breakchar);
    newtext = g_malloc (strlen (text) * 2 + 1);
    newtext[0] = '\0';

    i = 0;
    while (text[i] != '\0') {
      l = 0;
      while (text[i + l] != '\0') {
	if (text[i + l] == breakchar[0]) {
	  if (breakcharlen == 1 || strncmp (text + i + l, breakchar, breakcharlen) == 0)
	    break;
	}
	l++;
      }
      if (l >= linelength) {
	pgr = l;
	l = linelength;

	while (l >= 0) {
	  if (text[i + l] == ' ') {
	    strncat (newtext, text + last, i + l - last);
	    strcat (newtext, breakchar);
	    last = i + l + 1;
	    break;
	  }
	  l--;
	}
	if (l == -1) {
	  l = linelength - 1;
	  while (l <= pgr) {
	    if (docut == 0) {
	      if (text[i + l] == ' ') {
		strncat (newtext, text + last, i + l - last);
		strcat (newtext, breakchar);
		last = i + l + 1;
		break;
	      }
	    }
	    if (docut == 1) {
	      if (text[i + l] == ' ' || l > i - last) {
		strncat (newtext, text + last, i + l - last + 1);
		strcat (newtext, breakchar);
		last = i + l + 1;
		break;
	      }
	    }
	    l++;
	  }
	}
	i += l + 1;
      } else {
	i += (l ? l : 1);
      }
    }
    if (i + l > last) {
      newtext = strcat (newtext, text + last);
    }
  }
  return (newtext);
}

gushort
getnumfield (gint num, gint field)
{
  return ((((num >> (field * 8)) & 255) + 1) * 256 - 1);
}
