/*
 * gnewslib.h - include for use with libgnews
 * Copyright 2000-2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef __GNEWSLIB_H_
#define __GNEWSLIB_H_

#include <string.h>
#include <glib.h>
#include <ghttp.h>

void set_http_options (gboolean use_p, gchar * p_url, gchar * p_user, gchar * p_passwd);
gchar *http_get_url (gchar * url);
gboolean isemptystr (gchar * str);
gchar *wrapstring (gchar * text, gint linelength, gchar * breakchar, gint docut);
gushort getnumfield (gint num, gint field);
GSList *gnews_parse_rdf (gchar * text);
GSList *gnews_parse_rss (gchar * text);
GSList *gnews_parse_txt (gchar * text, gchar * separator, gint recordlen,
			 gint prefix, gint titlerow, gint titlerows,
			 gint descriptionrow, gint descriptionrows, gint linkrow);
GSList *g_slist_merge (GSList * a, GSList * b);
gint str_count (gchar ** strings);
gchar *decode_html (gchar *s);
gchar *strip_tags (gchar *s);

typedef struct RDFItem rdfitem;
struct RDFItem {
  gchar *title;
  gchar *link;
  gchar *description;
};

typedef struct _sitedata sitedata;
struct _sitedata {
  gchar *name;
  gint titlefg;
  gint titlebg;
  gint descriptionfg;
  gint descriptionbg;
  gboolean has_new;
  GSList *headlines;
};

#endif /* __GNEWSLIB_H_ */
