/* defs.h -- data types and declarations.
   Copyright (C) 1990, 91, 92, 93, 94 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if defined(HAVE_STRING_H) || defined(STDC_HEADERS)
#include <string.h>
#else
#include <strings.h>
#ifndef strchr
#define strchr index
#endif
#ifndef strrchr
#define strrchr rindex
#endif
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <time.h>

#ifdef HAVE_GNU_REGEX
# include <regex.h>
#else
# include "gnu_regex.h"
#endif
#include "pred.h"
#include "win.h"

#if __STDC__
# define P_(s) s
#else
# define P_(s) ()
#endif

/* Not char because of type promotion; NeXT gcc can't handle it.  */
typedef int boolean;
#define		true    1
#define		false	0

/* The number of seconds in a day. */
#define		DAYSECS	    86400

/* Argument structures for predicates. */

/* find library function declarations.  */

/* listfile.c */
extern void list_file P_((win_t *w, char *name, char *relname, struct stat *statp, FILE *stream));
extern char *get_link_name P_((win_t *w, char *name, char *relname));

/* savedir.c */
extern char *savedir P_((char *dir, unsigned name_size));

/* stpcpy.c */
#ifdef HAVE_STPCPY
# define my_stpcpy	stpcpy
extern char *stpcpy P_((char *dest, const char *src));
#else
char *my_stpcpy P_((char *dest, const char *src));
#endif

/* xgetcwd.c */
char *xgetcwd P_((void));

/* xmalloc.c */
#if __STDC__
#define VOID void
#else
#define VOID char
#endif

/* find global function declarations.  */

/* fstype.c */
char *filesystem_type P_((win_t *w, char *path, char *relpath, struct stat *statp));

/* parser.c */
PFB find_parser P_((char *search_name));
boolean parse_close P_((win_t *w, char *argv[], int *arg_ptr));
boolean parse_open P_((win_t *w, char *argv[], int *arg_ptr));
boolean parse_print P_((win_t *w, char *argv[], int *arg_ptr));
boolean parse_wprint P_((win_t *w, char *argv[], int *arg_ptr));

/* pred.c */
boolean pred_amin P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_and P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_anewer P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_atime P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_close P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_cmin P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_cnewer P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_comma P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_ctime P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_empty P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_exec P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_false P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_fls P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_wls P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_fprint P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_fprint0 P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_fprintf P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_fstype P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_gid P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_group P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_ilname P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_iname P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_inum P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_ipath P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_links P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_lname P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_ls P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_mmin P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_mtime P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_name P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_negate P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_newer P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_nogroup P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_nouser P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_ok P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_open P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_or P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_path P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_perm P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_print P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_print0 P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_prune P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_regex P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_size P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_true P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_type P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_uid P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_used P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_user P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_wprint P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
boolean pred_xtype P_((win_t *w, char *pathname, struct stat *stat_buf, struct predicate *pred_ptr));
char *find_pred_name P_((PFB pred_func));
#ifdef DEBUG
void print_tree P_((struct predicate *node, int indent));
void print_list P_((struct predicate *node));
#endif /* DEBUG */

/* tree.c */
struct predicate *get_expr P_((win_t *, struct predicate **inp, int prev_prec));
boolean opt_expr P_((win_t *w, struct predicate **eval_treep));
boolean mark_stat P_((win_t *w, struct predicate *tree));

/* util.c */
struct predicate *get_new_pred P_((win_t *w));
struct predicate *get_new_pred_chk_op P_((win_t *w));
struct predicate *insert_primary P_((win_t *w, boolean (*pred_func )()));
void usage P_((win_t *w, char *msg));
