/* vi:set ts=8 sts=0 sw=8:
 * $Id: win.h,v 1.3 2001/01/26 08:36:04 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __WIN_H__
#define __WIN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <config.h>
#include "pred.h"

/*
 * Enumerate each widget type we are interested in.
 */
enum ef_wgt {
	Ef_wgt_toplev,
	Ef_wgt_dialog,
	Ef_wgt_button,
	Ef_wgt_checkbutton,
	Ef_wgt_radiobutton,
	Ef_wgt_entry,
	Ef_wgt_combo,
	Ef_wgt_clist,
	Ef_wgt_ctree,
	Ef_wgt_list,
	Ef_wgt_vbox,
	Ef_wgt_table,
	Ef_wgt_frame,
	Ef_wgt_notebook,
	Ef_wgt_spinbutton,
	Ef_wgt_optmenu,
	Ef_wgt_toolbar,
	Ef_wgt_label,
	Ef_wgt_menu,
	Ef_wgt_menuitem,
	Ef_wgt_dont_care
};
typedef enum ef_wgt ef_wgt_t;

/*
 * Enumerate each specific widget in each main window.
 */
enum ef_main_id_e {
	Ef_main_toplev,
	Ef_main_notebook,	/* notebook */
	Ef_main_filemenu,	/* menu */
	Ef_main_settingsmenu,	/* menu */
	Ef_main_viewmenu,	/* menu */
	Ef_main_helpmenu,	/* menu */
	Ef_main_msgbar,		/* label */
	Ef_main_file_new,	/* menuitem */
	Ef_main_quit,		/* menuitem */
	Ef_main_menu_prefs,	/* menuitem */
	Ef_main_search_menu,	/* menuitem */
	Ef_main_locate_menu,	/* menuitem */
	Ef_main_win_new,	/* menuitem */
	Ef_main_win_close,	/* menuitem */
	Ef_main_search_prev,	/* menuitem */
	Ef_main_cmd_prev,	/* menuitem */
	Ef_main_about,		/* menuitem */
	Ef_main_adv_search,	/* checkbutton */
	Ef_main_show_adv_opts,	/* button */
	Ef_main_frame_params,	/* frame */

	Ef_main_toolbar,
	Ef_main_clear,		/* button */
	Ef_main_search,		/* button */
	Ef_main_stop,		/* button */
	Ef_main_manual,		/* button */
	Ef_main_prefs,		/* button */
	Ef_main_close,		/* button */

	Ef_main_find_text,	/* entry */
	Ef_main_find_combo,	/* gnome entry */
	Ef_main_mult_files,	/* button */
	Ef_main_dir_text,	/* entry */
	Ef_main_dir_combo,	/* gnome file entry */
	Ef_main_mult_dirs,	/* button */
	Ef_main_search_subdir,	/* checkbutton */
	Ef_main_case_sens,	/* checkbutton */
	Ef_main_partial_fname,	/* checkbutton */
	Ef_main_regex_fname,	/* checkbutton */

	Ef_main_locate_text,	/* entry */
	Ef_main_locate_db,	/* entry */

	Ef_main_MAX
};
typedef enum ef_main_id_e ef_main_id_t;

/*
 * For just about all (glade) dialog windows, we'll probably be interested in a
 * number of widgets in that dialog window.  The most obvious way to get to
 * them is to simply call glade_xml_get_widget() on each specific widget, and
 * then possibly setup a callback routine.  e.g.,
 *
 *	dialog = glade_xml_get_widget(xml, "dialog1");
 *	entry = glade_xml_get_widget(xml, "entry1");
 *	ok_but = glade_xml_get_widget(xml, "ok_button");
 *	...
 *
 * That's just braindead.
 *
 * This structure is used to define a table of the widget names that we're
 * interested in.  This way, we simply loop through the table, with each table
 * entry giving us the information we need (glade widget name, callback, etc.).
 */
struct ef_s {
	char *		glname;
	int		wgt_id;
	ef_wgt_t	wgt_type;
	GtkSignalFunc	cb;
	gpointer	data;
};
typedef struct ef_s ef_t;

/* Info on each directory in the current tree branch, to avoid
   getting stuck in symbolic link loops.  */
struct dir_id
{
  ino_t ino;
  dev_t dev;
};

/* originally from lib/idcache.c */
struct userid
{
  union
    {
      uid_t u;
      gid_t g;
    } id;
  char *name;
  struct userid *next;
};


/*
 * The main window structure.
 */
struct win_s {
	GtkWidget **	mainwgts;	/* main window widgets */
	GtkWidget **	reswgts;	/* results/output window widgets */
	GtkWidget **	advwgts;	/* advanced option window widgets */
	GtkWidget **	filewgts;	/* multiple file widgets */
	GtkWidget **	dirwgts;	/* multiple directory widgets */
	GtkWidget **	pcmdwgts;	/* previous find command text dlg */
	GtkWidget **	finfowgts;	/* find info widgets */
	int		findopts;	/* see findopt_t */
	int		advopts;	/* see advopt_t */
	gboolean	stop_search;	/* stop current search? */
	gboolean	is_searching;	/* search in progress? */
	gboolean	close_window;	/* win close requested */
	guint		num_found;	/* num files found */
	guint		num_errs;	/* num errors during search */

	GtkWidget *	msgbar;		/* convenience pointer */
	char *		lastmsg;	/* last message in message bar */
	guint		timeout_id;	/* msgbar timeout id */
	GtkProgress *	progbar;	/* convenience pointer */


	/*** various statics/globals used in the original find code ***/

	/* originally in lib/idcache.c */
	struct userid *user_alist;

	/* The members of this list have names not in the local passwd file. */
	struct userid *nouser_alist;

	/* Use the same struct as for userids.  */
	struct userid *group_alist;
	struct userid *nogroup_alist;


	/* originally in lib/listfile.c */
	int kilobytes;	/* -1 = uninitialized, 0 = 512, 1 = 1024. */

	
	/* originally in pred.c */
	gboolean	launch_first_time;	/* used in launch() */

	/* originally in fstype.c */
	gboolean	fstype_known;		/* filesystem_type() */
	char *		cur_fstype;		/* filesystem_type() */
	dev_t		cur_dev;		/* filesystem_type() */

	/* originally in find.c */
	/* Name this program was run with. */
	char *program_name;

	/* All predicates for each path to process. */
	struct predicate *predicates;

	/* The last predicate allocated. */
	struct predicate *last_pred;

	/* The root of the evaluation tree. */
	struct predicate *eval_tree;

	/* If true, process directory b4 contents.  True unless -depth given. */
	gboolean do_dir_first;

	/* If >=0, don't descend more than this many levels of subdirs. */
	int maxdepth;

	/* If >=0, don't process files above this level. */
	int mindepth;

	/* Current depth; 0 means current path is a command line arg. */
	int curdepth;

	/* Seconds between 00:00 1/1/70 and either one day before now
	   (the default), or the start of today (if -daystart is given). */
	time_t cur_day_start;

	/* If true, cur_day_start has been adjusted to the start of the day. */
	gboolean full_days;

	/* If true, do not assume that files in directories with nlink == 2
	   are non-directories. */
	gboolean no_leaf_check;

	/* If true, don't cross filesystem boundaries. */
	gboolean stay_on_filesystem;

	/* If true, don't descend past current directory.
	   Can be set by -prune, -maxdepth, and -xdev/-mount. */
	gboolean stop_at_current_level;

#ifndef HAVE_FCHDIR
	/* The full path of the initial working directory.  */
	char *starting_dir;
#else
	/* A file descriptor open to the initial working directory.
	   Doing it this way allows us to work when the i.w.d. has
	   unreadable parents.  */
	int starting_desc;
#endif

	/* If true, we have called stat on the current path. */
	gboolean have_stat;

	/* The file being operated on, relative to the current directory.
	   Used for stat, readlink, and opendir.  */
	char *rel_pathname;

	/* Length of current path. */
	int path_length;

	/* true if following symlinks.  Should be consistent with xstat.  */
	gboolean dereference;

	/* Pointer to the function used to stat files. */
	int (*xstat) ();

	/* Status value to return to system. */
	int exit_status;

	struct dir_id *dir_ids;
	/* Entries allocated in `dir_ids'.  */
	int dir_alloc;
	/* Index in `dir_ids' of directory currently being searched.
	   This is always the last valid entry.  */
	int dir_curr;

	dev_t root_dev;	/* Device ID of current argument pathname. */

	/* originally in parser.c */
#ifdef CACHE_IDS
	/* Boolean: if uid_unused[n] is nonzero, then UID n has no passwd
	 * entry. */
	char *uid_unused;

	/* Number of elements in `uid_unused'. */
	unsigned uid_allocated;

	/* Similar for GIDs and group entries. */
	char *gid_unused;
	unsigned gid_allocated;
#endif

#if 0
	/* originally in locate.c */
	char *globfree;		/* copy of the subpattern in NAME */
	size_t gfalloc;		/* bytes allocated for "globfree" */

	/* originally in nextelem.c */
	char *path;		/* Freshly allocated copy of NEW_PATH.  */
	char *end;		/* Start of next element to return.  */
	int final_colon;	/* If zero, path didn't end with a colon.  */
#endif

}; /* win_s */
typedef struct win_s win_t;


extern void	win_close_cb(GtkWidget *wgt, gpointer cbdata);
extern void	win_prefs_set(win_t *w);
extern void	win_fd_entry_sensitive(win_t *, gboolean, gboolean);
extern void	win_fd_entry_setclear(win_t *, gboolean, gboolean);
extern GtkWidget *win_main_toplev(win_t *w);
extern void	win_progbar_update(win_t *w);
extern win_t *	win_new(void);
extern void	win_wprint(win_t *w, char *path, struct stat *sb,
			   struct predicate *pred);
extern void	win_widgets_setup(GladeXML *xml, win_t *w,
				  GtkWidget **wgts, ef_t *efp);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __WIN_H__ */
