/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using Gtk;
using Gdk;
using System;
using System.Data;
using System.Collections;
using System.Collections.Generic;
using System.IO;

using Mono.Data.SqliteClient;
using Mono.Unix;

namespace GnomeRDP
{
	public class Configuration
	{
        
		public Configuration()
		{
		}
		
		private string _sessionName = "";
		public string SessionName
		{
			get {return _sessionName;}
			set {_sessionName = value;}
		}
		
		private int	_protocol = 0;
		public int Protocol
		{
			get {return _protocol;}
			set {_protocol = value;}
		}

		private string _computer = "";
		public string Computer
		{
			get {return _computer;}
			set {_computer = value;}
		}

		private string _user = "";
		public string User
		{
			get {return _user;}
			set {_user = value;}
		}

		private string _password = "";
		public string Password
		{
			get {return _password;}
			set {_password = value;}
		}

		private string _domain = "";
		public string Domain
		{
			get {return _domain;}
			set {_domain = value;}
		}

		private int	_srvType = 0;
		public int SrvType
		{
			get {return _srvType;}
			set {_srvType = value;}
		}

		private int	_colorDepth = 0;
		public int ColorDepth
		{
			get {return _colorDepth;}
			set {_colorDepth = value;}
		}

		private int	_screenResolutionX = 640;
		public int ScreenResolutionX
		{
			get {return _screenResolutionX;}
			set {_screenResolutionX = value;}
		}

		private int	_screenResolutionY = 480;
		public int ScreenResolutionY
		{
			get {return _screenResolutionY;}
			set {_screenResolutionY = value;}
		}		

		private int _soundRedirection = 0;
		public int SoundRedirection
		{
			get {return _soundRedirection;}
			set {_soundRedirection = value;}
		}

		private string _keyboardLang = "en-us";
		public string KeyboardLang
		{
			get {return _keyboardLang;}
			set {_keyboardLang = value;}
		}

		private int	_connectionType = 0;
		public int ConnectionType
		{
			get {return _connectionType;}
			set {_connectionType = value;}
		}

		private int	_windowMode = 0;
		public int WindowMode
		{
			get {return _windowMode;}
			set {_windowMode = value;}
		}

		private int	_terminalSize = 0;
		public int TerminalSize
		{
			get {return _terminalSize;}
			set {_terminalSize = value;}
		}

		private int	_compressionLevel = 0;
		public int CompressionLevel
		{
			get {return _compressionLevel;}
			set {_compressionLevel = value;}
		}

		private int	_imageQuality = 0;
		public int ImageQuality
		{
			get {return _imageQuality;}
			set {_imageQuality = value;}
		}

		private int	_id;
		public int Id
		{
			get {return _id;}
		}		

		private int	_parentId = 0;
		public int ParentId
		{
			get {return _parentId;}
			set {_parentId = value;}
		}		

		private bool _isCategory = false;
		public bool IsCategory
		{
			get {return _isCategory;}
			set {_isCategory = value;}
		}		

		public static void CreateDatabase()
		{
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			
			db.Query("CREATE TABLE version (" +
				"id INTEGER PRIMARY KEY, " +
				"dbversion VARCHAR(10))");
			db.FreeResult();
			
			db.Query("INSERT INTO version (id, dbversion) " +
				"VALUES (1, '" + Defines.REQUIRED_DBVERSION + "')");
			db.FreeResult();
			
			db.Query("CREATE TABLE session (" +
				"id INTEGER PRIMARY KEY, " +
				"parentid INTEGER, " +
				"iscategory BOOL, " +
				"sessionname VARCHAR(300), " +
				"protocol INTEGER, " +
				"computer VARCHAR(300), " +
				"user VARCHAR(300), " +
				"password VARCHAR(300), " +
				"domain VARCHAR(300), " +
				"srvtype INTEGER, " +
				"colordepth INTEGER, " +
				"screenresolutionx INTEGER, " +
				"screenresolutiony INTEGER, " +
				"soundredirection INTEGER, " +
				"keyboardlang VARCHAR(10), " +
				"connectiontype INTEGER, " +
				"windowmode INTEGER, " +
				"terminalsize INTEGER, " +
				"compressionlevel INTEGER, " +
				"imagequality INTEGER)");
			db.Close();		
		}
		
		public static bool CheckDatabaseVersion()
		{
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			try
			{
				db.Query("SELECT * FROM version WHERE id = 1");
				
				IDataReader result;
				if (db.FetchRow(out result))
				{
					string version = result["dbversion"].ToString();
					switch(version)
					{
					case Defines.REQUIRED_DBVERSION: return true;
					case "0.2.0": return ConvertFrom0_2_0();
					default: return false;
					}				
				}
				
				return false;
			}
			finally
			{
				db.Close();
			}
		}
		
		private static bool ConvertFrom0_2_0()
		{
			try
			{
				Console.Write(Catalog.GetString("Upgrading database to ") + Defines.REQUIRED_DBVERSION + "... ");
				
				string tmpFileName = System.IO.Path.GetTempFileName();
				System.IO.File.Delete(tmpFileName);
				System.IO.File.Move(Defines.DatabasePath, tmpFileName);
				CreateDatabase();
				
				Sqlite db = new Sqlite(null);
				db.Connect(tmpFileName);
				db.Query("SELECT * FROM session");

				IDataReader result;
				while (db.FetchRow(out result))
				{
					Configuration cfg = new Configuration();
					cfg._id = Convert.ToInt32(result["id"].ToString());
					cfg._parentId = Convert.ToInt32(result["parentid"].ToString());
					cfg._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
					cfg._colorDepth = Convert.ToInt32(result["colordepth"].ToString());
					cfg._compressionLevel = Convert.ToInt32(result["compressionlevel"].ToString());
					cfg._computer = result["computer"].ToString();
					cfg._connectionType = Convert.ToInt32(result["connectiontype"].ToString());
					cfg._domain = result["domain"].ToString();
					cfg._imageQuality = Convert.ToInt32(result["imagequality"].ToString());
					cfg._keyboardLang = result["keyboardlang"].ToString();
					cfg._password = result["password"].ToString();
					cfg._protocol = Convert.ToInt32(result["protocol"].ToString());
					switch (Convert.ToInt32(result["screenresolution"].ToString()))
					{
						case 0:
							cfg._screenResolutionX = 640;
							cfg._screenResolutionY = 480;
							break;
						case 1:
							cfg._screenResolutionX = 800;
							cfg._screenResolutionY = 600;
							break;
						case 2:
							cfg._screenResolutionX = 0;
							cfg._screenResolutionY = 0;
							break;
					}
					cfg._sessionName = result["sessionname"].ToString();
					cfg._soundRedirection = Convert.ToInt32(result["soundredirection"].ToString());
					cfg._srvType = Convert.ToInt32(result["srvtype"].ToString());
					cfg._terminalSize = Convert.ToInt32(result["terminalsize"].ToString());
					cfg._user = result["user"].ToString();
					cfg._windowMode = Convert.ToInt32(result["windowmode"].ToString());
					cfg.SaveSession((cfg.Password.Length > 0 ? true : false), true);
				}	
				db.Close();
			}
			catch
			{
				Console.WriteLine(Catalog.GetString("Failed to convert database..."));
				return false;
			}
			Console.WriteLine(Catalog.GetString("Successful"));
			return true;
		}
		
		public void DeleteSession()
		{
			if (!this.IsCategory)
			{
				Sqlite db = new Sqlite(null);
				db.Connect(Defines.DatabasePath);
				db.Query("DELETE FROM session WHERE id = " + this._id);
				db.Close();
			}
			else
			{
				Sqlite db = new Sqlite(null);
				db.Connect(Defines.DatabasePath);
				DeleteCategoryTreeRecursive(db, this._id);
				db.Query("DELETE FROM session WHERE id = " + this._id);
				db.Close();
			}
					
		}
		
		private static void DeleteCategoryTreeRecursive(Sqlite db, int parentId)
		{
			foreach (Configuration cfg in Configuration.LoadSessions())
			{
				if (cfg.ParentId == parentId)
				{
					if (cfg.IsCategory)
					{
						DeleteCategoryTreeRecursive(db, cfg.Id);
					}
					db.Query("DELETE FROM session WHERE id = " + cfg.Id);
				}
			}	
		}
		
		public void UpdateSession(bool IsSavePasswd)
		{
            bool useKeyring = Options.UseKeyring;
			string password = (IsSavePasswd && useKeyring == false ? this._password : "");
						
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			db.Query("UPDATE session SET " +
				"parentid = " + this._parentId + ", " +
				"iscategory = " + Convert.ToInt32(this._isCategory) + ", " +
				"sessionname = '" + this.SessionName.Replace("'", "''") + "', " +
				"protocol = " + this._protocol + ", " +
				"computer = '" + this._computer + "', " +
				"user = '" + this._user + "', " +
				"password = '" + password + "', " +
				"domain = '" + this._domain + "', " +
				"srvtype = " + this._srvType + ", " +
				"colordepth = " + this._colorDepth + ", " +
				"screenresolutionx = " + this._screenResolutionX + ", " +
				"screenresolutiony = " + this._screenResolutionY + ", " +
				"soundredirection = " + this._soundRedirection + ", " +
				"keyboardlang = '" + this._keyboardLang + "', " +
				"connectiontype = " + this._connectionType + ", " +
				"windowmode = " + this._windowMode + ", " +
				"terminalsize = " + this._terminalSize + ", " +
				"compressionlevel = " + this._compressionLevel + ", " +
				"imagequality = " + this._imageQuality + " " +
				"WHERE id = " + this._id);
			db.Close();
			
			if(IsSavePasswd && useKeyring)
			{				
				KeyringProxy.SetPassword(this.User, this.Domain, this.Computer, this.Protocol, this.Password);
			}
		
		}
		
		public void SaveSession(bool IsSavePasswd, bool WithId)
		{
			bool useKeyring = Options.UseKeyring;
			string password = (IsSavePasswd && useKeyring == false ? this._password : "");
			
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			db.Query("INSERT INTO session (" +
				(WithId ? "id, ":"") +
				"parentid, " +
				"iscategory, " +
				"sessionname, " +
				"protocol, " +
				"computer, " +
				"user, " +
				"password, " +
				"domain, " +
				"srvtype, " +
				"colordepth, " + 
				"screenresolutionx, " +
				"screenresolutiony, " +
				"soundredirection, " +
				"keyboardlang, " +
				"connectiontype, " +
				"windowmode, " +
				"terminalsize, " +
				"compressionlevel, " +
				"imagequality) " +
				"VALUES (" + 
				(WithId ? this.Id + ", ":"") +
				this.ParentId + ", " +
				Convert.ToInt32(this.IsCategory) + ", '" +
				this.SessionName.Replace("'", "''") + "', " +
				this.Protocol + ", '" + 
				this.Computer +	"', '" + 
				this.User + "', '" + 
				password + "', '" + 
				this.Domain + "', " + 
				this.SrvType + ", " + 
				this.ColorDepth + ", " + 
				this.ScreenResolutionX + ", " +
				this.ScreenResolutionY + ", " +
				this.SoundRedirection + ", '" + 
				this.KeyboardLang + "', " + 
				this.ConnectionType + ", " + 
				this.WindowMode + ", " + 
				this.TerminalSize +	", " + 
				this.CompressionLevel + ", " + 
				this.ImageQuality +")");
			db.Close();
			
			if(IsSavePasswd && useKeyring)
			{				
				KeyringProxy.SetPassword(this.User, this.Domain, this.Computer, this.Protocol, this.Password);
			}
		}
		
		public static Configuration[] LoadSessions()
		{
			bool useKeyring = Options.UseKeyring;

			List<Configuration> sessions = new List<Configuration>();
			
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			db.Query("SELECT * FROM session ORDER BY iscategory DESC, sessionname");
			
			IDataReader result;	
			while (db.FetchRow(out result))
			{
				Configuration cfg = new Configuration();
				cfg._id = Convert.ToInt32(result["id"].ToString());
				cfg._parentId = Convert.ToInt32(result["parentid"].ToString());
				cfg._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
				cfg._colorDepth = Convert.ToInt32(result["colordepth"].ToString());
				cfg._compressionLevel = Convert.ToInt32(result["compressionlevel"].ToString());
				cfg._computer = result["computer"].ToString();
				cfg._connectionType = Convert.ToInt32(result["connectiontype"].ToString());
				cfg._domain = result["domain"].ToString();
				cfg._imageQuality = Convert.ToInt32(result["imagequality"].ToString());
				cfg._keyboardLang = result["keyboardlang"].ToString();
				cfg._password = result["password"].ToString();
				cfg._protocol = Convert.ToInt32(result["protocol"].ToString());
				cfg._screenResolutionX = Convert.ToInt32(result["screenresolutionx"].ToString());
				cfg._screenResolutionY = Convert.ToInt32(result["screenresolutiony"].ToString());
				cfg._sessionName = result["sessionname"].ToString();
				cfg._soundRedirection = Convert.ToInt32(result["soundredirection"].ToString());
				cfg._srvType = Convert.ToInt32(result["srvtype"].ToString());
				cfg._terminalSize = Convert.ToInt32(result["terminalsize"].ToString());
				cfg._user = result["user"].ToString();
				cfg._windowMode = Convert.ToInt32(result["windowmode"].ToString());
				
				if(useKeyring && cfg.Protocol != 99)
				{				
					string password = KeyringProxy.GetPassword(cfg.User, cfg.Domain, cfg.Computer, cfg.Protocol);
					cfg._password = (password == null) ? "" : password;
				}
				
				sessions.Add(cfg);
			}
			db.Close();			
			
			return sessions.ToArray();
		}
		
		[Obsolete]
		public void LoadSessionData(string sessionName)
		{
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			db.Query("SELECT * FROM session WHERE sessionname = '" + sessionName.Replace("'", "''") + "'");
			
			IDataReader result;
			if (db.FetchRow(out result))
			{
				this._id = Convert.ToInt32(result["id"]);
				this._parentId = Convert.ToInt32(result["parentid"]);
				this._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
				this._colorDepth = Convert.ToInt32(result["colordepth"]);
				this._computer = result["computer"].ToString();
				this._connectionType = Convert.ToInt32(result["connectiontype"]);
				this._domain = result["domain"].ToString();
				this._keyboardLang = result["keyboardlang"].ToString();
				this._password = result["password"].ToString();
				this._protocol = Convert.ToInt32(result["protocol"]);
				this._screenResolutionX = Convert.ToInt32(result["screenresolutionx"]);
				this._screenResolutionY = Convert.ToInt32(result["screenresolutiony"]);
				this._soundRedirection = Convert.ToInt32(result["soundredirection"]);
				this._srvType = Convert.ToInt32(result["srvtype"]);
				this._terminalSize = Convert.ToInt32(result["terminalsize"]);
				this._user = result["user"].ToString();
				this._windowMode = Convert.ToInt32(result["windowmode"]);
				this._compressionLevel = Convert.ToInt32(result["compressionlevel"].ToString());
				this._imageQuality = Convert.ToInt32(result["imagequality"].ToString());				
			}
			db.Close();			
		}
		
		public static Configuration[] LoadCategories()
		{
			List<Configuration> categories = new List<Configuration>();
			
			Sqlite db = new Sqlite(null);
			db.Connect(Defines.DatabasePath);
			db.Query("SELECT * FROM session WHERE iscategory = 1 ORDER BY sessionname");

			IDataReader result;
			while (db.FetchRow(out result))
			{
				Configuration cfg = new Configuration();
				cfg._id = Convert.ToInt32(result["id"].ToString());
				cfg._parentId = Convert.ToInt32(result["parentid"].ToString());
				cfg._sessionName = result["sessionname"].ToString();
				cfg.Protocol = Convert.ToInt32(result["protocol"].ToString());
				cfg._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
				categories.Add(cfg);
			}
			db.Close();
			
			return categories.ToArray();		
		}
	}
}
