#include "rbgnome.h"

VALUE mGnomeConfig;

static VALUE
config_push_prefix(self, prefix)
    VALUE self, prefix;
{
    gnome_config_push_prefix(STR2CSTR(prefix));
    return self;
}

static VALUE
config_set_string(self, path, new_value)
    VALUE self, path, new_value;
{
    gnome_config_set_string(STR2CSTR(path), STR2CSTR(new_value));
    return self;
}

static VALUE
config_set_translated_string(self, path, new_value)
    VALUE self, path, new_value;
{
    gnome_config_set_translated_string(STR2CSTR(path), STR2CSTR(new_value));
    return self;
}

static VALUE
config_set_int(self, path, new_value)
    VALUE self, path, new_value;
{
    gnome_config_set_int(STR2CSTR(path), NUM2INT(new_value));
    return self;
}

static VALUE
config_set_float(self, path, new_value)
    VALUE self, path, new_value;
{
    gnome_config_set_float(STR2CSTR(path), NUM2DBL(new_value));
    return self;
}

static VALUE
config_set_bool(self, path, new_value)
    VALUE self, path, new_value;
{
    gnome_config_set_bool(STR2CSTR(path), RTEST(new_value));
    return self;
}

static VALUE
config_pop_prefix(self)
    VALUE self;
{
    gnome_config_pop_prefix();
    return self;
}

static VALUE
config_sync(self)
    VALUE self;
{
    gnome_config_sync();
    return self;
}

static VALUE
config_get_real_path(self, path)
    VALUE self, path;
{
    gchar *real_path;
    Check_Type(path, T_STRING);
    real_path = gnome_config_get_real_path(STR2CSTR(path));
    return rb_str_new2(real_path);
}

void
Init_gnome_config()
{
    mGnomeConfig = rb_define_module_under(mGnome, "Config");

    rb_define_module_function(mGnomeConfig, "push_prefix",
			      config_push_prefix, 1);
    rb_define_module_function(mGnomeConfig, "set_string",
			      config_set_string, 2);
    rb_define_module_function(mGnomeConfig, "set_translated_string",
			      config_set_translated_string, 2);
    rb_define_module_function(mGnomeConfig, "set_int",
			      config_set_int, 2);
    rb_define_module_function(mGnomeConfig, "set_float",
			      config_set_float, 2);
    rb_define_module_function(mGnomeConfig, "set_bool",
			      config_set_bool, 2);
    rb_define_module_function(mGnomeConfig, "pop_prefix",
			      config_pop_prefix, 0);
    rb_define_module_function(mGnomeConfig, "sync",
			      config_sync, 0);
    rb_define_module_function(mGnomeConfig, "get_real_path",
			      config_get_real_path, 1);
}
