/* $Id: rbgnome-href.c,v 1.1.1.1 2000/03/29 18:43:12 iga Exp $ */

#include "rbgnome.h"

/*
 * Class Gnome::HRef
 *
 * Description:
 *   ...
 *
 * Hierarchy:
 *
 *   Object
 *     +----Gtk::Object
 *            +----Gtk::Widget
 *                   +----Gtk::Container
 *                          +----Gtk::Bin
 *                                 +----Gtk::Button
 *                                        +----Gnome::HRef
 */

VALUE gnoHRef;

static VALUE
href_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE url, label;
    GtkWidget *href;

    rb_scan_args(argc, argv, "02", &url, &label);
    href = gnome_href_new(NIL_P(url)?0:STR2CSTR(url),
			  NIL_P(label)?0:STR2CSTR(label));
    set_widget(self, href);
    return Qnil;
}

static VALUE
href_set_url(self, url)
    VALUE self, url;
{
    gnome_href_set_url(GNOME_HREF(get_widget(self)), STR2CSTR(url));
    return self;
}

static VALUE
href_get_url(self)
    VALUE self;
{
    gchar* url;
    url = gnome_href_get_url(GNOME_HREF(get_widget(self)));
    return rb_str_new2(url);
}

static VALUE
href_set_label(self, label)
    VALUE self, label;
{
    gnome_href_set_label(GNOME_HREF(get_widget(self)), STR2CSTR(label));
    return self;
}

static VALUE
href_get_label(self)
    VALUE self;
{
    gchar* label;
    label = gnome_href_get_label(GNOME_HREF(get_widget(self)));
    return rb_str_new2(label);
}

void
Init_gnome_href()
{
    gnoHRef = rb_define_class_under(mGnome, "HRef", gButton);

    rb_define_method(gnoHRef, "initialize", href_initialize, -1);
    rb_define_method(gnoHRef, "set_url", href_set_url, 1);
    rb_define_method(gnoHRef, "get_url", href_get_url, 0);
    rb_define_method(gnoHRef, "set_label", href_set_label, 1);
    rb_define_method(gnoHRef, "get_label", href_get_label, 0);
}

